/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.entity;

import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.goals.actions.FollowParentGoal;
import com.lycanitesmobs.core.entity.goals.actions.MateGoal;
import com.lycanitesmobs.core.entity.goals.targeting.FindParentGoal;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.Subspecies;
import com.lycanitesmobs.core.item.ItemCustomSpawnEgg;
import java.util.HashMap;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;

public abstract class AgeableCreatureEntity
extends BaseCreatureEntity {
    private float scaledWidth = -1.0f;
    private float scaledHeight;
    private AgeableCreatureEntity breedingTarget;
    public int growthTime = -24000;
    public boolean canGrow = true;
    public double babySpawnChance = 0.0;
    public int loveTime;
    private int loveTimeMax = 600;
    public int breedingCooldown = 6000;
    public boolean hasBeenFarmed = false;
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(AgeableCreatureEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> LOVE = EntityDataManager.func_187226_a(AgeableCreatureEntity.class, (IDataSerializer)DataSerializers.field_187192_b);

    public AgeableCreatureEntity(EntityType<? extends AgeableCreatureEntity> entityType, World world) {
        super(entityType, world);
    }

    @Override
    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(AGE, (Object)0);
        this.field_70180_af.func_187214_a(LOVE, (Object)0);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(this.nextDistractionGoalIndex++, (Goal)new MateGoal(this).setMateDistance(5.0));
        super.func_184651_r();
        this.field_70715_bh.func_75776_a(this.nextFindTargetIndex++, (Goal)new FindParentGoal(this).setSightCheck(false).setDistance(32.0));
        this.field_70714_bg.func_75776_a(this.nextTravelGoalIndex++, (Goal)new FollowParentGoal(this).setSpeed(1.0).setStrayDistance(3.0));
    }

    @Override
    public void setupMob() {
        if (this.babySpawnChance > 0.0 && this.field_70146_Z.nextDouble() < this.babySpawnChance) {
            this.setGrowingAge(this.growthTime);
        }
        super.setupMob();
    }

    @Override
    public ITextComponent getAgeName() {
        if (this.func_70631_g_()) {
            return new TranslationTextComponent("entity.baby", new Object[0]);
        }
        return super.getAgeName();
    }

    @Override
    public boolean isPersistant() {
        if (this.hasBeenFarmed) {
            return true;
        }
        return super.isPersistant();
    }

    public void setFarmed() {
        this.hasBeenFarmed = true;
        if (this.field_71088_bW > this.func_82147_ab()) {
            this.field_71088_bW = this.func_82147_ab();
        }
    }

    @Override
    public void getRandomSubspecies() {
        if (this.func_70631_g_()) {
            return;
        }
        super.getRandomSubspecies();
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.func_130014_f_().field_72995_K) {
            this.setScaleForAge(this.func_70631_g_());
        } else if (this.canGrow) {
            int age = this.getGrowingAge();
            if (age < 0) {
                this.setGrowingAge(++age);
            } else if (age > 0) {
                this.setGrowingAge(--age);
            }
        }
        if (!this.canBreed()) {
            this.loveTime = 0;
        }
        if (!this.func_130014_f_().field_72995_K) {
            this.field_70180_af.func_187227_b(LOVE, (Object)this.loveTime);
        }
        if (this.func_130014_f_().field_72995_K) {
            this.loveTime = this.getIntFromDataManager(LOVE);
        }
        if (this.isInLove()) {
            this.setFarmed();
            --this.loveTime;
            if (this.func_130014_f_().field_72995_K) {
                BasicParticleType particle = ParticleTypes.field_197633_z;
                if (this.loveTime % 10 == 0) {
                    double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                    double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                    this.func_130014_f_().func_195594_a((IParticleData)particle, this.func_213303_ch().func_82615_a() + (double)(this.field_70146_Z.nextFloat() * this.func_213305_a((Pose)Pose.STANDING).field_220315_a * 2.0f) - (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.func_213303_ch().func_82617_b() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213305_a((Pose)Pose.STANDING).field_220316_b), this.func_213303_ch().func_82616_c() + (double)(this.field_70146_Z.nextFloat() * this.func_213305_a((Pose)Pose.STANDING).field_220315_a * 2.0f) - (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, d0, d1, d2);
                }
            }
        }
    }

    @Override
    protected void func_70619_bc() {
        if (!this.canBreed()) {
            this.loveTime = 0;
        }
        super.func_70619_bc();
    }

    @Override
    public HashMap<Integer, String> getInteractCommands(PlayerEntity player, @Nonnull ItemStack itemStack) {
        HashMap<Integer, String> commands = new HashMap<Integer, String>();
        commands.putAll(super.getInteractCommands(player, itemStack));
        if (!itemStack.func_190926_b()) {
            CreatureInfo creatureInfo;
            if (itemStack.func_77973_b() instanceof ItemCustomSpawnEgg && (creatureInfo = ((ItemCustomSpawnEgg)itemStack.func_77973_b()).getCreatureInfo(itemStack)) == this.creatureInfo) {
                commands.put(BaseCreatureEntity.COMMAND_PIORITIES.ITEM_USE.id, "Spawn Baby");
            }
            if (this.isBreedingItem(itemStack) && this.canBreed() && !this.isInLove()) {
                commands.put(BaseCreatureEntity.COMMAND_PIORITIES.ITEM_USE.id, "Breed");
            }
        }
        return commands;
    }

    @Override
    public boolean performCommand(String command, PlayerEntity player, ItemStack itemStack) {
        if (command.equals("Spawn Baby") && !this.func_130014_f_().field_72995_K && itemStack.func_77973_b() instanceof ItemCustomSpawnEgg) {
            AgeableCreatureEntity baby;
            ItemCustomSpawnEgg itemCustomSpawnEgg = (ItemCustomSpawnEgg)itemStack.func_77973_b();
            CreatureInfo spawnEggCreatureInfo = itemCustomSpawnEgg.getCreatureInfo(itemStack);
            if (spawnEggCreatureInfo != null && spawnEggCreatureInfo.entityClass != null && spawnEggCreatureInfo.entityClass.isAssignableFrom(((Object)((Object)this)).getClass()) && (baby = this.createChild(this)) != null) {
                baby.setGrowingAge(baby.growthTime);
                baby.func_70012_b(this.func_213303_ch().func_82615_a(), this.func_213303_ch().func_82617_b(), this.func_213303_ch().func_82616_c(), 0.0f, 0.0f);
                baby.setFarmed();
                this.func_130014_f_().func_217376_c((Entity)baby);
                if (itemStack.func_82837_s()) {
                    baby.func_200203_b(itemStack.func_200301_q());
                }
                this.consumePlayersItem(player, itemStack);
            }
            return true;
        }
        if (command.equals("Breed") && this.breed()) {
            this.consumePlayersItem(player, itemStack);
            return true;
        }
        return super.performCommand(command, player, itemStack);
    }

    public int getGrowingAge() {
        return this.getIntFromDataManager(AGE);
    }

    public void setGrowingAge(int age) {
        this.field_70180_af.func_187227_b(AGE, (Object)age);
        this.setScaleForAge(this.func_70631_g_());
    }

    public void addGrowth(int growth) {
        int age = this.getGrowingAge();
        if ((age += growth * 20) > 0) {
            age = 0;
        }
        this.setGrowingAge(age);
    }

    public boolean func_70631_g_() {
        return this.getGrowingAge() < 0;
    }

    public boolean shouldFollowParent() {
        return this.func_70631_g_();
    }

    public boolean shouldFindParent() {
        return this.func_70631_g_();
    }

    public double setScaleForAge(boolean adult) {
        return adult ? 0.5 : 1.0;
    }

    @Override
    public boolean canBeTempted() {
        return !this.isInLove() && super.canBeTempted();
    }

    public AgeableCreatureEntity getBreedingTarget() {
        return this.breedingTarget;
    }

    public void setBreedingTarget(AgeableCreatureEntity target) {
        this.breedingTarget = target;
    }

    public AgeableCreatureEntity createChild(AgeableCreatureEntity partner) {
        return (AgeableCreatureEntity)this.creatureInfo.createEntity(this.func_130014_f_());
    }

    public boolean isBreedingItem(ItemStack itemStack) {
        if (!this.creatureInfo.isFarmable() || this.func_70086_ai() <= -100) {
            return false;
        }
        return this.creatureInfo.canEat(itemStack);
    }

    public boolean canBreedWith(AgeableCreatureEntity partner) {
        if (partner == this) {
            return false;
        }
        if (((Object)((Object)partner)).getClass() != ((Object)((Object)this)).getClass()) {
            return false;
        }
        if (this.getSubspecies() == null) {
            if (partner.getSubspecies() != null && partner.getSubspecies().skin != null) {
                return false;
            }
        } else if (this.getSubspecies().skin != null) {
            if (partner.getSubspecies() == null) {
                return false;
            }
            if (!this.getSubspecies().skin.equals(partner.getSubspecies().skin)) {
                return false;
            }
        }
        return this.isInLove() && partner.isInLove();
    }

    public boolean isInLove() {
        return this.loveTime > 0;
    }

    public boolean canMate() {
        return this.isInLove();
    }

    public boolean breed() {
        if (!this.canBreed()) {
            return false;
        }
        this.loveTime = this.loveTimeMax;
        return true;
    }

    public boolean canBreed() {
        return this.getGrowingAge() == 0;
    }

    public void procreate(AgeableCreatureEntity partner) {
        AgeableCreatureEntity baby = this.createChild(partner);
        if (baby != null) {
            this.finishBreeding();
            partner.finishBreeding();
            baby.setGrowingAge(baby.growthTime);
            Subspecies babySubspecies = this.creatureInfo.getChildSubspecies((LivingEntity)this, this.getSubspeciesIndex(), partner.getSubspecies());
            baby.applySubspecies(babySubspecies != null ? babySubspecies.index : 0);
            baby.func_70012_b(this.func_213303_ch().func_82615_a(), this.func_213303_ch().func_82617_b(), this.func_213303_ch().func_82616_c(), this.field_70177_z, this.field_70125_A);
            for (int i = 0; i < 7; ++i) {
                double d0 = this.field_70146_Z.nextGaussian() * 0.02;
                double d1 = this.field_70146_Z.nextGaussian() * 0.02;
                double d2 = this.field_70146_Z.nextGaussian() * 0.02;
                this.func_130014_f_().func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_213303_ch().func_82615_a() + (double)(this.field_70146_Z.nextFloat() * this.func_213305_a((Pose)Pose.STANDING).field_220315_a * 2.0f) - (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, this.func_213303_ch().func_82617_b() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213305_a((Pose)Pose.STANDING).field_220316_b), this.func_213303_ch().func_82616_c() + (double)(this.field_70146_Z.nextFloat() * this.func_213305_a((Pose)Pose.STANDING).field_220315_a * 2.0f) - (double)this.func_213305_a((Pose)Pose.STANDING).field_220315_a, d0, d1, d2);
            }
            this.onCreateBaby(partner, baby);
            this.func_130014_f_().func_217376_c((Entity)baby);
        }
    }

    public void onCreateBaby(AgeableCreatureEntity partner, AgeableCreatureEntity baby) {
    }

    public void finishBreeding() {
        this.setGrowingAge(this.breedingCooldown);
        this.setBreedingTarget(null);
        this.loveTime = 0;
    }

    @Override
    public void func_70037_a(CompoundNBT nbtTagCompound) {
        super.func_70037_a(nbtTagCompound);
        if (nbtTagCompound.func_74764_b("Age")) {
            this.setGrowingAge(nbtTagCompound.func_74762_e("Age"));
        } else {
            this.setGrowingAge(0);
        }
        this.loveTime = nbtTagCompound.func_74764_b("InLove") ? nbtTagCompound.func_74762_e("InLove") : 0;
        if (nbtTagCompound.func_74764_b("HasBeenFarmed") && nbtTagCompound.func_74767_n("HasBeenFarmed")) {
            this.setFarmed();
        }
    }

    @Override
    public void func_213281_b(CompoundNBT nbtTagCompound) {
        super.func_213281_b(nbtTagCompound);
        nbtTagCompound.func_74768_a("Age", this.getGrowingAge());
        nbtTagCompound.func_74768_a("InLove", this.loveTime);
        nbtTagCompound.func_74757_a("HasBeenFarmed", this.hasBeenFarmed);
    }
}

