/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.config;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.config.CoreConfig;
import java.io.File;
import java.io.IOException;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.math.NumberUtils;

public class ConfigGeneral {
    public static ConfigGeneral INSTANCE;
    public final ForgeConfigSpec.ConfigValue<String> configVersion;

    public ConfigGeneral(ForgeConfigSpec.Builder builder) {
        builder.push("General");
        this.configVersion = builder.comment("The last version of Lycanites Mobs that this config ran with, if this is behind the Minimum Config Version then all configs (including jsons) will be reset, only manually update this if you have manually adapted your configs to the latest version of Lycanites Mobs.").translation(CoreConfig.CONFIG_PREFIX + "version").define("version", (Object)"2.2.0.0");
        builder.pop();
    }

    public void clearOldConfigs(String minVersion, String currentVersion) {
        String configVersion = (String)this.configVersion.get();
        String[] minVersions = minVersion.split("\\.");
        String[] configVersions = configVersion.split("\\.");
        if (configVersions.length != 4) {
            configVersions = "0.0.0.0".split("\\.");
        }
        boolean oldVersion = false;
        for (int i = 0; i < 4; ++i) {
            int currentVerNum;
            int minVerNum = NumberUtils.isCreatable((String)minVersions[i].replaceAll("[^\\d.]", "")) ? Integer.parseInt(minVersions[i].replaceAll("[^\\d.]", "")) : 0;
            int n = currentVerNum = NumberUtils.isCreatable((String)configVersions[i].replaceAll("[^\\d.]", "")) ? Integer.parseInt(configVersions[i].replaceAll("[^\\d.]", "")) : 0;
            if (currentVerNum < minVerNum) {
                oldVersion = true;
                break;
            }
            if (currentVerNum > minVerNum) break;
        }
        if (oldVersion) {
            String configDirPath = new File(".") + "/config/" + "lycanitesmobs";
            File configDir = new File(configDirPath);
            configDir.mkdir();
            LycanitesMobs.logWarning("", "[Config] The current configs are too old, clearing all configs now...");
            try {
                FileUtils.cleanDirectory((File)configDir);
            }
            catch (IOException e) {
                LycanitesMobs.logWarning("", "[Config] Unable to clear the config directory! This could be a file permissions issue!");
                e.printStackTrace();
            }
        }
    }
}

