/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.config;

import com.google.common.collect.Lists;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.config.CoreConfig;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;

public class ConfigDebug {
    public static ConfigDebug INSTANCE;
    public final ForgeConfigSpec.ConfigValue<Boolean> creatureOverlay;
    public final ForgeConfigSpec.ConfigValue<List<? extends String>> enabled;

    public ConfigDebug(ForgeConfigSpec.Builder builder) {
        builder.push("Debug");
        builder.comment("Set debug options to true to show extra debugging information in the console.");
        this.creatureOverlay = builder.comment("Shows debugging info for Elements.").translation(CoreConfig.CONFIG_PREFIX + "elements").define("creatureOverlay", false);
        this.enabled = builder.comment("Shows debugging info for Mob Events.").translation(CoreConfig.CONFIG_PREFIX + "debug.enabled").defineList("enabled", (List)Lists.newArrayList(), o -> o instanceof String);
        builder.pop();
    }

    public boolean isEnabled(String debugKey) {
        if (!LycanitesMobs.configReady) {
            return false;
        }
        if (((List)this.enabled.get()).isEmpty()) {
            return false;
        }
        for (String enabledDebugKey : (List)this.enabled.get()) {
            if (!debugKey.equalsIgnoreCase(enabledDebugKey)) continue;
            return true;
        }
        return false;
    }
}

