/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.command;

import com.lycanitesmobs.core.spawner.SpawnerManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SpawnerCommand {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)Commands.func_197057_a((String)"spawner").then(Commands.func_197057_a((String)"test").then(Commands.func_197056_a((String)"spawner", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(SpawnerCommand::test))))).then(Commands.func_197057_a((String)"lighttest").executes(SpawnerCommand::lightTest));
    }

    public static int test(CommandContext<CommandSource> context) {
        String spawnerName = StringArgumentType.getString(context, (String)"spawner");
        int level = Math.max(1, IntegerArgumentType.getInteger(context, (String)"level"));
        if (!SpawnerManager.getInstance().spawners.containsKey(spawnerName)) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("lyc.command.spawner.test.unknown", new Object[0]), true);
            return 0;
        }
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        PlayerEntity player = null;
        BlockPos pos = BlockPos.field_177992_a;
        if (((CommandSource)context.getSource()).func_197022_f() instanceof PlayerEntity) {
            player = (PlayerEntity)((CommandSource)context.getSource()).func_197022_f();
            pos = player.func_180425_c();
        }
        SpawnerManager.getInstance().spawners.get(spawnerName).trigger((World)world, player, null, pos, level, 1, 0);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("lyc.command.spawner.test", new Object[0]), true);
        return 0;
    }

    public static int lightTest(CommandContext<CommandSource> context) {
        if (((CommandSource)context.getSource()).func_197022_f() == null) {
            return 0;
        }
        float brightness = ((CommandSource)context.getSource()).func_197022_f().func_70013_c();
        int level = 3;
        if (brightness == 0.0f) {
            level = 0;
        } else if (brightness < 0.25f) {
            level = 1;
        } else if (brightness < 1.0f) {
            level = 2;
        }
        String results = " Level: " + level + " Brightness: " + brightness;
        if (level <= 1) {
            ((CommandSource)context.getSource()).func_197030_a(new TranslationTextComponent("lyc.command.spawner.lighttest.dark", new Object[0]).func_150258_a(results), true);
        } else {
            ((CommandSource)context.getSource()).func_197030_a(new TranslationTextComponent("lyc.command.spawner.lighttest.light", new Object[0]).func_150258_a(results), true);
        }
        return 0;
    }
}

