/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.command;

import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.core.mobevent.MobEventListener;
import com.lycanitesmobs.core.mobevent.MobEventManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.dimension.DimensionType;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.DimensionManager;

public class MobEventCommand {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"mobevent").then(Commands.func_197057_a((String)"start").then(Commands.func_197056_a((String)"mobevent", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(MobEventCommand::start)).then(Commands.func_197056_a((String)"world", (ArgumentType)IntegerArgumentType.integer()).executes(MobEventCommand::startWorld)))))).then(Commands.func_197057_a((String)"random").then(((RequiredArgumentBuilder)Commands.func_197056_a((String)"level", (ArgumentType)IntegerArgumentType.integer()).executes(MobEventCommand::random)).then(Commands.func_197056_a((String)"world", (ArgumentType)IntegerArgumentType.integer()).executes(MobEventCommand::randomWorld))))).then(((LiteralArgumentBuilder)Commands.func_197057_a((String)"stop").executes(MobEventCommand::stop)).then(Commands.func_197056_a((String)"world", (ArgumentType)IntegerArgumentType.integer()).executes(MobEventCommand::stopWorld)));
    }

    public static int start(CommandContext<CommandSource> context) {
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        String eventName = StringArgumentType.getString(context, (String)"mobevent");
        int level = Math.max(1, IntegerArgumentType.getInteger(context, (String)"level"));
        if (!MobEventManager.getInstance().mobEvents.containsKey(eventName)) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("lyc.command.mobevent.start.unknown", new Object[0]), true);
            return 0;
        }
        ExtendedWorld extendedWorld = ExtendedWorld.getForWorld((World)world);
        if (extendedWorld == null) {
            return 0;
        }
        if (((CommandSource)context.getSource()).func_197022_f() instanceof PlayerEntity) {
            extendedWorld.startMobEvent(eventName, (PlayerEntity)((CommandSource)context.getSource()).func_197022_f(), ((CommandSource)context.getSource()).func_197022_f().func_180425_c(), level);
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("lyc.command.mobevent.start", new Object[0]), true);
        return 0;
    }

    public static int startWorld(CommandContext<CommandSource> context) {
        String eventName = StringArgumentType.getString(context, (String)"mobevent");
        int level = Math.max(1, IntegerArgumentType.getInteger(context, (String)"level"));
        int worldId = IntegerArgumentType.getInteger(context, (String)"world");
        if (!MobEventManager.getInstance().mobEvents.containsKey(eventName)) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("lyc.command.mobevent.start.unknown", new Object[0]), true);
            return 0;
        }
        ServerWorld world = DimensionManager.getWorld((MinecraftServer)((CommandSource)context.getSource()).func_197028_i(), (DimensionType)DimensionType.func_186069_a((int)worldId), (boolean)false, (boolean)false);
        ExtendedWorld extendedWorld = ExtendedWorld.getForWorld((World)world);
        if (extendedWorld == null) {
            return 0;
        }
        if (((CommandSource)context.getSource()).func_197022_f() instanceof PlayerEntity) {
            extendedWorld.startMobEvent(eventName, (PlayerEntity)((CommandSource)context.getSource()).func_197022_f(), ((CommandSource)context.getSource()).func_197022_f().func_180425_c(), level);
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("lyc.command.mobevent.start", new Object[0]), true);
        return 0;
    }

    public static int random(CommandContext<CommandSource> context) {
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        int level = Math.max(1, IntegerArgumentType.getInteger(context, (String)"level"));
        ExtendedWorld extendedWorld = ExtendedWorld.getForWorld((World)world);
        if (extendedWorld == null) {
            return 0;
        }
        extendedWorld.stopWorldEvent();
        MobEventListener.getInstance().triggerRandomMobEvent((World)world, extendedWorld, level);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("lyc.command.mobevent.random", new Object[0]), true);
        return 0;
    }

    public static int randomWorld(CommandContext<CommandSource> context) {
        int level = Math.max(1, IntegerArgumentType.getInteger(context, (String)"level"));
        int worldId = IntegerArgumentType.getInteger(context, (String)"world");
        ServerWorld world = DimensionManager.getWorld((MinecraftServer)((CommandSource)context.getSource()).func_197028_i(), (DimensionType)DimensionType.func_186069_a((int)worldId), (boolean)false, (boolean)false);
        ExtendedWorld extendedWorld = ExtendedWorld.getForWorld((World)world);
        if (extendedWorld == null) {
            return 0;
        }
        extendedWorld.stopWorldEvent();
        MobEventListener.getInstance().triggerRandomMobEvent((World)world, extendedWorld, level);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("lyc.command.mobevent.random", new Object[0]), true);
        return 0;
    }

    public static int stop(CommandContext<CommandSource> context) {
        ServerWorld world = ((CommandSource)context.getSource()).func_197023_e();
        ExtendedWorld extendedWorld = ExtendedWorld.getForWorld((World)world);
        if (extendedWorld == null) {
            return 0;
        }
        extendedWorld.stopWorldEvent();
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("lyc.command.mobevent.stop", new Object[0]), true);
        return 0;
    }

    public static int stopWorld(CommandContext<CommandSource> context) {
        int worldId = IntegerArgumentType.getInteger(context, (String)"world");
        ServerWorld world = DimensionManager.getWorld((MinecraftServer)((CommandSource)context.getSource()).func_197028_i(), (DimensionType)DimensionType.func_186069_a((int)worldId), (boolean)false, (boolean)false);
        ExtendedWorld extendedWorld = ExtendedWorld.getForWorld((World)world);
        if (extendedWorld == null) {
            return 0;
        }
        extendedWorld.stopWorldEvent();
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("lyc.command.mobevent.stop", new Object[0]), true);
        return 0;
    }
}

