/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.command;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.config.ConfigDebug;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.BiomeDictionary;

public class DebugCommand {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"debug").then(Commands.func_197057_a((String)"log").then(Commands.func_197056_a((String)"category", (ArgumentType)StringArgumentType.string()).executes(DebugCommand::log)))).then(Commands.func_197057_a((String)"list").executes(DebugCommand::list))).then(Commands.func_197057_a((String)"biomesfromtag").then(Commands.func_197056_a((String)"biometag", (ArgumentType)StringArgumentType.string()).executes(DebugCommand::biomesfromtag)))).then(Commands.func_197057_a((String)"listbiometags").executes(DebugCommand::listbiometags))).then(Commands.func_197057_a((String)"overlay").executes(DebugCommand::overlay));
    }

    public static int log(CommandContext<CommandSource> context) {
        String category = StringArgumentType.getString(context, (String)"category").toLowerCase();
        ArrayList<String> enabledLogs = new ArrayList<String>();
        enabledLogs.addAll((Collection)ConfigDebug.INSTANCE.enabled.get());
        if (enabledLogs.contains(category)) {
            enabledLogs.remove(category);
            LycanitesMobs.logDebug("", category + " Debug Logging Disabled");
        } else {
            enabledLogs.add(category);
            LycanitesMobs.logDebug("", category + " Debug Logging Enabled");
        }
        ConfigDebug.INSTANCE.enabled.set(enabledLogs);
        ConfigDebug.INSTANCE.enabled.save();
        ((CommandSource)context.getSource()).func_197030_a(new TranslationTextComponent("lyc.command.debug.log", new Object[0]).func_150258_a(" " + category), true);
        return 0;
    }

    public static int list(CommandContext<CommandSource> context) {
        String[] debugCategories;
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("lyc.command.debug.list", new Object[0]), true);
        for (String debugCategory : debugCategories = new String[]{"jsonspawner", "mobspawns", "entity", "subspecies", "creature", "mobevents", "dungeon", "items", "equipment"}) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(debugCategory), true);
        }
        return 0;
    }

    public static int biomesfromtag(CommandContext<CommandSource> context) {
        String biomeTag = StringArgumentType.getString(context, (String)"biometag").toLowerCase();
        BiomeDictionary.Type biomeType = null;
        try {
            biomeType = BiomeDictionary.Type.getType((String)biomeTag, (BiomeDictionary.Type[])new BiomeDictionary.Type[0]);
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "Unknown biome tag: " + biomeTag + ".");
        }
        if (biomeType == null) {
            return 0;
        }
        for (Biome biome : BiomeDictionary.getBiomes((BiomeDictionary.Type)biomeType)) {
            ((CommandSource)context.getSource()).func_197030_a(biome.func_205403_k(), true);
        }
        return 0;
    }

    public static int listbiometags(CommandContext<CommandSource> context) {
        for (BiomeDictionary.Type biomeType : BiomeDictionary.Type.getAll()) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(biomeType.getName()), true);
        }
        return 0;
    }

    public static int overlay(CommandContext<CommandSource> context) {
        ConfigDebug.INSTANCE.creatureOverlay.set((Object)((Boolean)ConfigDebug.INSTANCE.creatureOverlay.get() == false ? 1 : 0));
        ConfigDebug.INSTANCE.creatureOverlay.save();
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("lyc.command.debug.overlay", new Object[0]), true);
        return 0;
    }
}

