/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.command;

import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.info.Beastiary;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureKnowledge;
import com.lycanitesmobs.core.info.CreatureManager;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class BeastiaryCommand {
    public static ArgumentBuilder<CommandSource, ?> register() {
        return ((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"beastiary").then(Commands.func_197057_a((String)"complete").then(Commands.func_197056_a((String)"rank", (ArgumentType)IntegerArgumentType.integer()).executes(BeastiaryCommand::complete)))).then(Commands.func_197057_a((String)"clear").executes(BeastiaryCommand::clear))).then(Commands.func_197057_a((String)"add").then(Commands.func_197056_a((String)"creature", (ArgumentType)StringArgumentType.string()).then(Commands.func_197056_a((String)"rank", (ArgumentType)IntegerArgumentType.integer()).executes(BeastiaryCommand::add))));
    }

    public static int complete(CommandContext<CommandSource> context) {
        if (!(((CommandSource)context.getSource()).func_197022_f() instanceof PlayerEntity)) {
            return 0;
        }
        int rank = Math.max(0, Math.min(3, IntegerArgumentType.getInteger(context, (String)"rank")));
        ExtendedPlayer extendedPlayer = ExtendedPlayer.getForPlayer((PlayerEntity)((CommandSource)context.getSource()).func_197022_f());
        if (extendedPlayer == null) {
            return 0;
        }
        Beastiary beastiary = extendedPlayer.getBeastiary();
        for (CreatureInfo creatureInfo : CreatureManager.getInstance().creatures.values()) {
            beastiary.addCreatureKnowledge(new CreatureKnowledge(beastiary, creatureInfo.getName(), rank));
        }
        beastiary.sendAllToClient();
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("lyc.command.beastiary.complete", new Object[0]), true);
        return 0;
    }

    public static int clear(CommandContext<CommandSource> context) {
        if (!(((CommandSource)context.getSource()).func_197022_f() instanceof PlayerEntity)) {
            return 0;
        }
        ExtendedPlayer extendedPlayer = ExtendedPlayer.getForPlayer((PlayerEntity)((CommandSource)context.getSource()).func_197022_f());
        if (extendedPlayer == null) {
            return 0;
        }
        Beastiary beastiary = extendedPlayer.getBeastiary();
        beastiary.creatureKnowledgeList.clear();
        beastiary.sendAllToClient();
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("lyc.command.beastiary.clear", new Object[0]), true);
        return 0;
    }

    public static int add(CommandContext<CommandSource> context) {
        if (!(((CommandSource)context.getSource()).func_197022_f() instanceof PlayerEntity)) {
            return 0;
        }
        int rank = Math.max(0, Math.min(3, IntegerArgumentType.getInteger(context, (String)"rank")));
        String creatureName = StringArgumentType.getString(context, (String)"creature");
        ExtendedPlayer extendedPlayer = ExtendedPlayer.getForPlayer((PlayerEntity)((CommandSource)context.getSource()).func_197022_f());
        if (extendedPlayer == null) {
            return 0;
        }
        Beastiary beastiary = extendedPlayer.getBeastiary();
        CreatureInfo creatureInfo = CreatureManager.getInstance().getCreature(creatureName);
        if (creatureInfo == null) {
            ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("lyc.command.beastiary.add.unknown", new Object[0]), true);
            return 0;
        }
        CreatureKnowledge creatureKnowledge = new CreatureKnowledge(beastiary, creatureInfo.getName(), rank);
        if (beastiary.addCreatureKnowledge(creatureKnowledge) > 0) {
            beastiary.sendAddedMessage(creatureKnowledge);
            beastiary.sendToClient(creatureKnowledge);
        } else {
            beastiary.sendKnownMessage(creatureKnowledge);
        }
        return 0;
    }
}

