/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.block;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.core.block.BlockBase;
import com.lycanitesmobs.core.block.BlockFenceCustom;
import com.lycanitesmobs.core.block.BlockPillar;
import com.lycanitesmobs.core.block.BlockSlabCustom;
import com.lycanitesmobs.core.block.BlockStairsCustom;
import com.lycanitesmobs.core.block.BlockWallCustom;
import com.lycanitesmobs.core.info.ModInfo;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.Material;

public class BlockMaker {
    public static List<BlockMakerEntry> STONE_ENTRIES = new ArrayList<BlockMakerEntry>();

    public static void addStoneBlocks(ModInfo group, String stoneName, Object creationItem, Object creationBlock) {
        Block.Properties properties = Block.Properties.func_200945_a((Material)Material.field_151576_e).func_200947_a(SoundType.field_185851_d).func_200948_a(2.0f, 10.0f);
        Block.Properties crystalProperties = Block.Properties.func_200945_a((Material)Material.field_151592_s).func_200947_a(SoundType.field_185853_f).func_200948_a(0.3f, 10.0f).func_200951_a(15);
        BlockBase stoneBlock = new BlockBase(properties, group, stoneName + "stone");
        ObjectManager.addBlock(stoneName + "stone", stoneBlock);
        ObjectManager.addBlock(stoneName + "stone_stairs", (Block)new BlockStairsCustom(properties, stoneBlock));
        ObjectManager.addBlock(stoneName + "stone_slab", (Block)new BlockSlabCustom(properties, stoneBlock));
        BlockBase stoneBrickBlock = new BlockBase(properties, group, stoneName + "stonebrick");
        ObjectManager.addBlock(stoneName + "stonebrick", stoneBrickBlock);
        ObjectManager.addBlock(stoneName + "stonebrick_stairs", (Block)new BlockStairsCustom(properties, stoneBrickBlock));
        ObjectManager.addBlock(stoneName + "stonebrick_slab", (Block)new BlockSlabCustom(properties, stoneBrickBlock));
        ObjectManager.addBlock(stoneName + "stonebrick_fence", (Block)new BlockFenceCustom(properties, stoneBrickBlock));
        ObjectManager.addBlock(stoneName + "stonebrick_wall", (Block)new BlockWallCustom(properties, stoneBrickBlock));
        BlockBase stoneTileBlock = new BlockBase(properties, group, stoneName + "stonetile");
        ObjectManager.addBlock(stoneName + "stonetile", stoneTileBlock);
        ObjectManager.addBlock(stoneName + "stonetile_stairs", (Block)new BlockStairsCustom(properties, stoneTileBlock));
        ObjectManager.addBlock(stoneName + "stonetile_slab", (Block)new BlockSlabCustom(properties, stoneTileBlock));
        ObjectManager.addBlock(stoneName + "stonepolished", new BlockBase(properties, group, stoneName + "stonepolished"));
        ObjectManager.addBlock(stoneName + "stonechiseled", new BlockBase(properties, group, stoneName + "stonechiseled"));
        ObjectManager.addBlock(stoneName + "stonepillar", new BlockPillar(properties, group, stoneName + "stonepillar"));
        ObjectManager.addBlock(stoneName + "crystal", new BlockBase(crystalProperties, group, stoneName + "crystal"));
        STONE_ENTRIES.add(new BlockMakerEntry(stoneName, creationItem, creationBlock));
    }

    public static void addStoneBlocks(ModInfo group, String stoneName, Object creationItem) {
        BlockMaker.addStoneBlocks(group, stoneName, creationItem, Blocks.field_150347_e);
    }

    public static class BlockMakerEntry {
        public String stoneName;
        public Object creationItem;
        public Object creationBlock;

        public BlockMakerEntry(String stoneName, Object creationItem, Object creationBlock) {
            this.stoneName = stoneName;
            this.creationItem = creationItem;
            this.creationBlock = creationBlock;
        }
    }
}

