/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.block;

import com.lycanitesmobs.core.block.BlockBase;
import com.lycanitesmobs.core.info.ModInfo;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.SixWayBlock;
import net.minecraft.block.TNTBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.util.Direction;
import net.minecraft.util.Util;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.GameRules;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class BlockFireBase
extends BlockBase {
    public static final BooleanProperty PERMANENT = BooleanProperty.func_177716_a((String)"permanent");
    public static final BooleanProperty NORTH = SixWayBlock.field_196488_a;
    public static final BooleanProperty EAST = SixWayBlock.field_196490_b;
    public static final BooleanProperty SOUTH = SixWayBlock.field_196492_c;
    public static final BooleanProperty WEST = SixWayBlock.field_196495_y;
    public static final BooleanProperty UP = SixWayBlock.field_196496_z;
    private static final Map<Direction, BooleanProperty> FACING_TO_PROPERTY_MAP = (Map)SixWayBlock.field_196491_B.entrySet().stream().filter(p_199776_0_ -> p_199776_0_.getKey() != Direction.DOWN).collect(Util.func_199749_a());
    public boolean dieInRain = true;
    public boolean triggerTNT = true;
    public boolean tickRandomly = true;
    public int agingRate = 3;
    public float spreadChance = 1.0f;
    public boolean removeOnNoFireTick;

    public BlockFireBase(Block.Properties properties, ModInfo group, String name) {
        super(properties, group, name);
        this.removeOnTick = false;
        this.removeOnNoFireTick = false;
        this.loopTicks = true;
        this.canBeCrushed = true;
        this.noBreakCollision = false;
        this.isOpaque = false;
        this.tickRate = 30;
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176194_O().func_177621_b()).func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(0))).func_206870_a((IProperty)PERMANENT, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)EAST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)WEST, (Comparable)Boolean.valueOf(false))).func_206870_a((IProperty)UP, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{AGE, PERMANENT, NORTH, EAST, SOUTH, WEST, UP});
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getStateForPlacement((IBlockReader)context.func_195991_k(), context.func_195995_a());
    }

    public BlockState getStateForPlacement(IBlockReader world, BlockPos blockPos) {
        BlockPos lowerBlockPos = blockPos.func_177977_b();
        BlockState lowerBlockState = world.func_180495_p(lowerBlockPos);
        if (!this.canCatchFire(world, blockPos, Direction.UP) && !Block.func_220056_d((BlockState)lowerBlockState, (IBlockReader)world, (BlockPos)lowerBlockPos, (Direction)Direction.UP)) {
            BlockState placementState = this.func_176223_P();
            for (Direction direction : Direction.values()) {
                BooleanProperty booleanproperty = FACING_TO_PROPERTY_MAP.get(direction);
                if (booleanproperty == null) continue;
                placementState = (BlockState)placementState.func_206870_a((IProperty)booleanproperty, (Comparable)Boolean.valueOf(this.canCatchFire(world, blockPos.func_177972_a(direction), direction.func_176734_d())));
            }
            return (BlockState)placementState.func_206870_a((IProperty)PERMANENT, (Comparable)Boolean.valueOf(false));
        }
        return this.func_176223_P();
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        return worldIn.func_180495_p(blockpos).func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP) || this.areNeighborsFlammable((IBlockReader)worldIn, pos);
    }

    protected boolean areNeighborsFlammable(IBlockReader worldIn, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.canCatchFire(worldIn, pos.func_177972_a(direction), direction.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    public BlockState func_196271_a(BlockState state, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return this.func_196260_a(state, (IWorldReader)worldIn, currentPos) ? (BlockState)this.getStateForPlacement((IBlockReader)worldIn, currentPos).func_206870_a((IProperty)AGE, state.func_177229_b((IProperty)AGE)) : Blocks.field_150350_a.func_176223_P();
    }

    @Override
    public int func_149738_a(IWorldReader world) {
        return this.tickRate;
    }

    @Override
    public void func_225534_a_(BlockState blockState, ServerWorld world, BlockPos pos, Random rand) {
        if (!world.isAreaLoaded(pos, 2)) {
            return;
        }
        boolean permanent = (Boolean)blockState.func_177229_b((IProperty)PERMANENT);
        if (!world.func_82736_K().func_223586_b(GameRules.field_223598_a)) {
            if (this.removeOnNoFireTick && !permanent) {
                world.func_217377_a(pos, false);
            }
            return;
        }
        if (!this.func_196260_a(blockState, (IWorldReader)world, pos) || this.removeOnTick) {
            world.func_217377_a(pos, false);
        }
        BlockState blockStateBelow = world.func_180495_p(pos.func_177977_b());
        boolean isOnFireSource = permanent || this.isBlockFireSource(blockStateBelow, (IBlockReader)world, pos.func_177977_b(), Direction.UP);
        int age = (Integer)blockState.func_177229_b((IProperty)AGE);
        if (!isOnFireSource && this.canDie((World)world, pos) && rand.nextFloat() < 0.2f + (float)age * 0.03f) {
            world.func_217377_a(pos, false);
            return;
        }
        if (age < 15) {
            blockState = (BlockState)blockState.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(Math.max(age + Math.round((float)rand.nextInt(this.agingRate) / 2.0f), 15)));
            world.func_180501_a(pos, blockState, 4);
        }
        if (this.loopTicks) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)world) + rand.nextInt(10));
        }
        if (!isOnFireSource) {
            if (world.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150350_a) {
                world.func_217377_a(pos, false);
                return;
            }
            if (!this.canNeighborCatchFire((World)world, pos)) {
                if (!Block.func_220056_d((BlockState)world.func_180495_p(pos), (IBlockReader)world, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP) || age > 3) {
                    world.func_217377_a(pos, false);
                }
                return;
            }
            if (!this.canCatchFire((IBlockReader)world, pos.func_177977_b(), Direction.UP) && age == 15 && rand.nextInt(4) == 0) {
                world.func_217377_a(pos, false);
                return;
            }
        }
        if (this.spreadChance <= 0.0f || permanent) {
            return;
        }
        boolean highHumidity = world.func_180502_D(pos);
        int humidityChance = 0;
        if (highHumidity) {
            humidityChance = -50;
        }
        this.tryCatchFire((World)world, pos.func_177974_f(), 300 + humidityChance, rand, age, Direction.WEST);
        this.tryCatchFire((World)world, pos.func_177976_e(), 300 + humidityChance, rand, age, Direction.EAST);
        this.tryCatchFire((World)world, pos.func_177977_b(), 250 + humidityChance, rand, age, Direction.UP);
        this.tryCatchFire((World)world, pos.func_177984_a(), 250 + humidityChance, rand, age, Direction.DOWN);
        this.tryCatchFire((World)world, pos.func_177978_c(), 300 + humidityChance, rand, age, Direction.SOUTH);
        this.tryCatchFire((World)world, pos.func_177968_d(), 300 + humidityChance, rand, age, Direction.NORTH);
        for (int offsetX = -1; offsetX <= 1; ++offsetX) {
            for (int offsetZ = -1; offsetZ <= 1; ++offsetZ) {
                for (int offsetY = -1; offsetY <= 4; ++offsetY) {
                    BlockPos spreadPos;
                    int spreadEncouragement;
                    if (offsetX == 0 && offsetY == 0 && offsetZ == 0) continue;
                    int chance = 100;
                    if (offsetY > 1) {
                        chance += (offsetY - 1) * 100;
                    }
                    if ((spreadEncouragement = this.getNeighborEncouragement((World)world, spreadPos = pos.func_177982_a(offsetX, offsetY, offsetZ))) <= 0) continue;
                    int spreadFlammability = (spreadEncouragement + 40 + world.func_175659_aa().func_151525_a() * 7) / (age + 30);
                    if (highHumidity) {
                        spreadFlammability /= 2;
                    }
                    if (spreadFlammability <= 0 || rand.nextInt(chance) > spreadFlammability || world.func_72896_J() && this.canDie((World)world, spreadPos)) continue;
                    int spreadAge = age + rand.nextInt(5) / 4;
                    if (spreadAge > 15) {
                        spreadAge = 15;
                    }
                    world.func_180501_a(spreadPos, (BlockState)((BlockState)blockState.func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(spreadAge))).func_206870_a((IProperty)PERMANENT, (Comparable)Boolean.valueOf(false)), 3);
                }
            }
        }
    }

    protected boolean canNeighborCatchFire(World worldIn, BlockPos pos) {
        for (Direction direction : Direction.values()) {
            if (!this.canCatchFire((IBlockReader)worldIn, pos.func_177972_a(direction), direction.func_176734_d())) continue;
            return true;
        }
        return false;
    }

    protected int getNeighborEncouragement(World worldIn, BlockPos pos) {
        if (!worldIn.func_175623_d(pos)) {
            return 0;
        }
        int i = 0;
        for (Direction direction : Direction.values()) {
            i = Math.max(worldIn.func_180495_p(pos.func_177972_a(direction)).getFlammability((IBlockReader)worldIn, pos.func_177972_a(direction), direction.func_176734_d()), i);
        }
        return i;
    }

    private void tryCatchFire(World world, BlockPos pos, int chance, Random random, int age, Direction face) {
        int flammability = this.getBlockFlammability((IBlockReader)world, pos, face);
        if (Math.round((float)random.nextInt(chance) / this.spreadChance) < flammability) {
            BlockState blockState = world.func_180495_p(pos);
            if (random.nextInt(age + 10) < 5 && !world.func_175727_C(pos)) {
                int newFireAge = age + random.nextInt(5) / 4;
                if (newFireAge > 15) {
                    newFireAge = 15;
                }
                this.burnBlockReplace(world, pos, newFireAge);
            } else {
                this.burnBlockDestroy(world, pos);
            }
            if (this.triggerTNT && blockState.func_177230_c() instanceof TNTBlock) {
                TNTBlock.func_196534_a((World)world, (BlockPos)pos);
            }
        }
    }

    public void burnBlockReplace(World world, BlockPos pos, int newFireAge) {
        world.func_180501_a(pos, (BlockState)this.func_176223_P().func_206870_a((IProperty)AGE, (Comparable)Integer.valueOf(newFireAge)), 3);
    }

    public void burnBlockDestroy(World world, BlockPos pos) {
        world.func_217377_a(pos, false);
    }

    public boolean canCatchFire(IBlockReader world, BlockPos pos, Direction face) {
        return world.func_180495_p(pos).isFlammable(world, pos, face);
    }

    public boolean isBlockFireSource(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        return state.isFireSource(world, pos, side);
    }

    public int getBlockFlammability(IBlockReader world, BlockPos pos, Direction face) {
        return world.func_180495_p(pos).getFlammability(world, pos, face);
    }

    protected boolean canDie(World world, BlockPos pos) {
        return world.func_175727_C(pos) || world.func_175727_C(pos.func_177976_e()) || world.func_175727_C(pos.func_177974_f()) || world.func_175727_C(pos.func_177978_c()) || world.func_175727_C(pos.func_177968_d());
    }
}

