/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core.block;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.info.ModInfo;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.TickPriority;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BlockBase
extends Block {
    public ModInfo group;
    public String blockName = "BlockBase";
    public static final IntegerProperty AGE = BlockStateProperties.field_208171_X;
    public int tickRate = 0;
    public boolean removeOnTick = false;
    public boolean loopTicks = true;
    public boolean canBeCrushed = false;
    public boolean noBreakCollision = false;
    public boolean isOpaque = true;

    public BlockBase(Block.Properties properties, ModInfo group, String name) {
        super(properties);
        this.group = group;
        this.blockName = name;
        this.setRegistryName(this.group.modid, this.blockName.toLowerCase());
    }

    public BlockBase(Block.Properties properties) {
        super(properties);
    }

    @Nonnull
    public String func_149739_a() {
        return "block." + LycanitesMobs.modInfo.modid + "." + this.blockName;
    }

    public ITextComponent func_200291_n() {
        return new TranslationTextComponent(this.func_149739_a(), new Object[0]);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable IBlockReader world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add(this.getDescription(stack, world));
    }

    public ITextComponent getDescription(ItemStack itemStack, @Nullable IBlockReader world) {
        return new TranslationTextComponent(this.func_149739_a() + ".description", new Object[0]);
    }

    public void func_220082_b(BlockState state, World world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (this.tickRate > 0) {
            world.func_205220_G_().func_205360_a(pos, (Object)this, this.func_149738_a((IWorldReader)world));
        }
    }

    public int func_149738_a(IWorldReader world) {
        return this.tickRate;
    }

    public void func_225534_a_(BlockState state, ServerWorld world, BlockPos pos, Random random) {
        if (world.field_72995_K) {
            return;
        }
        if (this.removeOnTick && this.canRemove((World)world, pos, state, random)) {
            world.func_217377_a(pos, true);
        } else if (this.tickRate > 0 && this.loopTicks) {
            world.func_205220_G_().func_205362_a(pos, (Object)this, this.func_149738_a((IWorldReader)world), TickPriority.LOW);
        }
    }

    public boolean canRemove(World world, BlockPos pos, BlockState state, Random random) {
        return true;
    }

    public VoxelShape func_220053_a(BlockState blockState, IBlockReader world, BlockPos blockPos, ISelectionContext selectionContext) {
        return super.func_220053_a(blockState, world, blockPos, selectionContext);
    }

    public VoxelShape func_220071_b(BlockState blockState, IBlockReader world, BlockPos blockPos, ISelectionContext selectionContext) {
        return this.field_196274_w ? blockState.func_196954_c(world, blockPos) : VoxelShapes.func_197880_a();
    }

    public void func_176199_a(World world, BlockPos pos, Entity entity) {
        super.func_176199_a(world, pos, entity);
    }

    public void func_196262_a(BlockState blockState, World world, BlockPos pos, Entity entity) {
        super.func_196262_a(blockState, world, pos, entity);
    }

    public static enum RENDER_TYPE {
        NONE(-1),
        NORMAL(0),
        CROSS(1),
        TORCH(2),
        FIRE(3),
        FLUID(4);

        public final int id;

        private RENDER_TYPE(int value) {
            this.id = value;
        }

        public int getValue() {
            return this.id;
        }
    }
}

