/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core;

import com.lycanitesmobs.LycanitesMobs;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.stats.IStatFormatter;
import net.minecraft.stats.Stat;
import net.minecraft.stats.StatType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.registry.SimpleRegistry;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class StatManager {
    private static StatManager INSTANCE;
    public Map<String, StatType<ResourceLocation>> statTypes = new HashMap<String, StatType<ResourceLocation>>();

    public static StatManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new StatManager();
        }
        return INSTANCE;
    }

    public void createStatTypes() {
        StatManager.getInstance().addStatType("learn");
        StatManager.getInstance().addStatType("summon");
    }

    public void addStatType(String name) {
        SimpleRegistry statRegistry = new SimpleRegistry();
        StatType statType = new StatType((Registry)statRegistry);
        statType.setRegistryName(LycanitesMobs.modInfo.modid, name);
        this.statTypes.put(name, (StatType<ResourceLocation>)statType);
    }

    @Nullable
    public Stat getStat(String typeName, String name) {
        if (!this.statTypes.containsKey(typeName)) {
            return null;
        }
        return this.statTypes.get(typeName).func_199077_a((Object)new ResourceLocation(LycanitesMobs.modInfo.modid, name), IStatFormatter.field_223218_b_);
    }

    @SubscribeEvent
    public void registerStats(RegistryEvent.Register<StatType<?>> event) {
        this.createStatTypes();
        for (StatType<ResourceLocation> statType : this.statTypes.values()) {
            event.getRegistry().register(statType);
        }
    }
}

