/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core;

import com.lycanitesmobs.LycanitesMobs;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileSystem;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.io.FilenameUtils;

public class FileLoader {
    public static FileLoader CLIENT;
    public static FileLoader SERVER;
    public static FileLoader COMMON;
    private FileSystem fileSystem;
    private String rootPath;
    private String domain;
    public boolean ready = false;

    public static void initAll(String domain) {
        CLIENT = new FileLoader("assets", domain);
        SERVER = new FileLoader("data", domain);
        COMMON = new FileLoader("common", domain);
        LycanitesMobs.logDebug("", "All FileLoaders initialised successfully.");
    }

    public FileLoader(String type, String domain) {
        this.domain = domain;
        this.rootPath = "/" + type + "/" + domain;
        try {
            URI rootUri = this.getClass().getResource(this.rootPath + "/.root").toURI();
            if ("file".equals(rootUri.getScheme())) {
                Path rootPathInstance = Paths.get(rootUri);
                this.rootPath = rootPathInstance.toString().replace(rootPathInstance.getFileName().toString(), "");
                this.fileSystem = rootPathInstance.getFileSystem();
                this.ready = true;
            } else if (!"modjar".equals(rootUri.getScheme())) {
                LycanitesMobs.logError("Unsupported file scheme: " + rootUri.getScheme());
                throw new RuntimeException("Unsupported file scheme: " + rootUri.getScheme());
            }
        }
        catch (Exception e) {
            LycanitesMobs.logError("An exception occurred when creating a FileLoader for root path: " + this.rootPath);
            throw new RuntimeException(e);
        }
    }

    public File getJarFile() {
        LycanitesMobs.logWarning("", "Test Path: " + LycanitesMobs.class.getProtectionDomain().getCodeSource().getLocation().getPath());
        return new File(LycanitesMobs.class.getProtectionDomain().getCodeSource().getLocation().getPath());
    }

    public Path getModJarPath() throws IOException {
        Path path = new File("mods").toPath();
        Iterator iterator = Files.walk(path, new FileVisitOption[0]).iterator();
        while (iterator.hasNext()) {
            Path filePath = (Path)iterator.next();
            if (!filePath.getFileName().toString().toLowerCase().contains(this.domain)) continue;
            return Paths.get(filePath.toFile().getCanonicalPath(), new String[0]);
        }
        throw new RuntimeException("Unable to find Lycanites Mobs jar file by name, make sure that it at least has 'lycanitesmobs' in the jar file name if it is renamed.");
    }

    public Path getPath(String subPath) {
        return this.fileSystem.getPath(this.rootPath + "/" + subPath, new String[0]);
    }

    public List<ResourceLocation> getPathResourceLocations(String subPath, String fileType) {
        Path path = this.getPath(subPath);
        ArrayList<ResourceLocation> resourceLocations = new ArrayList<ResourceLocation>();
        try {
            Iterator iterator = Files.walk(path, new FileVisitOption[0]).iterator();
            while (iterator.hasNext()) {
                Path filePath = (Path)iterator.next();
                if (fileType != null && !fileType.equals(FilenameUtils.getExtension((String)filePath.toString()))) continue;
                Path relativePath = path.relativize(filePath);
                String resourceLocationPath = FilenameUtils.removeExtension((String)relativePath.toString()).replaceAll("\\\\", "/");
                ResourceLocation resourceLocation = new ResourceLocation(this.domain, resourceLocationPath);
                resourceLocations.add(resourceLocation);
            }
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "There was a problem getting ResourceLocations for: " + path + ", " + fileType + ",  \n" + e.toString());
        }
        return resourceLocations;
    }
}

