/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.core;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupBoss;
import com.lycanitesmobs.core.EffectBase;
import com.lycanitesmobs.core.config.ConfigExtra;
import com.lycanitesmobs.core.entity.ExtendedEntity;
import com.lycanitesmobs.core.entity.FearEntity;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.network.MessageEntityVelocity;
import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SEntityVelocityPacket;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHealEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class Effects {
    private static final UUID swiftswimmingMoveBoostUUID = UUID.fromString("6d4fe17f-06eb-4ebc-a573-364b79faed5e");
    private static final AttributeModifier swiftswimmingMoveBoost = new AttributeModifier(swiftswimmingMoveBoostUUID, "Swiftswimming Speed Boost", 0.6, AttributeModifier.Operation.ADDITION).func_111168_a(false);
    public boolean disableNausea = false;

    public Effects() {
        ObjectManager.addPotionEffect("paralysis", true, 0xFFFF00, false);
        ObjectManager.addPotionEffect("penetration", true, 0x222222, false);
        ObjectManager.addPotionEffect("recklessness", true, 0xFF0044, false);
        ObjectManager.addPotionEffect("rage", true, 0xFF4400, false);
        ObjectManager.addPotionEffect("weight", true, 34, false);
        ObjectManager.addPotionEffect("fear", true, 0x220022, false);
        ObjectManager.addPotionEffect("decay", true, 0x110033, false);
        ObjectManager.addPotionEffect("insomnia", true, 8738, false);
        ObjectManager.addPotionEffect("instability", true, 17442, false);
        ObjectManager.addPotionEffect("lifeleak", true, 22015, false);
        ObjectManager.addPotionEffect("bleed", true, 0xFF2222, false);
        ObjectManager.addPotionEffect("plague", true, 0x220066, false);
        ObjectManager.addPotionEffect("aphagia", true, 0xFFDDDD, false);
        ObjectManager.addPotionEffect("smited", true, 0xDDDDFF, false);
        ObjectManager.addPotionEffect("smouldering", true, 0xDD0000, false);
        ObjectManager.addPotionEffect("leech", false, 65433, true);
        ObjectManager.addPotionEffect("swiftswimming", false, 255, true);
        ObjectManager.addPotionEffect("fallresist", false, 0xDDFFFF, true);
        ObjectManager.addPotionEffect("rejuvenation", false, 0x99FFBB, true);
        ObjectManager.addPotionEffect("immunization", false, 0x66FFBB, true);
        ObjectManager.addPotionEffect("cleansed", false, 0x66BBFF, true);
        ObjectManager.addPotionEffect("repulsion", false, 12342062, true);
        ObjectManager.addPotionEffect("heataura", false, 0x996600, true);
        ObjectManager.addPotionEffect("staticaura", false, 268154193, true);
        ObjectManager.addPotionEffect("freezeaura", false, 0x55BBFF, true);
        ObjectManager.addPotionEffect("envenom", false, 0x44DD66, true);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ObjectManager.addSound("effect_fear", LycanitesMobs.modInfo, "effect.fear");
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        EffectBase immunization;
        EffectBase swiftswimming;
        EffectBase smouldering;
        EffectBase bleed;
        float brightness;
        EffectBase smited;
        EffectBase plague;
        EffectBase instability;
        ExtendedEntity extendedEntity;
        EffectBase fear;
        EffectBase weight;
        EffectBase paralysis;
        LivingEntity entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        for (Object potionEffectObj : entity.func_70651_bq()) {
            if (potionEffectObj != null) continue;
            entity.func_195061_cb();
            LycanitesMobs.logWarning("EffectsSetup", "Found a null potion effect on entity: " + entity + " all effects have been removed from this entity.");
        }
        if (entity.func_70644_a(net.minecraft.potion.Effects.field_76440_q) && entity.func_70644_a(net.minecraft.potion.Effects.field_76439_r)) {
            entity.func_195063_d(net.minecraft.potion.Effects.field_76440_q);
        }
        this.disableNausea = (Boolean)ConfigExtra.INSTANCE.disableNausea.get();
        if (this.disableNausea && event.getEntityLiving() instanceof PlayerEntity && entity.func_70644_a(net.minecraft.potion.Effects.field_76431_k)) {
            entity.func_195063_d(net.minecraft.potion.Effects.field_76431_k);
        }
        boolean invulnerable = false;
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            boolean bl = invulnerable = player.func_184812_l_() || player.func_175149_v();
        }
        if ((paralysis = ObjectManager.getEffect("paralysis")) != null && !invulnerable && entity.func_70644_a((Effect)paralysis)) {
            entity.func_213293_j(0.0, entity.func_213322_ci().func_82617_b() > 0.0 ? 0.0 : entity.func_213322_ci().func_82617_b(), 0.0);
            entity.field_70122_E = false;
        }
        if ((weight = ObjectManager.getEffect("weight")) != null && !invulnerable && entity.func_70644_a((Effect)weight) && !entity.func_70644_a(net.minecraft.potion.Effects.field_76420_g) && entity.func_213322_ci().func_82617_b() > -0.2) {
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(0.0, -0.2, 0.0));
        }
        if ((fear = ObjectManager.getEffect("fear")) != null && !entity.func_130014_f_().field_72995_K && !invulnerable && entity.func_70644_a((Effect)fear) && (extendedEntity = ExtendedEntity.getForEntity(entity)) != null && extendedEntity.fearEntity == null) {
            FearEntity fearEntity = new FearEntity(CreatureManager.getInstance().getEntityType("fear"), entity.func_130014_f_(), entity);
            entity.func_130014_f_().func_217376_c((Entity)fearEntity);
            extendedEntity.fearEntity = fearEntity;
        }
        if ((instability = ObjectManager.getEffect("instability")) != null && !entity.func_130014_f_().field_72995_K && !(entity instanceof IGroupBoss) && !invulnerable && entity.func_70644_a((Effect)instability) && entity.func_130014_f_().field_73012_v.nextDouble() <= 0.1) {
            double strength = (double)(1 + entity.func_70660_b((Effect)instability).func_76458_c()) * 0.5;
            double motionX = strength * (entity.func_130014_f_().field_73012_v.nextDouble() - 0.5);
            double motionY = strength * (entity.func_130014_f_().field_73012_v.nextDouble() - 0.5);
            double motionZ = strength * (entity.func_130014_f_().field_73012_v.nextDouble() - 0.5);
            entity.func_213317_d(entity.func_213322_ci().func_72441_c(motionX, motionY, motionZ));
            try {
                if (entity instanceof ServerPlayerEntity) {
                    ServerPlayerEntity player = (ServerPlayerEntity)entity;
                    player.field_71135_a.func_147359_a((IPacket)new SEntityVelocityPacket((Entity)entity));
                    MessageEntityVelocity messageEntityVelocity = new MessageEntityVelocity((Entity)player, strength * (entity.func_130014_f_().field_73012_v.nextDouble() - 0.5), strength * (entity.func_130014_f_().field_73012_v.nextDouble() - 0.5), strength * (entity.func_130014_f_().field_73012_v.nextDouble() - 0.5));
                    LycanitesMobs.packetHandler.sendToPlayer(messageEntityVelocity, player);
                }
            }
            catch (Exception e) {
                LycanitesMobs.logWarning("", "Failed to create and send a network packet for instability velocity!");
                e.printStackTrace();
            }
        }
        if ((plague = ObjectManager.getEffect("plague")) != null && !entity.func_130014_f_().field_72995_K && !invulnerable && entity.func_70644_a((Effect)plague)) {
            int poisonAmplifier = entity.func_70660_b((Effect)plague).func_76458_c();
            int poisonDuration = entity.func_70660_b((Effect)plague).func_76459_b();
            if (entity.func_70644_a(net.minecraft.potion.Effects.field_76436_u)) {
                poisonAmplifier = Math.max(poisonAmplifier, entity.func_70660_b(net.minecraft.potion.Effects.field_76436_u).func_76458_c());
                poisonDuration = Math.max(poisonDuration, entity.func_70660_b(net.minecraft.potion.Effects.field_76436_u).func_76459_b());
            }
            entity.func_195064_c(new EffectInstance(net.minecraft.potion.Effects.field_76436_u, poisonDuration, poisonAmplifier));
            if (entity.func_130014_f_().func_82737_E() % 20L == 0L) {
                List<LivingEntity> aoeTargets = this.getNearbyEntities((Entity)entity, LivingEntity.class, null, 2.0);
                for (LivingEntity entityObj : aoeTargets) {
                    LivingEntity target = entityObj;
                    if (target == entity || entity.func_184191_r((Entity)target) || target instanceof PlayerEntity && !entity.func_70685_l((Entity)target)) continue;
                    int amplifier = entity.func_70660_b((Effect)plague).func_76458_c();
                    int duration = entity.func_70660_b((Effect)plague).func_76459_b();
                    if (amplifier > 0) {
                        target.func_195064_c(new EffectInstance((Effect)plague, duration, amplifier - 1));
                        continue;
                    }
                    target.func_195064_c(new EffectInstance(net.minecraft.potion.Effects.field_76436_u, duration, amplifier));
                }
            }
        }
        if ((smited = ObjectManager.getEffect("smited")) != null && !entity.func_130014_f_().field_72995_K && !invulnerable && entity.func_70644_a((Effect)smited) && entity.func_130014_f_().func_82737_E() % 20L == 0L && (brightness = entity.func_70013_c()) > 0.5f && entity.func_130014_f_().func_175710_j(entity.func_180425_c())) {
            entity.func_70015_d(4);
        }
        if ((bleed = ObjectManager.getEffect("bleed")) != null && !entity.func_130014_f_().field_72995_K && !invulnerable && entity.func_70644_a((Effect)bleed) && entity.func_130014_f_().func_82737_E() % 20L == 0L && entity.func_184187_bx() != null && entity.field_70141_P != entity.field_70140_Q) {
            entity.func_70097_a(DamageSource.field_76376_m, (float)(entity.func_70660_b((Effect)bleed).func_76458_c() + 1));
        }
        if ((smouldering = ObjectManager.getEffect("smouldering")) != null && !entity.func_130014_f_().field_72995_K && !invulnerable && entity.func_70644_a((Effect)smouldering) && entity.func_130014_f_().func_82737_E() % 20L == 0L) {
            entity.func_70015_d(4 + 4 * entity.func_70660_b((Effect)smouldering).func_76458_c());
        }
        if ((swiftswimming = ObjectManager.getEffect("swiftswimming")) != null && entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            if (entity.func_70644_a((Effect)swiftswimming) && entity.func_70090_H()) {
                int amplifier = entity.func_70660_b((Effect)swiftswimming).func_76458_c();
                IAttributeInstance movement = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
                if (movement.func_111127_a(swiftswimmingMoveBoostUUID) == null) {
                    movement.func_111121_a(swiftswimmingMoveBoost);
                }
            } else {
                IAttributeInstance movement = entity.func_110148_a(SharedMonsterAttributes.field_111263_d);
                if (movement.func_111127_a(swiftswimmingMoveBoostUUID) != null) {
                    movement.func_111124_b(swiftswimmingMoveBoost);
                }
            }
        }
        if ((immunization = ObjectManager.getEffect("immunization")) != null && !entity.func_130014_f_().field_72995_K && entity.func_70644_a((Effect)ObjectManager.getEffect("immunization"))) {
            if (entity.func_70644_a(net.minecraft.potion.Effects.field_76436_u)) {
                entity.func_195063_d(net.minecraft.potion.Effects.field_76436_u);
            }
            if (entity.func_70644_a(net.minecraft.potion.Effects.field_76438_s)) {
                entity.func_195063_d(net.minecraft.potion.Effects.field_76438_s);
            }
            if (entity.func_70644_a(net.minecraft.potion.Effects.field_76437_t)) {
                entity.func_195063_d(net.minecraft.potion.Effects.field_76437_t);
            }
            if (entity.func_70644_a(net.minecraft.potion.Effects.field_76431_k)) {
                entity.func_195063_d(net.minecraft.potion.Effects.field_76431_k);
            }
            if (ObjectManager.getEffect("paralysis") != null && entity.func_70644_a((Effect)ObjectManager.getEffect("paralysis"))) {
                entity.func_195063_d((Effect)ObjectManager.getEffect("paralysis"));
            }
        }
        EffectBase cleansed = ObjectManager.getEffect("cleansed");
        if (ObjectManager.getEffect("cleansed") != null && !entity.func_130014_f_().field_72995_K && entity.func_70644_a((Effect)ObjectManager.getEffect("cleansed"))) {
            if (entity.func_70644_a(net.minecraft.potion.Effects.field_82731_v)) {
                entity.func_195063_d(net.minecraft.potion.Effects.field_82731_v);
            }
            if (entity.func_70644_a(net.minecraft.potion.Effects.field_189112_A)) {
                entity.func_195063_d(net.minecraft.potion.Effects.field_189112_A);
            }
            if (ObjectManager.getEffect("fear") != null && entity.func_70644_a((Effect)ObjectManager.getEffect("fear"))) {
                entity.func_195063_d((Effect)ObjectManager.getEffect("fear"));
            }
            if (ObjectManager.getEffect("insomnia") != null && entity.func_70644_a((Effect)ObjectManager.getEffect("insomnia"))) {
                entity.func_195063_d((Effect)ObjectManager.getEffect("insomnia"));
            }
        }
    }

    @SubscribeEvent
    public void onEntityJump(LivingEvent.LivingJumpEvent event) {
        EffectBase weight;
        LivingEntity entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        boolean invulnerable = false;
        if (entity instanceof PlayerEntity) {
            PlayerEntity player = (PlayerEntity)entity;
            invulnerable = player.field_71075_bZ.field_75102_a;
        }
        if (invulnerable) {
            return;
        }
        EffectBase paralysis = ObjectManager.getEffect("paralysis");
        if (paralysis != null && entity.func_70644_a((Effect)paralysis) && event.isCancelable()) {
            event.setCanceled(true);
        }
        if ((weight = ObjectManager.getEffect("weight")) != null && entity.func_70644_a((Effect)weight) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        if (event.isCancelable() && event.isCanceled()) {
            return;
        }
        if (event.getEntityLiving() == null) {
            return;
        }
        LivingEntity target = event.getEntityLiving();
        LivingEntity attacker = null;
        if (event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof LivingEntity) {
            attacker = (LivingEntity)event.getSource().func_76346_g();
        }
        if (attacker == null) {
            return;
        }
        EffectBase lifeleak = ObjectManager.getEffect("lifeleak");
        if (lifeleak != null && !event.getEntityLiving().func_130014_f_().field_72995_K && attacker.func_70644_a((Effect)lifeleak)) {
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            target.func_70691_i(event.getAmount());
        }
    }

    @SubscribeEvent
    public void onLivingHurt(LivingHurtEvent event) {
        EffectBase repulsion;
        LivingEntity attackingEntity;
        EffectBase leech;
        EffectBase fear;
        EffectBase penetration;
        if (event.isCancelable() && event.isCanceled()) {
            return;
        }
        if (event.getEntityLiving() == null) {
            return;
        }
        LivingEntity target = event.getEntityLiving();
        Entity attacker = event.getSource().func_76346_g();
        EffectBase fallresist = ObjectManager.getEffect("fallresist");
        if (fallresist != null && event.getEntityLiving().func_70644_a((Effect)fallresist) && "fall".equals(event.getSource().field_76373_n)) {
            event.setAmount(0.0f);
            event.setCanceled(true);
        }
        if ((penetration = ObjectManager.getEffect("penetration")) != null && event.getEntityLiving().func_70644_a((Effect)penetration)) {
            float damage = event.getAmount();
            float multiplier = event.getEntityLiving().func_70660_b((Effect)penetration).func_76458_c();
            event.setAmount(damage + damage * multiplier);
        }
        if ((fear = ObjectManager.getEffect("fear")) != null && event.getEntityLiving().func_70644_a((Effect)fear) && "inWall".equals(event.getSource().field_76373_n)) {
            event.setAmount(0.0f);
            event.setCanceled(true);
        }
        if ((leech = ObjectManager.getEffect("leech")) != null && event.getSource().func_76346_g() != null && event.getSource().func_76346_g() instanceof LivingEntity && (attackingEntity = (LivingEntity)event.getSource().func_76346_g()).func_70644_a((Effect)leech)) {
            float damage = event.getAmount();
            float multiplier = attackingEntity.func_70660_b((Effect)leech).func_76458_c() + 1;
            attackingEntity.func_70691_i(Math.max(damage * multiplier * 0.25f, 1.0f));
        }
        if ((repulsion = ObjectManager.getEffect("repulsion")) != null && attacker != null && !(attacker instanceof IGroupBoss) && target.func_70644_a((Effect)repulsion)) {
            float knockback = target.func_70660_b((Effect)repulsion).func_76458_c() + 2;
            double xDist = target.func_213303_ch().func_82615_a() - attacker.func_213303_ch().func_82615_a();
            double zDist = target.func_213303_ch().func_82616_c() - attacker.func_213303_ch().func_82616_c();
            double xzDist = MathHelper.func_76133_a((double)(xDist * xDist + zDist * zDist));
            double motionCap = 10.0;
            if (attacker.func_213322_ci().func_82615_a() < motionCap && attacker.func_213322_ci().func_82615_a() > -motionCap && attacker.func_213322_ci().func_82616_c() < motionCap && attacker.func_213322_ci().func_82616_c() > -motionCap) {
                attacker.func_70024_g(xDist / xzDist * (double)knockback - attacker.func_213322_ci().func_82615_a() * (double)knockback, 0.0, zDist / xzDist * (double)knockback - attacker.func_213322_ci().func_82616_c() * (double)knockback);
            }
        }
    }

    @SubscribeEvent
    public void onEntityHeal(LivingHealEvent event) {
        EffectBase decay;
        LivingEntity entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        EffectBase rejuvenation = ObjectManager.getEffect("rejuvenation");
        if (rejuvenation != null && entity.func_70644_a((Effect)rejuvenation)) {
            event.setAmount((float)Math.ceil(event.getAmount() * (float)(2 * (1 + entity.func_70660_b((Effect)rejuvenation).func_76458_c()))));
        }
        if ((decay = ObjectManager.getEffect("decay")) != null && entity.func_70644_a((Effect)decay)) {
            event.setAmount((float)Math.floor(event.getAmount() / (float)(2 * (1 + entity.func_70660_b((Effect)decay).func_76458_c()))));
        }
    }

    @SubscribeEvent
    public void onSleep(PlayerSleepInBedEvent event) {
        PlayerEntity player = event.getPlayer();
        if (player == null || player.func_130014_f_().field_72995_K || event.isCanceled()) {
            return;
        }
        EffectBase insomnia = ObjectManager.getEffect("insomnia");
        if (insomnia != null && player.func_70644_a((Effect)insomnia)) {
            event.setResult(PlayerEntity.SleepResult.NOT_SAFE);
        }
    }

    @SubscribeEvent
    public void onLivingUseItem(LivingEntityUseItemEvent event) {
        if (event.isCancelable() && event.isCanceled()) {
            return;
        }
        if (event.getEntityLiving() == null) {
            return;
        }
        EffectBase aphagia = ObjectManager.getEffect("aphagia");
        if (aphagia != null && !event.getEntityLiving().func_130014_f_().field_72995_K && event.getEntityLiving().func_70644_a((Effect)aphagia) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    public <T extends Entity> List<T> getNearbyEntities(Entity searchEntity, Class<? extends T> clazz, Class filterClass, double range) {
        return searchEntity.func_130014_f_().func_175647_a(clazz, searchEntity.func_174813_aQ().func_72314_b(range, range, range), (Predicate)((com.google.common.base.Predicate)entity -> {
            if (filterClass == null) {
                return true;
            }
            return filterClass.isAssignableFrom(entity.getClass());
        }));
    }
}

