/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.renderer.layer.specific;

import com.lycanitesmobs.client.TextureManager;
import com.lycanitesmobs.client.renderer.CreatureRenderer;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LayerDjinn
extends LayerCreatureBase {
    public LayerDjinn(CreatureRenderer renderer) {
        super(renderer);
    }

    @Override
    public boolean canRenderPart(String partName, BaseCreatureEntity entity, boolean trophy) {
        return partName.contains("ribbon");
    }

    @Override
    public ResourceLocation getLayerTexture(BaseCreatureEntity entity) {
        String textureName = entity.getTextureName();
        if (entity.getSubspecies() != null) {
            textureName = textureName + "_" + entity.getSubspecies().color;
        }
        if (TextureManager.getTexture(textureName = textureName + "_ribbon") == null) {
            TextureManager.addTexture(textureName, entity.creatureInfo.modInfo, "textures/entity/" + textureName.toLowerCase() + ".png");
        }
        return TextureManager.getTexture(textureName);
    }

    @Override
    public Vec2f getTextureOffset(String partName, BaseCreatureEntity entity, boolean trophy, float loop) {
        return new Vec2f(-loop * 25.0f, 0.0f);
    }

    @Override
    public Vector4f getPartColor(String partName, BaseCreatureEntity entity, boolean trophy) {
        return new Vector4f(1.0f, 1.0f, 1.0f, 0.75f);
    }
}

