/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.renderer.layer;

import com.lycanitesmobs.client.renderer.IItemModelRenderer;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LayerItem {
    public IItemModelRenderer renderer;
    public String name;
    public String textureSuffix;
    public boolean glow = false;
    public int blending = 0;
    public Vec2f scrollSpeed;
    public Vector4f colorFadeSpeed;

    public LayerItem(IItemModelRenderer renderer, String name) {
        this.renderer = renderer;
        this.name = name;
    }

    public Vector4f getPartColor(String partName, ItemStack itemStack, float loop) {
        if (this.colorFadeSpeed != null) {
            float red = 1.0f;
            if (this.colorFadeSpeed.func_195910_a() != 0.0f) {
                red = loop % this.colorFadeSpeed.func_195910_a() / this.colorFadeSpeed.func_195910_a() * 2.0f;
            }
            if (red > 1.0f) {
                red = -(red - 1.0f);
            }
            float green = 1.0f;
            if (this.colorFadeSpeed.func_195913_b() != 0.0f) {
                green = loop % this.colorFadeSpeed.func_195913_b() / this.colorFadeSpeed.func_195913_b() * 2.0f;
            }
            if (green > 1.0f) {
                green = -(green - 1.0f);
            }
            float blue = 1.0f;
            if (this.colorFadeSpeed.func_195914_c() != 0.0f) {
                blue = loop % this.colorFadeSpeed.func_195914_c() / this.colorFadeSpeed.func_195914_c() * 2.0f;
            }
            if (blue > 1.0f) {
                blue = -(blue - 1.0f);
            }
            float alpha = 1.0f;
            if (this.colorFadeSpeed.func_195915_d() != 0.0f) {
                alpha = loop % this.colorFadeSpeed.func_195915_d() / this.colorFadeSpeed.func_195915_d() * 2.0f;
            }
            if (alpha > 1.0f) {
                alpha = -(alpha - 1.0f);
            }
            return new Vector4f(red, green, blue, alpha);
        }
        return new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public ResourceLocation getLayerTexture(ItemStack itemStack) {
        return null;
    }

    public int getBrightness(String partName, ItemStack itemStack, int brightness) {
        if (this.glow) {
            return 240;
        }
        return brightness;
    }

    public Vec2f getTextureOffset(String partName, ItemStack itemStack, float loop) {
        if (this.scrollSpeed == null) {
            this.scrollSpeed = new Vec2f(0.0f, 0.0f);
        }
        return new Vec2f(loop * this.scrollSpeed.field_189982_i, loop * this.scrollSpeed.field_189983_j);
    }

    public static enum BLEND {
        NORMAL(0),
        ADD(1),
        SUB(2);

        public final int id;

        private BLEND(int value) {
            this.id = value;
        }

        public int getValue() {
            return this.id;
        }
    }
}

