/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.renderer.layer;

import com.lycanitesmobs.client.renderer.CreatureRenderer;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class LayerCreatureEffect
extends LayerCreatureBase {
    public String textureSuffix;
    public boolean subspecies = true;
    public boolean glow = false;
    public int blending = 0;
    public Vec2f scrollSpeed;

    public LayerCreatureEffect(CreatureRenderer renderer, String textureSuffix) {
        super(renderer);
        this.name = textureSuffix;
        this.textureSuffix = textureSuffix;
    }

    public LayerCreatureEffect(CreatureRenderer renderer, String textureSuffix, boolean glow, int blending, boolean subspecies) {
        super(renderer);
        this.name = textureSuffix;
        this.textureSuffix = textureSuffix;
        this.glow = glow;
        this.blending = blending;
        this.subspecies = subspecies;
    }

    public LayerCreatureEffect(CreatureRenderer renderer, String name, String textureSuffix, boolean glow, int blending, boolean subspecies) {
        super(renderer);
        this.name = name;
        this.textureSuffix = textureSuffix;
        this.glow = glow;
        this.blending = blending;
        this.subspecies = subspecies;
    }

    @Override
    public Vector4f getPartColor(String partName, BaseCreatureEntity entity, boolean trophy) {
        return new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public ResourceLocation getLayerTexture(BaseCreatureEntity entity) {
        return entity.getTexture(this.textureSuffix);
    }

    @Override
    public Vec2f getTextureOffset(String partName, BaseCreatureEntity entity, boolean trophy, float loop) {
        if (this.scrollSpeed == null) {
            this.scrollSpeed = new Vec2f(0.0f, 0.0f);
        }
        return new Vec2f(loop * this.scrollSpeed.field_189982_i, loop * this.scrollSpeed.field_189983_j);
    }

    @Override
    public int getBrightness(String partName, BaseCreatureEntity entity, int brightness) {
        if (this.glow) {
            return 240;
        }
        return brightness;
    }

    public static enum BLEND {
        NORMAL(0),
        ADD(1),
        SUB(2);

        public final int id;

        private BLEND(int value) {
            this.id = value;
        }

        public int getValue() {
            return this.id;
        }
    }
}

