/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.renderer;

import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.client.renderer.CreatureRenderFactory;
import com.lycanitesmobs.client.renderer.ProjectileRenderFactory;
import com.lycanitesmobs.client.renderer.RenderFactoryNone;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import net.minecraft.entity.Entity;
import net.minecraftforge.fml.client.registry.RenderingRegistry;

public class RenderRegister {
    public void registerModelLoaders() {
    }

    public void registerRenderFactories() {
        Class<? extends Entity> projectileClass;
        for (CreatureInfo creatureInfo : CreatureManager.getInstance().creatures.values()) {
            if (creatureInfo.dummy) {
                RenderingRegistry.registerEntityRenderingHandler(creatureInfo.getEntityType(), new RenderFactoryNone(creatureInfo.entityClass));
            }
            RenderingRegistry.registerEntityRenderingHandler(creatureInfo.getEntityType(), new CreatureRenderFactory(creatureInfo));
        }
        for (ProjectileInfo projectileInfo : ProjectileManager.getInstance().projectiles.values()) {
            if (projectileInfo.modelClassName != null) {
                RenderingRegistry.registerEntityRenderingHandler(projectileInfo.getEntityType(), new ProjectileRenderFactory(projectileInfo));
                continue;
            }
            RenderingRegistry.registerEntityRenderingHandler(projectileInfo.getEntityType(), new ProjectileRenderFactory(projectileInfo));
        }
        for (String string : ProjectileManager.getInstance().oldSpriteProjectiles.keySet()) {
            projectileClass = ProjectileManager.getInstance().oldSpriteProjectiles.get(string);
            RenderingRegistry.registerEntityRenderingHandler(ProjectileManager.getInstance().oldProjectileTypes.get(projectileClass), new ProjectileRenderFactory(string, projectileClass, false));
        }
        for (String string : ProjectileManager.getInstance().oldModelProjectiles.keySet()) {
            projectileClass = ProjectileManager.getInstance().oldModelProjectiles.get(string);
            RenderingRegistry.registerEntityRenderingHandler(ProjectileManager.getInstance().oldProjectileTypes.get(projectileClass), new ProjectileRenderFactory(string, projectileClass, true));
        }
        for (Class clazz : ObjectManager.specialEntities.values()) {
            RenderingRegistry.registerEntityRenderingHandler(ObjectManager.specialEntityTypes.get(clazz), new RenderFactoryNone(clazz));
        }
    }
}

