/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.renderer;

import com.lycanitesmobs.client.renderer.CustomRenderStates;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.entity.CustomProjectileEntity;
import com.lycanitesmobs.core.entity.LaserProjectileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ProjectileSpriteRenderer
extends EntityRenderer<BaseProjectileEntity> {
    private Class projectileClass;

    public ProjectileSpriteRenderer(EntityRendererManager renderManager, Class projectileClass) {
        super(renderManager);
        this.projectileClass = projectileClass;
    }

    public void func_225623_a_(BaseProjectileEntity entity, float partialTicks, float yaw, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int brightness) {
        if (entity instanceof CustomProjectileEntity && ((CustomProjectileEntity)entity).projectileInfo == null) {
            return;
        }
        float loop = (float)entity.field_70173_aa + partialTicks;
        float scale = entity.projectileScale;
        matrixStack.func_227860_a_();
        matrixStack.func_227863_a_(this.field_76990_c.func_229098_b_());
        matrixStack.func_227863_a_(new Vector3f(0.0f, 1.0f, 0.0f).func_229187_a_(180.0f));
        matrixStack.func_227863_a_(new Vector3f(0.0f, 0.0f, 1.0f).func_229187_a_(loop * entity.spinSpeed));
        matrixStack.func_227862_a_(scale, scale, scale);
        matrixStack.func_227861_a_(0.0, (double)entity.getTextureOffsetY(), 0.0);
        ResourceLocation texture = this.getEntityTexture(entity);
        RenderType rendertype = CustomRenderStates.getSpriteRenderType(texture);
        this.renderSprite(entity, matrixStack, renderTypeBuffer, rendertype, entity.textureScale);
        matrixStack.func_227865_b_();
        if (entity instanceof LaserProjectileEntity) {
            matrixStack.func_227860_a_();
            this.renderLaser((LaserProjectileEntity)entity, matrixStack, renderTypeBuffer, ((LaserProjectileEntity)entity).laserWidth / 4.0f);
            matrixStack.func_227865_b_();
        }
    }

    public void renderSprite(BaseProjectileEntity entity, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, RenderType rendertype, float scale) {
        float textureWidth = 0.5f;
        float textureHeight = 0.5f;
        float minU = 0.0f;
        float maxU = 1.0f;
        float minV = 0.0f;
        float maxV = 1.0f;
        if (entity.animationFrameMax > 0) {
            minV = (float)entity.animationFrame / (float)entity.animationFrameMax;
            maxV = minV + 1.0f / (float)entity.animationFrameMax;
            textureWidth *= scale;
            textureHeight *= scale;
        }
        Matrix4f matrix4f = matrixStack.func_227866_c_().func_227870_a_();
        IVertexBuilder vertexBuilder = renderTypeBuffer.getBuffer(rendertype);
        vertexBuilder.func_227888_a_(matrix4f, -textureWidth, -textureHeight + textureHeight / 2.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(minU, maxV).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix4f, textureWidth, -textureHeight + textureHeight / 2.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(maxU, maxV).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix4f, textureWidth, textureHeight + textureHeight / 2.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(maxU, minV).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
        vertexBuilder.func_227888_a_(matrix4f, -textureWidth, textureHeight + textureHeight / 2.0f, 0.0f).func_227885_a_(1.0f, 1.0f, 1.0f, 1.0f).func_225583_a_(minU, minV).func_225584_a_(0.0f, 1.0f, 0.0f).func_181675_d();
    }

    public void renderLaser(LaserProjectileEntity entity, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, float scale) {
        float laserSize = entity.getLength();
        float spacing = 1.0f;
        float factor = spacing / laserSize;
        if (laserSize <= 0.0f || entity.getLaserEnd() == null) {
            return;
        }
        ResourceLocation texture = this.getEntityTexture(entity);
        RenderType rendertype = CustomRenderStates.getSpriteRenderType(texture);
        Vec3d direction = entity.getLaserEnd().func_213303_ch().func_178788_d(entity.func_213303_ch()).func_72432_b();
        for (float segment = 0.0f; segment <= laserSize; segment += factor) {
            matrixStack.func_227860_a_();
            matrixStack.func_227861_a_((double)segment * direction.func_82615_a() * (double)spacing, (double)segment * direction.func_82617_b() * (double)spacing, (double)segment * direction.func_82616_c() * (double)spacing);
            matrixStack.func_227861_a_(0.0, (double)entity.getTextureOffsetY(), 0.0);
            matrixStack.func_227863_a_(this.field_76990_c.func_229098_b_());
            matrixStack.func_227863_a_(new Vector3f(0.0f, 1.0f, 0.0f).func_229187_a_(180.0f));
            matrixStack.func_227862_a_(scale, scale, scale);
            this.renderSprite(entity, matrixStack, renderTypeBuffer, rendertype, scale);
            matrixStack.func_227865_b_();
        }
    }

    public ResourceLocation getEntityTexture(BaseProjectileEntity entity) {
        return entity.getTexture();
    }

    protected ResourceLocation getLaserTexture(LaserProjectileEntity entity) {
        return entity.getBeamTexture();
    }

    public void bindTexture(ResourceLocation texture) {
    }
}

