/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.renderer;

import com.google.common.collect.Lists;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.ModelManager;
import com.lycanitesmobs.client.model.ProjectileModel;
import com.lycanitesmobs.client.model.ProjectileObjModel;
import com.lycanitesmobs.client.renderer.CustomRenderStates;
import com.lycanitesmobs.client.renderer.layer.LayerProjectileBase;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ProjectileModelRenderer
extends EntityRenderer<BaseProjectileEntity>
implements IEntityRenderer<BaseProjectileEntity, ProjectileModel> {
    protected ProjectileModel renderModel;
    protected ProjectileModel defaultModel;
    protected final List<LayerRenderer<BaseProjectileEntity, ProjectileModel>> renderLayers = Lists.newArrayList();

    public ProjectileModelRenderer(EntityRendererManager renderManager, ProjectileInfo projectileInfo) {
        super(renderManager);
        this.defaultModel = this.renderModel = ModelManager.getInstance().getProjectileModel(projectileInfo);
        this.renderModel.addCustomLayers(this);
    }

    public ProjectileModelRenderer(EntityRendererManager renderManager, String projectileName) {
        super(renderManager);
        ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile(projectileName);
        this.renderModel = projectileInfo != null ? ModelManager.getInstance().getProjectileModel(projectileInfo) : ModelManager.getInstance().getOldProjectileModel(projectileName);
        if (this.renderModel == null) {
            return;
        }
        this.defaultModel = this.renderModel;
        this.renderModel.addCustomLayers(this);
    }

    public void func_225623_a_(BaseProjectileEntity entity, float partialTicks, float yaw, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int brightness) {
        float time = 0.0f;
        float distance = 0.0f;
        float loop = (float)entity.field_70173_aa + partialTicks;
        float lookYaw = 0.0f;
        float lookPitch = 0.0f;
        float scale = 1.0f;
        boolean invisible = false;
        boolean allyInvisible = false;
        try {
            matrixStack.func_227861_a_(0.0, -0.25, 0.0);
            matrixStack.func_227862_a_(0.25f, 0.25f, 0.25f);
            matrixStack.func_227863_a_(new Vector3f(0.0f, 1.0f, 0.0f).func_229187_a_(entity.field_70177_z));
            if (this.renderModel == null) {
                LycanitesMobs.logWarning("", "Missing Projectile Model: " + (Object)((Object)entity));
            } else if (!(this.renderModel instanceof ProjectileObjModel)) {
                ResourceLocation texture = this.getEntityTexture(entity);
                if (texture == null) {
                    return;
                }
                RenderType renderType = CustomRenderStates.getObjRenderType(texture);
                this.renderModel.render(entity, matrixStack, renderTypeBuffer.getBuffer(renderType), null, 0.0f, 0.0f, loop, 0.0f, 0.0f, scale, brightness);
            } else {
                this.getEntityModel().generateAnimationFrames(entity, time, distance, loop, lookYaw, lookPitch, 1.0f, brightness);
                this.renderModel(entity, matrixStack, renderTypeBuffer, null, time, distance, loop, lookYaw, lookPitch, 1.0f, brightness, invisible, allyInvisible);
                for (LayerRenderer<BaseProjectileEntity, ProjectileModel> layer : this.renderLayers) {
                    LayerProjectileBase layerCreatureBase;
                    if (!(layer instanceof LayerProjectileBase) || !(layerCreatureBase = (LayerProjectileBase)layer).canRenderLayer(entity, scale)) continue;
                    this.renderModel(entity, matrixStack, renderTypeBuffer, layerCreatureBase, time, distance, loop, lookYaw, lookPitch, scale, brightness, invisible, allyInvisible);
                }
                this.getEntityModel().clearAnimationFrames();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    protected void renderModel(BaseProjectileEntity entity, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, LayerProjectileBase layer, float time, float distance, float loop, float lookY, float lookX, float scale, int brightness, boolean invisible, boolean allyInvisible) {
        ResourceLocation texture = this.getEntityTexture(entity, layer);
        if (texture == null) {
            return;
        }
        RenderType rendertype = allyInvisible ? RenderType.func_228644_e_((ResourceLocation)texture) : (invisible ? RenderType.func_228654_j_((ResourceLocation)texture) : CustomRenderStates.getObjRenderType(texture));
        this.getEntityModel().render(entity, matrixStack, renderTypeBuffer.getBuffer(rendertype), layer, time, distance, loop, lookY, lookX, 1.0f, brightness);
    }

    public ProjectileModel getEntityModel() {
        return this.renderModel;
    }

    public final boolean addLayer(LayerRenderer<BaseProjectileEntity, ProjectileModel> layer) {
        return this.renderLayers.add(layer);
    }

    public ResourceLocation getEntityTexture(BaseProjectileEntity entity, LayerProjectileBase layer) {
        if (layer == null) {
            return this.getEntityTexture(entity);
        }
        ResourceLocation layerTexture = layer.getLayerTexture(entity);
        return layerTexture != null ? layerTexture : this.getEntityTexture(entity);
    }

    public ResourceLocation getEntityTexture(BaseProjectileEntity entity) {
        return entity.getTexture();
    }
}

