/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.renderer;

import com.lycanitesmobs.client.ModelManager;
import com.lycanitesmobs.client.model.AnimationPart;
import com.lycanitesmobs.client.model.ItemObjModel;
import com.lycanitesmobs.client.model.ModelEquipmentPart;
import com.lycanitesmobs.client.renderer.CustomRenderStates;
import com.lycanitesmobs.client.renderer.IItemModelRenderer;
import com.lycanitesmobs.client.renderer.layer.LayerItem;
import com.lycanitesmobs.core.item.equipment.ItemEquipmentPart;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.tileentity.ItemStackTileEntityRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;

public class EquipmentPartRenderer
extends ItemStackTileEntityRenderer
implements IItemModelRenderer {
    protected List<LayerItem> renderLayers = new ArrayList<LayerItem>();

    public void func_228364_a_(ItemStack itemStack, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int brightness, int unknown) {
        if (!(itemStack.func_77973_b() instanceof ItemEquipmentPart)) {
            return;
        }
        Hand hand = null;
        ItemEquipmentPart itemEquipmentPart = (ItemEquipmentPart)itemStack.func_77973_b();
        ModelEquipmentPart itemObjModel = ModelManager.getInstance().getEquipmentPartModel(itemEquipmentPart);
        if (itemObjModel == null) {
            return;
        }
        this.renderLayers.clear();
        itemObjModel.addCustomLayers(this);
        float loop = 0.0f;
        if (Minecraft.func_71410_x().field_71439_g != null) {
            loop = Minecraft.func_71410_x().field_71439_g.field_70173_aa;
        }
        matrixStack.func_227861_a_((double)0.6f, (double)0.35f, 0.5);
        matrixStack.func_227863_a_(new Vector3f(1.0f, 0.0f, 0.0f).func_229187_a_(190.0f));
        matrixStack.func_227863_a_(new Vector3f(0.0f, 1.0f, 0.0f).func_229187_a_(-45.0f));
        matrixStack.func_227863_a_(new Vector3f(0.0f, 0.0f, 1.0f).func_229187_a_(10.0f));
        matrixStack.func_227861_a_(0.0, (double)-1.7f, 0.0);
        matrixStack.func_227860_a_();
        if ("head".equalsIgnoreCase(itemEquipmentPart.slotType)) {
            matrixStack.func_227861_a_(0.0, 0.0, 0.5);
        } else if ("blade".equalsIgnoreCase(itemEquipmentPart.slotType) || "pike".equalsIgnoreCase(itemEquipmentPart.slotType) || "axe".equalsIgnoreCase(itemEquipmentPart.slotType)) {
            matrixStack.func_227861_a_(0.0, 0.0, 1.0);
        }
        itemObjModel.generateAnimationFrames(itemStack, null, loop, null);
        this.renderModel(itemObjModel, itemStack, hand, matrixStack, renderTypeBuffer, null, null, loop, brightness);
        for (LayerItem renderLayer : this.renderLayers) {
            this.renderModel(itemObjModel, itemStack, hand, matrixStack, renderTypeBuffer, renderLayer, null, loop, brightness);
        }
        itemObjModel.clearAnimationFrames();
        matrixStack.func_227865_b_();
    }

    protected void renderModel(ItemObjModel model, ItemStack itemStack, Hand hand, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, LayerItem layer, AnimationPart offsetObjPart, float loop, int brightness) {
        ResourceLocation texture = model.getTexture(itemStack, layer);
        RenderType renderType = CustomRenderStates.getObjRenderType(texture);
        model.render(itemStack, hand, matrixStack, renderTypeBuffer.getBuffer(renderType), this, offsetObjPart, layer, loop, brightness);
    }

    @Override
    public void bindItemTexture(ResourceLocation location) {
        if (location == null) {
            return;
        }
        Minecraft.func_71410_x().func_110434_K().func_110577_a(location);
    }

    @Override
    public List<LayerItem> addLayer(LayerItem renderLayer) {
        if (!this.renderLayers.contains(renderLayer)) {
            this.renderLayers.add(renderLayer);
        }
        return this.renderLayers;
    }
}

