/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.renderer;

import com.lycanitesmobs.client.ModelManager;
import com.lycanitesmobs.client.model.CreatureModel;
import com.lycanitesmobs.client.renderer.CustomRenderStates;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.info.CreatureManager;
import com.mojang.blaze3d.matrix.MatrixStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.entity.MobRenderer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CreatureRenderer
extends MobRenderer<BaseCreatureEntity, CreatureModel> {
    public CreatureRenderer(String entityID, EntityRendererManager renderManager, float shadowSize) {
        super(renderManager, (EntityModel)ModelManager.getInstance().getCreatureModel(CreatureManager.getInstance().getCreature(entityID), null), shadowSize);
        if (this.field_77045_g == null) {
            return;
        }
    }

    public void func_225623_a_(BaseCreatureEntity entity, float partialTicks, float yaw, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int brightness) {
        Direction direction;
        boolean shouldSit;
        try {
            this.field_177097_h.clear();
            this.field_77045_g = ModelManager.getInstance().getCreatureModel(entity.creatureInfo, entity.subspecies);
            ((CreatureModel)this.field_77045_g).addCustomLayers(this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (this.field_77045_g == null) {
            return;
        }
        float scale = 1.0f;
        ((CreatureModel)this.field_77045_g).field_217113_d = shouldSit = entity.func_184218_aH() && entity.func_184187_bx() != null && entity.func_184187_bx().shouldRiderSit();
        ((CreatureModel)this.field_77045_g).field_217114_e = entity.func_70631_g_();
        float renderYaw = MathHelper.func_219805_h((float)yaw, (float)entity.field_70760_ar, (float)entity.field_70761_aq);
        float renderYawHead = MathHelper.func_219805_h((float)yaw, (float)entity.field_70758_at, (float)entity.field_70759_as);
        float lookYaw = renderYawHead - renderYaw;
        if (shouldSit && entity.func_184187_bx() instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity.func_184187_bx();
            renderYaw = MathHelper.func_219805_h((float)yaw, (float)livingentity.field_70760_ar, (float)livingentity.field_70761_aq);
            lookYaw = renderYawHead - renderYaw;
            float renderYawMountOffset = MathHelper.func_76142_g((float)lookYaw);
            if (renderYawMountOffset < -85.0f) {
                renderYawMountOffset = -85.0f;
            }
            if (renderYawMountOffset >= 85.0f) {
                renderYawMountOffset = 85.0f;
            }
            renderYaw = renderYawHead - renderYawMountOffset;
            if (renderYawMountOffset * renderYawMountOffset > 2500.0f) {
                renderYaw += renderYawMountOffset * 0.2f;
            }
            lookYaw = renderYawHead - renderYaw;
        }
        matrixStack.func_227860_a_();
        float lookPitch = MathHelper.func_219799_g((float)yaw, (float)entity.field_70127_C, (float)entity.field_70125_A);
        if (entity.func_213283_Z() == Pose.SLEEPING && (direction = entity.func_213376_dz()) != null) {
            float f4 = entity.func_213307_e(Pose.STANDING) - 0.1f;
            matrixStack.func_227861_a_((double)((float)(-direction.func_82601_c()) * f4), 0.0, (double)((float)(-direction.func_82599_e()) * f4));
        }
        float loop = this.func_77044_a((LivingEntity)entity, partialTicks);
        this.func_225621_a_((LivingEntity)entity, matrixStack, loop, renderYaw, yaw);
        matrixStack.func_227862_a_(-1.0f, -1.0f, 1.0f);
        this.func_225620_a_((LivingEntity)entity, matrixStack, yaw);
        matrixStack.func_227861_a_(0.0, (double)-1.501f, 0.0);
        float distance = 0.0f;
        float time = 0.0f;
        if (!shouldSit && entity.func_70089_S()) {
            distance = MathHelper.func_219799_g((float)yaw, (float)entity.field_184618_aE, (float)entity.field_70721_aZ);
            time = entity.field_184619_aG - entity.field_70721_aZ * (1.0f - yaw);
            if (entity.func_70631_g_()) {
                time *= 3.0f;
            }
            if (distance > 1.0f) {
                distance = 1.0f;
            }
        }
        int fade = 0;
        if (entity.field_70737_aN > 0) {
            fade = 10;
        }
        boolean invisible = !this.func_225622_a_((LivingEntity)entity, false);
        boolean allyInvisible = invisible && !entity.func_98034_c((PlayerEntity)Minecraft.func_71410_x().field_71439_g);
        this.getMainModel().generateAnimationFrames(entity, time, distance, loop, lookYaw, lookPitch, 1.0f, brightness);
        this.renderModel(entity, matrixStack, renderTypeBuffer, null, time, distance, loop, lookYaw, lookPitch, 1.0f, brightness, fade, invisible, allyInvisible);
        for (LayerRenderer layer : this.field_177097_h) {
            LayerCreatureBase layerCreatureBase;
            if (!(layer instanceof LayerCreatureBase) || !(layerCreatureBase = (LayerCreatureBase)layer).canRenderLayer(entity, scale)) continue;
            this.renderModel(entity, matrixStack, renderTypeBuffer, layerCreatureBase, time, distance, loop, lookYaw, lookPitch, scale, brightness, fade, invisible, allyInvisible);
        }
        this.getMainModel().clearAnimationFrames();
        matrixStack.func_227865_b_();
    }

    protected void renderModel(BaseCreatureEntity entity, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, LayerCreatureBase layer, float time, float distance, float loop, float lookY, float lookX, float scale, int brightness, int fade, boolean invisible, boolean allyInvisible) {
        ResourceLocation texture = this.getEntityTexture(entity, layer);
        RenderType rendertype = allyInvisible ? RenderType.func_228644_e_((ResourceLocation)texture) : (invisible ? RenderType.func_228654_j_((ResourceLocation)texture) : CustomRenderStates.getObjRenderType(texture));
        this.getMainModel().render(entity, matrixStack, renderTypeBuffer.getBuffer(rendertype), layer, time, distance, loop, lookY, lookX, 1.0f, brightness, fade);
    }

    public CreatureModel getMainModel() {
        return (CreatureModel)this.field_77045_g;
    }

    public ResourceLocation getEntityTexture(BaseCreatureEntity entity, LayerCreatureBase layer) {
        if (layer == null) {
            return this.getEntityTexture(entity);
        }
        ResourceLocation layerTexture = layer.getLayerTexture(entity);
        return layerTexture != null ? layerTexture : this.getEntityTexture(entity);
    }

    public ResourceLocation getEntityTexture(BaseCreatureEntity entity) {
        return entity.getTexture();
    }

    protected boolean canRenderName(BaseCreatureEntity entity) {
        if (!Minecraft.func_71382_s()) {
            return false;
        }
        if (entity.func_98034_c((PlayerEntity)Minecraft.func_71410_x().field_71439_g)) {
            return false;
        }
        if (entity.func_184179_bs() != null) {
            return false;
        }
        if (entity.func_94059_bO()) {
            if (entity.isTamed()) {
                return entity == this.field_76990_c.field_147941_i;
            }
            return true;
        }
        return entity.func_145818_k_() && entity == this.field_76990_c.field_147941_i;
    }

    public float interpolateRotation(float par1, float par2, float par3) {
        float f3;
        for (f3 = par2 - par1; f3 < -180.0f; f3 += 360.0f) {
        }
        while (f3 >= 180.0f) {
            f3 -= 360.0f;
        }
        return par1 + par3 * f3;
    }
}

