/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.obj;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.obj.IndexedModel;
import com.lycanitesmobs.client.obj.Mesh;
import com.lycanitesmobs.client.obj.OBJLoader;
import com.lycanitesmobs.client.obj.ObjPart;
import com.lycanitesmobs.client.obj.Vertex;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Matrix3f;
import net.minecraft.client.renderer.Matrix4f;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import net.minecraft.util.math.Vec3d;
import org.apache.commons.io.output.ByteArrayOutputStream;

public class ObjModel {
    public String filename;
    public List<ObjPart> objParts = new ArrayList<ObjPart>();

    public ObjModel(ResourceLocation resourceLocation) {
        this.filename = resourceLocation.func_110623_a();
        String path = resourceLocation.toString();
        try {
            InputStream inputStream = Minecraft.func_71410_x().func_195551_G().func_199002_a(resourceLocation).func_199027_b();
            String content = new String(this.read(inputStream), "UTF-8");
            String startPath = path.substring(0, path.lastIndexOf(47) + 1);
            HashMap<ObjPart, IndexedModel> map = new OBJLoader().loadModel(startPath, content);
            this.objParts.clear();
            Set<ObjPart> keys = map.keySet();
            for (ObjPart objPart : keys) {
                Mesh mesh;
                objPart.mesh = mesh = new Mesh();
                this.objParts.add(objPart);
                map.get(objPart).toMesh(mesh);
            }
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "Unable to load model: " + resourceLocation);
            e.toString();
        }
    }

    protected byte[] read(InputStream resource) throws IOException {
        int i;
        byte[] buffer = new byte[65565];
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        while ((i = resource.read(buffer, 0, buffer.length)) != -1) {
            out.write(buffer, 0, i);
        }
        out.flush();
        out.close();
        return out.toByteArray();
    }

    public Vector3f getNormal(Vector3f p1, Vector3f p2, Vector3f p3) {
        Vector3f output = new Vector3f();
        Vector3f calU = new Vector3f(p2.func_195899_a() - p1.func_195899_a(), p2.func_195900_b() - p1.func_195900_b(), p2.func_195902_c() - p1.func_195902_c());
        Vector3f calV = new Vector3f(p3.func_195899_a() - p1.func_195899_a(), p3.func_195900_b() - p1.func_195900_b(), p3.func_195902_c() - p1.func_195902_c());
        output.func_195905_a(calU.func_195900_b() * calV.func_195902_c() - calU.func_195902_c() * calV.func_195900_b(), calU.func_195902_c() * calV.func_195899_a() - calU.func_195899_a() * calV.func_195902_c(), calU.func_195899_a() * calV.func_195900_b() - calU.func_195900_b() * calV.func_195899_a());
        output.func_229194_d_();
        return output;
    }

    public void renderAll(IVertexBuilder vertexBuilder, Matrix3f matrix3f, Matrix4f matrix4f, int brightness, int fade, Vector4f color, Vec2f textureOffset) {
        Collections.sort(this.objParts, (a, b) -> {
            Vec3d v = Minecraft.func_71410_x().func_175606_aa().func_174791_d();
            double aDist = v.func_72438_d(new Vec3d((double)a.center.func_195899_a(), (double)a.center.func_195900_b(), (double)a.center.func_195902_c()));
            double bDist = v.func_72438_d(new Vec3d((double)b.center.func_195899_a(), (double)b.center.func_195900_b(), (double)b.center.func_195902_c()));
            return Double.compare(aDist, bDist);
        });
        for (ObjPart objPart : this.objParts) {
            this.renderPart(vertexBuilder, matrix3f, matrix4f, brightness, fade, objPart, color, textureOffset);
        }
    }

    public void renderPartGroup(IVertexBuilder vertexBuilder, Matrix3f matrix3f, Matrix4f matrix4f, int brightness, int fade, Vector4f color, Vec2f textureOffset, String group) {
        for (ObjPart objPart : this.objParts) {
            if (!objPart.getName().equals(group)) continue;
            this.renderPart(vertexBuilder, matrix3f, matrix4f, brightness, fade, objPart, color, textureOffset);
        }
    }

    public void renderPart(IVertexBuilder vertexBuilder, Matrix3f matrix3f, Matrix4f matrix4f, int brightness, int fade, ObjPart objPart, Vector4f color, Vec2f textureOffset) {
        if (objPart.mesh == null) {
            return;
        }
        int[] indices = objPart.mesh.indices;
        Vertex[] vertices = objPart.mesh.vertices;
        if (objPart.mesh.normals == null) {
            objPart.mesh.normals = new Vector3f[indices.length];
        }
        if (vertexBuilder instanceof BufferBuilder) {
            for (int i = 0; i < indices.length; i += 3) {
                Vector3f normal = objPart.mesh.normals[i];
                if (normal == null) {
                    objPart.mesh.normals[i] = normal = this.getNormal(vertices[indices[i]].getPos(), vertices[indices[i + 1]].getPos(), vertices[indices[i + 2]].getPos());
                }
                for (int iv = 0; iv < 3; ++iv) {
                    Vertex v = objPart.mesh.vertices[indices[i + iv]];
                    vertexBuilder.func_227888_a_(matrix4f, v.getPos().func_195899_a(), v.getPos().func_195900_b(), v.getPos().func_195902_c()).func_227885_a_(color.func_195910_a(), color.func_195913_b(), color.func_195914_c(), color.func_195915_d()).func_225583_a_(v.getTexCoords().field_189982_i + textureOffset.field_189982_i * 0.01f, 1.0f - (v.getTexCoords().field_189983_j + textureOffset.field_189983_j * 0.01f)).func_225585_a_(0, 10 - fade).func_227886_a_(brightness).func_227887_a_(matrix3f, normal.func_195899_a(), normal.func_195900_b(), normal.func_195902_c()).func_181675_d();
                }
            }
            return;
        }
    }
}

