/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.obj;

import com.lycanitesmobs.client.obj.Mesh;
import com.lycanitesmobs.client.obj.OBJLoader;
import com.lycanitesmobs.client.obj.Vertex;
import java.util.ArrayList;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.util.math.Vec2f;

public class IndexedModel {
    private ArrayList<Vector3f> vertices = new ArrayList();
    private ArrayList<Vec2f> texCoords = new ArrayList();
    private ArrayList<Vector3f> normals = new ArrayList();
    private ArrayList<Vector3f> tangents = new ArrayList();
    private ArrayList<Integer> indices = new ArrayList();
    private ArrayList<OBJLoader.OBJIndex> objindices = new ArrayList();

    public ArrayList<Vector3f> getPositions() {
        return this.vertices;
    }

    public ArrayList<Vec2f> getTexCoords() {
        return this.texCoords;
    }

    public ArrayList<Vector3f> getNormals() {
        return this.normals;
    }

    public ArrayList<Integer> getIndices() {
        return this.indices;
    }

    public ArrayList<Vector3f> getTangents() {
        return this.tangents;
    }

    public void toMesh(Mesh mesh) {
        ArrayList<Vertex> verticesList = new ArrayList<Vertex>();
        int n = Math.min(this.vertices.size(), Math.min(this.texCoords.size(), this.normals.size()));
        for (int i = 0; i < n; ++i) {
            Vertex vertex = new Vertex(this.vertices.get(i), this.texCoords.get(i), this.normals.get(i), new Vector3f());
            verticesList.add(vertex);
        }
        Integer[] indicesArray = this.indices.toArray(new Integer[0]);
        Vertex[] verticesArray = verticesList.toArray(new Vertex[0]);
        int[] indicesArrayInt = new int[indicesArray.length];
        for (int i = 0; i < indicesArray.length; ++i) {
            indicesArrayInt[i] = indicesArray[i];
        }
        mesh.vertices = verticesArray;
        mesh.indices = indicesArrayInt;
    }

    public void computeNormals() {
        int i;
        for (i = 0; i < this.indices.size(); i += 3) {
            int x = this.indices.get(i);
            int y = this.indices.get(i + 1);
            int z = this.indices.get(i + 2);
            Vector3f v = this.vertices.get(y).func_229195_e_();
            v.func_195897_a(this.vertices.get(x));
            Vector3f l0 = v;
            v = this.vertices.get(z).func_229195_e_();
            v.func_195897_a(this.vertices.get(x));
            Vector3f l1 = v;
            v = l0.func_229195_e_();
            v.func_195896_c(l1);
            Vector3f normal = v;
            v = this.normals.get(x).func_229195_e_();
            v.func_229189_a_(normal);
            this.normals.set(x, v);
            v = this.normals.get(y).func_229195_e_();
            v.func_229189_a_(normal);
            this.normals.set(y, v);
            v = this.normals.get(z).func_229195_e_();
            v.func_229189_a_(normal);
            this.normals.set(z, v);
        }
        for (i = 0; i < this.normals.size(); ++i) {
            this.normals.get(i).func_229194_d_();
        }
    }

    public Vector3f getFaceNormal(Vector3f p1, Vector3f p2, Vector3f p3) {
        Vector3f output = new Vector3f();
        Vector3f calU = new Vector3f(p2.func_195899_a() - p1.func_195899_a(), p2.func_195900_b() - p1.func_195900_b(), p2.func_195902_c() - p1.func_195902_c());
        Vector3f calV = new Vector3f(p3.func_195899_a() - p1.func_195899_a(), p3.func_195900_b() - p1.func_195900_b(), p3.func_195902_c() - p1.func_195902_c());
        output.func_195905_a(calU.func_195900_b() * calV.func_195902_c() - calU.func_195902_c() * calV.func_195900_b(), calU.func_195902_c() * calV.func_195899_a() - calU.func_195899_a() * calV.func_195902_c(), calU.func_195899_a() * calV.func_195900_b() - calU.func_195900_b() * calV.func_195899_a());
        output.func_229194_d_();
        return output;
    }

    public void computeTangents() {
        int i;
        this.tangents.clear();
        for (i = 0; i < this.vertices.size(); ++i) {
            this.tangents.add(new Vector3f());
        }
        for (i = 0; i < this.indices.size(); i += 3) {
            int i0 = this.indices.get(i);
            int i1 = this.indices.get(i + 1);
            int i2 = this.indices.get(i + 2);
            Vector3f v = this.vertices.get(i1).func_229195_e_();
            v.func_195897_a(this.vertices.get(i0));
            Vector3f edge1 = v;
            v = this.vertices.get(i2).func_229195_e_();
            v.func_195897_a(this.vertices.get(i0));
            Vector3f edge2 = v;
            double deltaU1 = this.texCoords.get((int)i1).field_189982_i - this.texCoords.get((int)i0).field_189982_i;
            double deltaU2 = this.texCoords.get((int)i2).field_189982_i - this.texCoords.get((int)i0).field_189982_i;
            double deltaV1 = this.texCoords.get((int)i1).field_189983_j - this.texCoords.get((int)i0).field_189983_j;
            double deltaV2 = this.texCoords.get((int)i2).field_189983_j - this.texCoords.get((int)i0).field_189983_j;
            double dividend = deltaU1 * deltaV2 - deltaU2 * deltaV1;
            double f = dividend == 0.0 ? 0.0 : 1.0 / dividend;
            Vector3f tangent = new Vector3f((float)(f * (deltaV2 * (double)edge1.func_195899_a() - deltaV1 * (double)edge2.func_195899_a())), (float)(f * (deltaV2 * (double)edge1.func_195900_b() - deltaV1 * (double)edge2.func_195900_b())), (float)(f * (deltaV2 * (double)edge1.func_195902_c() - deltaV1 * (double)edge2.func_195902_c())));
            v = this.tangents.get(i0).func_229195_e_();
            v.func_229189_a_(tangent);
            this.tangents.set(i0, v);
            v = this.tangents.get(i1).func_229195_e_();
            v.func_229189_a_(tangent);
            this.tangents.set(i1, v);
            v = this.tangents.get(i2).func_229195_e_();
            v.func_229189_a_(tangent);
            this.tangents.set(i2, v);
        }
        for (i = 0; i < this.tangents.size(); ++i) {
            this.tangents.get(i).func_229194_d_();
        }
    }

    public ArrayList<OBJLoader.OBJIndex> getObjIndices() {
        return this.objindices;
    }

    public Vector3f computeCenter() {
        float x = 0.0f;
        float y = 0.0f;
        float z = 0.0f;
        for (Vector3f position : this.vertices) {
            x += position.func_195899_a();
            y += position.func_195900_b();
            z += position.func_195902_c();
        }
        return new Vector3f(x /= (float)this.vertices.size(), y /= (float)this.vertices.size(), z /= (float)this.vertices.size());
    }
}

