/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.template.ModelTemplateElemental;
import com.lycanitesmobs.client.renderer.CreatureRenderer;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureEffect;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelZephyr
extends ModelTemplateElemental {
    public ModelZephyr() {
        this(1.0f);
    }

    public ModelZephyr(float shadowSize) {
        this.initModel("zephyr", LycanitesMobs.modInfo, "entity/zephyr");
        this.trophyScale = 1.2f;
        this.trophyOffset = new float[]{0.0f, -0.2f, 0.2f};
    }

    @Override
    public void addCustomLayers(CreatureRenderer renderer) {
        super.addCustomLayers(renderer);
        renderer.func_177094_a(new LayerCreatureEffect(renderer, "glow", true, LayerCreatureEffect.BLEND.ADD.id, true));
        renderer.func_177094_a(new LayerCreatureEffect(renderer, "pulse01", true, LayerCreatureEffect.BLEND.ADD.id, true));
        renderer.func_177094_a(new LayerCreatureEffect(renderer, "pulse02", true, LayerCreatureEffect.BLEND.ADD.id, true));
        renderer.func_177094_a(new LayerCreatureEffect(renderer, "pulse03", true, LayerCreatureEffect.BLEND.ADD.id, true));
    }

    @Override
    public void animatePart(String partName, LivingEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        if ("effectouter".equals(partName) || "effectinner".equals(partName)) {
            this.rotate(-15.0f, 0.0f, 0.0f);
        }
        if (partName.equals("armeffectleft") || partName.equals("armeffectright")) {
            float angleX = 35.0f;
            float angleY = -45.0f;
            float angleZ = 140.0f;
            if (partName.equals("armeffectright")) {
                angleX = -angleX;
            }
            this.angle(loop * 50.0f, angleX, angleY, angleZ);
        }
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
    }

    @Override
    public Vector4f getPartColor(String partName, Entity entity, LayerCreatureBase layer, boolean trophy, float loop) {
        float alpha;
        if (layer == null) {
            return super.getPartColor(partName, entity, layer, trophy, loop);
        }
        float alphaTime = 15.0f;
        if ("pulse02".equals(layer.name)) {
            alphaTime = 20.0f;
        }
        if ("pulse03".equals(layer.name)) {
            alphaTime = 25.0f;
        }
        if ((alpha = loop % alphaTime / alphaTime * 2.0f) > 1.0f) {
            alpha = -(alpha - 1.0f);
        }
        return new Vector4f(1.0f, 1.0f, 1.0f, alpha);
    }
}

