/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.template.ModelTemplateInsect;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelTriteVoid
extends ModelTemplateInsect {
    public ModelTriteVoid() {
        this(1.0f);
    }

    public ModelTriteVoid(float shadowSize) {
        this.initModel("trite_void", LycanitesMobs.modInfo, "entity/trite_void");
        this.mouthScaleX = 1.0;
        this.mouthScaleY = 0.1f;
        this.trophyScale = 1.0f;
    }

    @Override
    public void animatePart(String partName, LivingEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        if (partName.equals("body")) {
            float bob = MathHelper.func_76134_b((float)(time * 0.6662f + (float)Math.PI)) * 0.3f * distance;
            if (bob < 0.0f) {
                bob += -bob * 2.0f;
            }
            this.translate(0.0f, bob, 0.0f);
        }
        if (partName.contains("tentacle")) {
            float loopOffset = 0.0f;
            if (partName.contains("front")) {
                loopOffset += 10.0f;
            } else if (partName.contains("back")) {
                loopOffset += 30.0f;
            }
            if (partName.contains("left")) {
                this.rotate((float)Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f), (float)Math.toDegrees(MathHelper.func_76126_a((float)((loop + loopOffset / 2.0f) * 0.2f)) * 0.25f) - 10.0f, (float)(-Math.toDegrees(MathHelper.func_76134_b((float)((loop + loopOffset / 2.0f) * 0.09f)) * 0.1f)));
            } else {
                this.rotate((float)Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f), (float)(-Math.toDegrees(MathHelper.func_76126_a((float)((loop + loopOffset / 2.0f) * 0.2f)) * 0.25f)) - 10.0f, (float)(-Math.toDegrees(MathHelper.func_76134_b((float)((loop + loopOffset / 2.0f) * 0.09f)) * 0.1f)));
            }
        }
    }
}

