/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.template.ModelTemplateElemental;
import com.lycanitesmobs.client.renderer.CreatureRenderer;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureEffect;
import com.lycanitesmobs.core.entity.creature.EntitySpectre;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelSpectre
extends ModelTemplateElemental {
    public ModelSpectre() {
        this(1.0f);
    }

    public ModelSpectre(float shadowSize) {
        this.initModel("spectre", LycanitesMobs.modInfo, "entity/spectre");
        this.trophyScale = 1.2f;
        this.trophyOffset = new float[]{0.0f, 0.0f, -0.4f};
        this.trophyMouthOffset = new float[]{0.0f, -0.25f, 0.0f};
    }

    @Override
    public void addCustomLayers(CreatureRenderer renderer) {
        super.addCustomLayers(renderer);
        renderer.func_177094_a(new LayerCreatureEffect(renderer, "glow", true, LayerCreatureEffect.BLEND.ADD.id, true));
        renderer.func_177094_a(new LayerCreatureEffect(renderer, "", false, LayerCreatureEffect.BLEND.SUB.id, true));
    }

    @Override
    public boolean canRenderPart(String partName, Entity entity, LayerCreatureBase layer, boolean trophy) {
        if ("effect01".equals(partName)) {
            return layer != null && "".equals(layer.name);
        }
        if ("effect02".equals(partName) || "effect03".equals(partName)) {
            if (entity instanceof EntitySpectre && layer != null && "".equals(layer.name)) {
                return ((EntitySpectre)entity).canPull();
            }
            return false;
        }
        return layer == null || "glow".equals(layer.name);
    }

    @Override
    public void animatePart(String partName, LivingEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        boolean isPulling = false;
        if (entity instanceof EntitySpectre) {
            isPulling = ((EntitySpectre)entity).canPull();
        }
        float loopOffset = 0.0f;
        if (partName.contains("upper")) {
            loopOffset += 10.0f;
        } else if (partName.contains("middle")) {
            loopOffset += 20.0f;
        } else if (partName.contains("lower")) {
            loopOffset += 30.0f;
        }
        if ("effect01".equals(partName)) {
            this.rotate(25.0f, 0.0f, -loop * 10.0f);
            float effectScale = 1.0f + (float)Math.cos(loop / 10.0f) * 0.1f;
            if (isPulling) {
                effectScale *= 2.0f;
            }
            this.scale(effectScale, effectScale, effectScale);
        } else if ("effect02".equals(partName)) {
            this.rotate(0.0f, 0.0f, -loop * 10.0f);
            float effectScale = 2.0f + (float)Math.cos(loop / 10.0f);
            this.scale(effectScale, effectScale, effectScale);
        } else if ("effect03".equals(partName)) {
            this.rotate(0.0f, 0.0f, loop * 10.0f);
            float effectScale = 2.0f + (float)Math.cos(loop / 10.0f);
            this.scale(effectScale, effectScale, effectScale);
        } else if (partName.contains("armleft")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.034f)) * 0.05f), (float)Math.toDegrees(MathHelper.func_76126_a((float)((loop + loopOffset / 2.0f) * 0.1f)) * 0.25f) - 10.0f, (float)(-Math.toDegrees(MathHelper.func_76134_b((float)((loop + loopOffset / 2.0f) * 0.09f)) * 0.1f)));
        } else if (partName.contains("armright")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.034f)) * 0.05f), (float)(-Math.toDegrees(MathHelper.func_76126_a((float)((loop + loopOffset / 2.0f) * 0.1f)) * 0.25f)) + 10.0f, (float)Math.toDegrees(MathHelper.func_76134_b((float)((loop + loopOffset / 2.0f) * 0.09f)) * 0.1f));
        } else if (partName.contains("mouthleft")) {
            this.rotate((float)Math.cos(loop / 10.0f) * 4.0f, (float)Math.cos(loop / 10.0f) * 4.0f, 0.0f);
        } else if (partName.contains("mouthright")) {
            this.rotate((float)Math.cos(loop / 10.0f) * 4.0f, -((float)Math.cos(loop / 10.0f)) * 4.0f, 0.0f);
        } else if (partName.contains("mawleft")) {
            this.rotate(0.0f, (float)Math.cos(loop / 10.0f) * 10.0f + (float)(isPulling ? 90 : 0), 0.0f);
        } else if (partName.contains("mawright")) {
            this.rotate(0.0f, -((float)Math.cos(loop / 10.0f)) * 10.0f - (float)(isPulling ? 90 : 0), 0.0f);
        }
    }
}

