/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.template.ModelTemplateInsect;
import com.lycanitesmobs.core.entity.creature.EntityDarkling;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelDarkling
extends ModelTemplateInsect {
    public ModelDarkling() {
        this(1.0f);
    }

    public ModelDarkling(float shadowSize) {
        this.initModel("darkling", LycanitesMobs.modInfo, "entity/darkling");
        this.lookHeadScaleX = 0.0f;
        this.lookHeadScaleY = 0.0f;
        this.mouthScaleX = 1.0;
        this.mouthScaleY = 0.1f;
        this.trophyScale = 1.0f;
    }

    @Override
    public void animatePart(String partName, LivingEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        if (partName.equals("body") && entity instanceof EntityDarkling) {
            if (((EntityDarkling)entity).hasLatchTarget()) {
                this.rotate(-90.0f, 0.0f, 0.0f);
            } else {
                float bob = MathHelper.func_76134_b((float)(time * 0.6662f + (float)Math.PI)) * 0.3f * distance;
                if (bob < 0.0f) {
                    bob += -bob * 2.0f;
                }
                this.translate(0.0f, bob, 0.0f);
            }
        }
    }
}

