/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.template.ModelTemplateElemental;
import com.lycanitesmobs.client.renderer.CreatureRenderer;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureEffect;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelArgus
extends ModelTemplateElemental {
    public ModelArgus() {
        this(1.0f);
    }

    public ModelArgus(float shadowSize) {
        this.initModel("argus", LycanitesMobs.modInfo, "entity/argus");
        this.trophyScale = 1.2f;
        this.trophyOffset = new float[]{0.0f, 0.0f, -0.4f};
        this.trophyMouthOffset = new float[]{0.0f, -0.25f, 0.0f};
    }

    @Override
    public void addCustomLayers(CreatureRenderer renderer) {
        super.addCustomLayers(renderer);
        renderer.func_177094_a(new LayerCreatureEffect(renderer, "flash", true, LayerCreatureEffect.BLEND.ADD.id, true));
    }

    @Override
    public boolean canRenderPart(String partName, Entity entity, LayerCreatureBase layer, boolean trophy) {
        if (layer instanceof LayerCreatureEffect && entity instanceof BaseCreatureEntity) {
            return ((BaseCreatureEntity)entity).isAttackOnCooldown();
        }
        return true;
    }

    @Override
    public void animatePart(String partName, LivingEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        if (partName.contains("arm")) {
            float rotX = (float)Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f) * 4.0f;
            float rotY = (float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.1f);
            if ("arm01".equals(partName) || "arm02".equals(partName) || "arm03".equals(partName)) {
                this.rotate(rotX, rotY, loop * 8.0f);
                this.translate(MathHelper.func_76134_b((float)loop) * 0.05f - 0.05f, MathHelper.func_76134_b((float)loop) * 0.05f - 0.05f, 0.0f);
            } else if ("arm04".equals(partName) || "arm05".equals(partName) || "arm06".equals(partName)) {
                this.rotate(rotX, rotY, -loop * 8.0f);
                this.translate(MathHelper.func_76134_b((float)(-loop)) * 0.05f - 0.05f, MathHelper.func_76134_b((float)(-loop)) * 0.05f - 0.05f, 0.0f);
            }
        }
        if (partName.contains("tail")) {
            float tailSwipeX = 32.0f;
            float tailSwipeY = 32.0f;
            this.rotate(MathHelper.func_76134_b((float)(loop * 0.1f)) * tailSwipeX - tailSwipeX * 90.0f, MathHelper.func_76126_a((float)(loop * 0.2f)) * tailSwipeY - tailSwipeY * 90.0f, 0.0f);
        }
        if (partName.equals("mouth")) {
            this.rotate(45.0f * this.getAttackProgress(), 0.0f, 0.0f);
        }
    }
}

