/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model.creature;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.CreatureObjModel;
import com.lycanitesmobs.client.renderer.CreatureRenderer;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureEffect;
import com.lycanitesmobs.core.entity.creature.EntityAmalgalich;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ModelAmalgalich
extends CreatureObjModel {
    public ModelAmalgalich() {
        this(1.0f);
    }

    public ModelAmalgalich(float shadowSize) {
        this.initModel("amalgalich", LycanitesMobs.modInfo, "entity/amalgalich");
        this.lookHeadScaleX = 0.0f;
        this.lookHeadScaleY = 0.75f;
        this.lookNeckScaleX = 0.25f;
        this.lookNeckScaleY = 0.25f;
        this.trophyScale = 0.8f;
        this.trophyOffset = new float[]{0.0f, 0.0f, -0.4f};
    }

    @Override
    public void addCustomLayers(CreatureRenderer renderer) {
        super.addCustomLayers(renderer);
        renderer.func_177094_a(new LayerCreatureEffect(renderer, "fire", true, LayerCreatureEffect.BLEND.ADD.id, true));
    }

    @Override
    public boolean canRenderPart(String partName, Entity entity, LayerCreatureBase layer, boolean trophy) {
        if (layer != null && entity instanceof EntityAmalgalich) {
            return ((EntityAmalgalich)entity).getConsumptionAnimation() > 0.0f;
        }
        return super.canRenderPart(partName, entity, layer, trophy);
    }

    @Override
    public void animatePart(String partName, LivingEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        super.animatePart(partName, entity, time, distance, loop, lookY, lookX, scale);
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float angleX = 0.0f;
        float angleY = 0.0f;
        float angleZ = 0.0f;
        float rotation = 0.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (entity instanceof EntityAmalgalich && ((EntityAmalgalich)entity).getConsumptionAnimation() > 0.0f) {
            float consumptionScale = ((EntityAmalgalich)entity).getConsumptionAnimation();
            if (consumptionScale == 1.0f) {
                loop *= 8.0f * consumptionScale;
            }
            if (partName.equals("body")) {
                posY -= 8.0f * consumptionScale;
            }
            if (partName.equals("legleftfront01") || partName.equals("legleftback01")) {
                rotZ += 65.0f * consumptionScale;
            }
            if (partName.equals("legrightfront01") || partName.equals("legrightback01")) {
                rotZ -= 65.0f * consumptionScale;
            }
            if (partName.equals("legleftfront03") || partName.equals("legleftback03")) {
                rotZ -= 25.0f * consumptionScale;
            }
            if (partName.equals("legrightfront03") || partName.equals("legrightback03")) {
                rotZ += 25.0f * consumptionScale;
            }
            if (partName.equals("neck")) {
                rotX += 20.0f * consumptionScale;
            }
            if (partName.equals("head")) {
                rotX -= 20.0f * consumptionScale;
            }
            if (partName.equals("mouth")) {
                rotX += 40.0f * consumptionScale;
            }
            if (partName.equals("armleft01")) {
                rotZ += 35.0f * consumptionScale;
            }
            if (partName.equals("armright01")) {
                rotZ -= 35.0f * consumptionScale;
            }
        }
        if (partName.equals("mouth")) {
            this.rotate((float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.1f)) * 0.1f - 0.1f)), 0.0f, 0.0f);
        }
        if (partName.equals("neck")) {
            this.rotate((float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f - 0.05f)), 0.0f, 0.0f);
        }
        if (partName.contains("armleft")) {
            rotZ = (float)((double)rotZ - Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f + 0.05f));
            rotX = (float)((double)rotX - Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f));
        }
        if (partName.contains("armright")) {
            rotZ = (float)((double)rotZ + Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f + 0.05f));
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76126_a((float)(loop * 0.067f)) * 0.05f));
        }
        if (partName.contains("tail")) {
            rotX = (float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.1f)) * 0.05f - 0.05f));
            rotY = (float)(-Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.09f)) * 0.05f - 0.05f));
        } else if (partName.equals("fingerleft01") || partName.equals("fingerright01")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76134_b((float)(loop * 0.2f)) * 0.2f), 0.0f, 0.0f);
        } else if (partName.equals("fingerleft02") || partName.equals("fingerright02")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76134_b((float)((loop + 20.0f) * 0.2f)) * 0.2f), 0.0f, 0.0f);
        } else if (partName.equals("fingerleft03") || partName.equals("fingerright03")) {
            this.rotate((float)Math.toDegrees(MathHelper.func_76134_b((float)((loop + 40.0f) * 0.2f)) * 0.2f), 0.0f, 0.0f);
        }
        float walkSwing = 0.1f;
        if (partName.contains("armleft")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing)) * 1.0f * distance * 0.5f));
            rotZ = (float)((double)rotZ - Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing)) * 0.5f * distance * 0.5f));
        }
        if (partName.contains("armright")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing + (float)Math.PI)) * 1.0f * distance * 0.5f));
            rotZ = (float)((double)rotZ + Math.toDegrees(MathHelper.func_76134_b((float)(time * walkSwing + (float)Math.PI)) * 0.5f * distance * 0.5f));
        }
        if (partName.contains("legrightfront") || partName.contains("legleftback")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f + (float)Math.PI)) * walkSwing * distance));
        }
        if (partName.contains("legleftfront") || partName.contains("legrightback")) {
            rotX = (float)((double)rotX + Math.toDegrees(MathHelper.func_76134_b((float)(time * 0.6662f)) * walkSwing * distance));
        }
        this.angle(rotation, angleX, angleY, angleZ);
        this.rotate(rotX, rotY, rotZ);
        this.translate(posX, posY, posZ);
    }
}

