/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.AnimationPart;
import com.lycanitesmobs.client.model.Animator;
import com.lycanitesmobs.client.model.ModelAnimation;
import com.lycanitesmobs.client.model.ModelObjAnimationFrame;
import com.lycanitesmobs.client.model.ModelObjState;
import com.lycanitesmobs.client.model.ProjectileModel;
import com.lycanitesmobs.client.obj.ObjModel;
import com.lycanitesmobs.client.obj.ObjPart;
import com.lycanitesmobs.client.renderer.ProjectileModelRenderer;
import com.lycanitesmobs.client.renderer.layer.LayerProjectileBase;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileInfo;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;

@OnlyIn(value=Dist.CLIENT)
public class ProjectileObjModel
extends ProjectileModel {
    public static float modelXRotOffset = 180.0f;
    public static float modelYPosOffset = -1.5f;
    public ObjModel wavefrontObject;
    public List<ObjPart> objParts;
    public Map<String, AnimationPart> animationParts = new HashMap<String, AnimationPart>();
    protected Animator animator;
    protected AnimationPart currentAnimationPart;
    protected ModelAnimation animation;
    protected Map<Entity, ModelObjState> modelStates = new HashMap<Entity, ModelObjState>();
    protected ModelObjState currentModelState;

    public ProjectileObjModel() {
        this(1.0f);
    }

    public ProjectileObjModel(float shadowSize) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProjectileObjModel initModel(String name, ModInfo modInfo, String path) {
        ProjectileInfo projectileInfo = ProjectileManager.getInstance().getProjectile(name);
        if (projectileInfo != null && !projectileInfo.enabled) {
            return this;
        }
        this.wavefrontObject = new ObjModel(new ResourceLocation(modInfo.modid, "models/" + path + ".obj"));
        this.objParts = this.wavefrontObject.objParts;
        if (this.objParts.isEmpty()) {
            LycanitesMobs.logWarning("", "Unable to load any parts for the " + name + " model!");
        }
        this.animator = new Animator(this);
        ResourceLocation modelPartsLocation = new ResourceLocation(modInfo.modid, "models/" + path + "_parts.json");
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            InputStream in = Minecraft.func_71410_x().func_195551_G().func_199002_a(modelPartsLocation).func_199027_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                JsonArray jsonArray = (JsonArray)JSONUtils.func_188173_a((Gson)gson, (Reader)reader, JsonArray.class, (boolean)false);
                Iterator jsonIterator = jsonArray.iterator();
                while (jsonIterator.hasNext()) {
                    JsonObject partJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                    AnimationPart animationPart = new AnimationPart();
                    animationPart.loadFromJson(partJson);
                    this.addAnimationPart(animationPart);
                }
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "There was a problem loading animation parts for " + name + ":");
            e.toString();
        }
        for (AnimationPart part : this.animationParts.values()) {
            part.addChildren(this.animationParts.values().toArray(new AnimationPart[this.animationParts.size()]));
        }
        ResourceLocation animationLocation = new ResourceLocation(modInfo.modid, "models/" + path + "_animation.json");
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            InputStream in = Minecraft.func_71410_x().func_195551_G().func_199002_a(animationLocation).func_199027_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                JsonObject json = (JsonObject)JSONUtils.func_188173_a((Gson)gson, (Reader)reader, JsonObject.class, (boolean)false);
                this.animation = new ModelAnimation();
                this.animation.loadFromJson(json);
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("Models", "Unable to load animation json for " + name + ".");
        }
        return this;
    }

    public void addAnimationPart(AnimationPart animationPart) {
        if (this.animationParts.containsKey(animationPart.name)) {
            LycanitesMobs.logWarning("", "Tried to add an animation part that already exists: " + animationPart.name + ".");
            return;
        }
        if (animationPart.parentName != null && animationPart.parentName.equals(animationPart.name)) {
            animationPart.parentName = null;
        }
        this.animationParts.put(animationPart.name, animationPart);
    }

    @Override
    public void addCustomLayers(ProjectileModelRenderer renderer) {
        super.addCustomLayers(renderer);
        if (this.animation != null) {
            this.animation.addProjectileLayers(renderer);
        }
    }

    @Override
    public void generateAnimationFrames(BaseProjectileEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale, int brightness) {
        for (ObjPart part : this.objParts) {
            String partName = part.getName().toLowerCase();
            this.currentAnimationPart = this.animationParts.get(partName);
            if (this.currentAnimationPart == null) continue;
            this.animatePart(partName, entity, time, distance, loop, -lookY, lookX, scale);
        }
    }

    public void animatePart(String partName, BaseProjectileEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        this.rotate(rotX, rotY, rotZ);
    }

    @Override
    public void clearAnimationFrames() {
        for (AnimationPart animationPart : this.animationParts.values()) {
            animationPart.animationFrames.clear();
        }
    }

    @Override
    public void render(BaseProjectileEntity entity, MatrixStack matrixStack, IVertexBuilder vertexBuilder, LayerProjectileBase layer, float time, float distance, float loop, float lookY, float lookX, float scale, int brightness) {
        this.matrixStack = matrixStack;
        if (scale < 0.0f) {
            scale = -scale;
        } else if (entity != null) {
            scale *= 4.0f;
            scale *= entity.getProjectileScale();
        }
        this.currentModelState = this.getModelState(entity);
        for (ObjPart part : this.objParts) {
            String partName = part.getName().toLowerCase();
            if (!this.canRenderPart(partName, entity, layer)) continue;
            this.currentAnimationPart = this.animationParts.get(partName);
            if (this.currentAnimationPart == null) continue;
            matrixStack.func_227860_a_();
            this.animator.doAngle(modelXRotOffset, 1.0f, 0.0f, 0.0f);
            this.animator.doTranslate(0.0f, modelYPosOffset, 0.0f);
            this.animator.doScale(scale, scale, scale);
            this.currentAnimationPart.applyAnimationFrames(this.animator);
            this.wavefrontObject.renderPart(vertexBuilder, matrixStack.func_227866_c_().func_227872_b_(), matrixStack.func_227866_c_().func_227870_a_(), this.getBrightness(partName, layer, entity, brightness), 0, part, this.getPartColor(partName, entity, layer, loop), this.getPartTextureOffset(partName, entity, layer, loop));
            matrixStack.func_227865_b_();
        }
    }

    @Override
    public boolean canRenderPart(String partName, BaseProjectileEntity entity, LayerProjectileBase layer) {
        if (partName == null) {
            return false;
        }
        if (!this.animationParts.containsKey(partName = partName.toLowerCase())) {
            return false;
        }
        return super.canRenderPart(partName, entity, layer);
    }

    public void shiftOrigin(String fromPartName, String toPartName) {
        AnimationPart fromPart = this.animationParts.get(fromPartName);
        AnimationPart toPart = this.animationParts.get(toPartName);
        float offsetX = toPart.centerX - fromPart.centerX;
        float offsetY = toPart.centerY - fromPart.centerY;
        float offsetZ = toPart.centerZ - fromPart.centerZ;
        this.translate(offsetX, offsetY, offsetZ);
    }

    public void shiftOriginBack(String fromPartName, String toPartName) {
        AnimationPart fromPart = this.animationParts.get(fromPartName);
        AnimationPart toPart = this.animationParts.get(toPartName);
        float offsetX = toPart.centerX - fromPart.centerX;
        float offsetY = toPart.centerY - fromPart.centerY;
        float offsetZ = toPart.centerZ - fromPart.centerZ;
        this.translate(-offsetX, -offsetY, -offsetZ);
    }

    public ModelObjState getModelState(BaseProjectileEntity entity) {
        if (entity == null) {
            return null;
        }
        if (this.modelStates.containsKey((Object)entity)) {
            if (!entity.func_70089_S()) {
                this.modelStates.remove((Object)entity);
                return null;
            }
            return this.modelStates.get((Object)entity);
        }
        ModelObjState modelState = new ModelObjState((Entity)entity);
        this.modelStates.put((Entity)entity, modelState);
        return modelState;
    }

    @Override
    public void angle(float rotation, float angleX, float angleY, float angleZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("angle", rotation, angleX, angleY, angleZ));
    }

    @Override
    public void rotate(float rotX, float rotY, float rotZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("rotate", 1.0f, rotX, rotY, rotZ));
    }

    @Override
    public void translate(float posX, float posY, float posZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("translate", 1.0f, posX, posY, posZ));
    }

    @Override
    public void scale(float scaleX, float scaleY, float scaleZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("scale", 1.0f, scaleX, scaleY, scaleZ));
    }
}

