/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model;

import com.lycanitesmobs.client.model.IAnimationModel;
import com.lycanitesmobs.client.renderer.ProjectileModelRenderer;
import com.lycanitesmobs.client.renderer.layer.LayerProjectileBase;
import com.lycanitesmobs.core.entity.BaseProjectileEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.util.math.Vec2f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ProjectileModel
extends EntityModel<BaseProjectileEntity>
implements IAnimationModel {
    public MatrixStack matrixStack;

    public ProjectileModel() {
        this(1.0f);
    }

    public ProjectileModel(float shadowSize) {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
    }

    public void func_225597_a_(BaseProjectileEntity entity, float time, float distance, float loop, float lookY, float lookX) {
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder iVertexBuilder, int i, int i1, float v, float v1, float v2, float v3) {
    }

    public void addCustomLayers(ProjectileModelRenderer renderer) {
    }

    public void generateAnimationFrames(BaseProjectileEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale, int brightness) {
    }

    public void clearAnimationFrames() {
    }

    public void render(BaseProjectileEntity entity, MatrixStack matrixStack, IVertexBuilder vertexBuilder, LayerProjectileBase layer, float time, float distance, float loop, float lookY, float lookX, float scale, int brightness) {
        this.matrixStack = matrixStack;
        float sizeScale = 1.0f;
        if (entity != null) {
            sizeScale *= entity.getProjectileScale();
        }
        this.doScale(sizeScale, sizeScale, sizeScale);
        this.doTranslate(0.0f, 0.5f - sizeScale / 2.0f, 0.0f);
    }

    public boolean canRenderPart(String partName, BaseProjectileEntity entity, LayerProjectileBase layer) {
        if (layer == null) {
            return this.canBaseRenderPart(partName, entity);
        }
        if (entity != null) {
            return layer.canRenderPart(partName, entity);
        }
        return false;
    }

    public boolean canBaseRenderPart(String partName, BaseProjectileEntity entity) {
        return true;
    }

    public Vector4f getPartColor(String partName, BaseProjectileEntity entity, LayerProjectileBase layer, float loop) {
        if (layer == null || entity == null) {
            return this.getBasePartColor(partName, entity, loop);
        }
        return layer.getPartColor(partName, entity);
    }

    public Vector4f getBasePartColor(String partName, BaseProjectileEntity entity, float loop) {
        return new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public Vec2f getPartTextureOffset(String partName, BaseProjectileEntity entity, LayerProjectileBase layer, float loop) {
        if (layer == null || !(entity instanceof BaseProjectileEntity)) {
            return this.getBaseTextureOffset(partName, entity, loop);
        }
        return layer.getTextureOffset(partName, entity, loop);
    }

    public Vec2f getBaseTextureOffset(String partName, BaseProjectileEntity entity, float loop) {
        return new Vec2f(0.0f, 0.0f);
    }

    public int getBrightness(String partName, LayerProjectileBase layer, BaseProjectileEntity entity, int brightness) {
        if (layer != null) {
            return layer.getBrightness(partName, entity, brightness);
        }
        return brightness;
    }

    @Override
    public void rotate(float rotX, float rotY, float rotZ) {
    }

    @Override
    public void angle(float rotation, float angleX, float angleY, float angleZ) {
    }

    @Override
    public void translate(float posX, float posY, float posZ) {
    }

    @Override
    public void scale(float scaleX, float scaleY, float scaleZ) {
    }

    @Override
    public void doRotate(float rotX, float rotY, float rotZ) {
        this.matrixStack.func_227863_a_(new Vector3f(1.0f, 0.0f, 0.0f).func_229187_a_(rotX));
        this.matrixStack.func_227863_a_(new Vector3f(0.0f, 1.0f, 0.0f).func_229187_a_(rotY));
        this.matrixStack.func_227863_a_(new Vector3f(0.0f, 0.0f, 1.0f).func_229187_a_(rotZ));
    }

    @Override
    public void doAngle(float rotation, float angleX, float angleY, float angleZ) {
        this.matrixStack.func_227863_a_(new Vector3f(angleX, angleY, angleZ).func_229187_a_(rotation));
    }

    @Override
    public void doTranslate(float posX, float posY, float posZ) {
        this.matrixStack.func_227861_a_((double)posX, (double)posY, (double)posZ);
    }

    @Override
    public void doScale(float scaleX, float scaleY, float scaleZ) {
        this.matrixStack.func_227862_a_(scaleX, scaleY, scaleZ);
    }

    @Override
    public double rotateToPoint(double aTarget, double bTarget) {
        return this.rotateToPoint(0.0, 0.0, aTarget, bTarget);
    }

    @Override
    public double rotateToPoint(double aCenter, double bCenter, double aTarget, double bTarget) {
        if (aTarget - aCenter == 0.0) {
            if (aTarget > aCenter) {
                return 0.0;
            }
            if (aTarget < aCenter) {
                return 180.0;
            }
        }
        if (bTarget - bCenter == 0.0) {
            if (bTarget > bCenter) {
                return 90.0;
            }
            if (bTarget < bCenter) {
                return -90.0;
            }
        }
        if (aTarget - aCenter == 0.0 && bTarget - bCenter == 0.0) {
            return 0.0;
        }
        return Math.toDegrees(Math.atan2(aCenter - aTarget, bCenter - bTarget) - 1.5707963267948966);
    }

    @Override
    public double[] rotateToPoint(double xCenter, double yCenter, double zCenter, double xTarget, double yTarget, double zTarget) {
        double[] rotations = new double[]{this.rotateToPoint(yCenter, -zCenter, yTarget, -zTarget), this.rotateToPoint(-zCenter, xCenter, -zTarget, xTarget), this.rotateToPoint(yCenter, xCenter, yTarget, xTarget)};
        return rotations;
    }
}

