/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.AnimationPart;
import com.lycanitesmobs.client.model.Animator;
import com.lycanitesmobs.client.model.IAnimationModel;
import com.lycanitesmobs.client.model.ModelAnimation;
import com.lycanitesmobs.client.model.ModelObjAnimationFrame;
import com.lycanitesmobs.client.model.ModelObjState;
import com.lycanitesmobs.client.model.animation.ModelPartAnimation;
import com.lycanitesmobs.client.obj.ObjModel;
import com.lycanitesmobs.client.obj.ObjPart;
import com.lycanitesmobs.client.renderer.IItemModelRenderer;
import com.lycanitesmobs.client.renderer.layer.LayerItem;
import com.lycanitesmobs.core.info.ModInfo;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec2f;
import org.apache.commons.io.IOUtils;

public abstract class ItemObjModel
implements IAnimationModel {
    public static float ROT_OFFSET_X = 180.0f;
    public static float POS_OFFSET_Y = -1.5f;
    public ObjModel objModel;
    public List<ObjPart> objParts;
    public Map<String, AnimationPart> animationParts = new HashMap<String, AnimationPart>();
    public MatrixStack matrixStack;
    protected Animator animator;
    protected ModelAnimation animation;
    protected AnimationPart currentAnimationPart;
    protected Map<ItemStack, ModelObjState> modelStates = new HashMap<ItemStack, ModelObjState>();
    protected ModelObjState currentModelState;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ItemObjModel initModel(String name, ModInfo groupInfo, String path) {
        this.objModel = new ObjModel(new ResourceLocation(groupInfo.modid, "models/" + path + ".obj"));
        this.objParts = this.objModel.objParts;
        if (this.objParts.isEmpty()) {
            LycanitesMobs.logWarning("", "Unable to load any parts for the " + name + " model!");
        }
        this.animator = new Animator(this);
        ResourceLocation animPartsLoc = new ResourceLocation(groupInfo.modid, "models/" + path + "_parts.json");
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            InputStream in = Minecraft.func_71410_x().func_195551_G().func_199002_a(animPartsLoc).func_199027_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                JsonArray jsonArray = (JsonArray)JSONUtils.func_188173_a((Gson)gson, (Reader)reader, JsonArray.class, (boolean)false);
                Iterator jsonIterator = jsonArray.iterator();
                while (jsonIterator.hasNext()) {
                    JsonObject partJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                    AnimationPart animationPart = new AnimationPart();
                    animationPart.loadFromJson(partJson);
                    this.addAnimationPart(animationPart);
                }
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "There was a problem loading animation parts for " + name + ":");
            e.toString();
        }
        for (AnimationPart part : this.animationParts.values()) {
            part.addChildren(this.animationParts.values().toArray(new AnimationPart[this.animationParts.size()]));
        }
        ResourceLocation animationLocation = new ResourceLocation(groupInfo.modid, "models/" + path + "_animation.json");
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            InputStream in = Minecraft.func_71410_x().func_195551_G().func_199002_a(animationLocation).func_199027_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                JsonObject json = (JsonObject)JSONUtils.func_188173_a((Gson)gson, (Reader)reader, JsonObject.class, (boolean)false);
                this.animation = new ModelAnimation();
                this.animation.loadFromJson(json);
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("Model", "Unable to load animation json for " + name + ".");
        }
        return this;
    }

    public void addAnimationPart(AnimationPart animationPart) {
        if (this.animationParts.containsKey(animationPart.name)) {
            LycanitesMobs.logWarning("", "Tried to add an animation part that already exists: " + animationPart.name + ".");
            return;
        }
        if (animationPart.parentName != null && animationPart.parentName.equals(animationPart.name)) {
            animationPart.parentName = null;
        }
        this.animationParts.put(animationPart.name, animationPart);
    }

    public void addCustomLayers(IItemModelRenderer renderer) {
        if (this.animation != null) {
            this.animation.addItemLayers(renderer);
        }
    }

    public void render(ItemStack itemStack, Hand hand, MatrixStack matrixStack, IVertexBuilder vertexBuilder, IItemModelRenderer renderer, AnimationPart offsetObjPart, LayerItem layer, float loop, int brightness) {
        if (itemStack == null) {
            return;
        }
        this.matrixStack = matrixStack;
        if (layer == null && this.animation != null) {
            layer = this.animation.getBaseLayer(renderer);
        }
        for (ObjPart part : this.objParts) {
            String partName = part.getName().toLowerCase();
            if (!this.canRenderPart(partName, itemStack, layer)) continue;
            this.currentAnimationPart = this.animationParts.get(partName);
            matrixStack.func_227860_a_();
            this.doAngle(ROT_OFFSET_X, 1.0f, 0.0f, 0.0f);
            this.doTranslate(0.0f, POS_OFFSET_Y, 0.0f);
            this.currentAnimationPart.applyAnimationFrames(this.animator);
            this.objModel.renderPart(vertexBuilder, matrixStack.func_227866_c_().func_227872_b_(), matrixStack.func_227866_c_().func_227870_a_(), this.getBrightness(partName, layer, itemStack, brightness), 0, part, this.getPartColor(partName, itemStack, layer, loop), this.getPartTextureOffset(partName, itemStack, layer, loop));
            matrixStack.func_227865_b_();
        }
    }

    public int getBrightness(String partName, LayerItem layer, ItemStack itemStack, int brightness) {
        if (layer != null) {
            return layer.getBrightness(partName, itemStack, brightness);
        }
        return brightness;
    }

    public void generateAnimationFrames(ItemStack itemStack, LayerItem layer, float loop, AnimationPart offsetObjPart) {
        for (ObjPart part : this.objParts) {
            String partName = part.getName().toLowerCase();
            if (!this.canRenderPart(partName, itemStack, layer)) continue;
            this.currentAnimationPart = this.animationParts.get(partName);
            this.animatePart(partName, itemStack, loop);
        }
    }

    public void clearAnimationFrames() {
        for (AnimationPart animationPart : this.animationParts.values()) {
            animationPart.animationFrames.clear();
        }
    }

    public boolean canRenderPart(String partName, ItemStack itemStack, LayerItem layer) {
        if (partName == null) {
            return false;
        }
        return this.animationParts.containsKey(partName = partName.toLowerCase());
    }

    public void animatePart(String partName, ItemStack itemStack, float loop) {
        if (this.animation != null) {
            for (ModelPartAnimation partAnimation : this.animation.partAnimations) {
                partAnimation.animatePart(this, partName, loop);
            }
        }
    }

    public ResourceLocation getTexture(ItemStack itemStack, LayerItem layer) {
        return null;
    }

    public Vector4f getPartColor(String partName, ItemStack itemStack, LayerItem layer, float loop) {
        if (layer != null) {
            return layer.getPartColor(partName, itemStack, loop);
        }
        return new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public Vec2f getPartTextureOffset(String partName, ItemStack itemStack, LayerItem layer, float loop) {
        if (layer != null) {
            return layer.getTextureOffset(partName, itemStack, loop);
        }
        return new Vec2f(0.0f, 0.0f);
    }

    @Override
    public void doRotate(float rotX, float rotY, float rotZ) {
        this.matrixStack.func_227863_a_(new Vector3f(1.0f, 0.0f, 0.0f).func_229187_a_(rotX));
        this.matrixStack.func_227863_a_(new Vector3f(0.0f, 1.0f, 0.0f).func_229187_a_(rotY));
        this.matrixStack.func_227863_a_(new Vector3f(0.0f, 0.0f, 1.0f).func_229187_a_(rotZ));
    }

    @Override
    public void doAngle(float rotation, float angleX, float angleY, float angleZ) {
        this.matrixStack.func_227863_a_(new Vector3f(angleX, angleY, angleZ).func_229187_a_(rotation));
    }

    @Override
    public void doTranslate(float posX, float posY, float posZ) {
        this.matrixStack.func_227861_a_((double)posX, (double)posY, (double)posZ);
    }

    @Override
    public void doScale(float scaleX, float scaleY, float scaleZ) {
        this.matrixStack.func_227862_a_(scaleX, scaleY, scaleZ);
    }

    @Override
    public void angle(float rotation, float angleX, float angleY, float angleZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("angle", rotation, angleX, angleY, angleZ));
    }

    @Override
    public void rotate(float rotX, float rotY, float rotZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("rotate", 1.0f, rotX, rotY, rotZ));
    }

    @Override
    public void translate(float posX, float posY, float posZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("translate", 1.0f, posX, posY, posZ));
    }

    @Override
    public void scale(float scaleX, float scaleY, float scaleZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("scale", 1.0f, scaleX, scaleY, scaleZ));
    }

    @Override
    public double rotateToPoint(double aTarget, double bTarget) {
        return this.rotateToPoint(0.0, 0.0, aTarget, bTarget);
    }

    @Override
    public double rotateToPoint(double aCenter, double bCenter, double aTarget, double bTarget) {
        if (aTarget - aCenter == 0.0) {
            if (aTarget > aCenter) {
                return 0.0;
            }
            if (aTarget < aCenter) {
                return 180.0;
            }
        }
        if (bTarget - bCenter == 0.0) {
            if (bTarget > bCenter) {
                return 90.0;
            }
            if (bTarget < bCenter) {
                return -90.0;
            }
        }
        if (aTarget - aCenter == 0.0 && bTarget - bCenter == 0.0) {
            return 0.0;
        }
        return Math.toDegrees(Math.atan2(aCenter - aTarget, bCenter - bTarget) - 1.5707963267948966);
    }

    @Override
    public double[] rotateToPoint(double xCenter, double yCenter, double zCenter, double xTarget, double yTarget, double zTarget) {
        double[] rotations = new double[]{this.rotateToPoint(yCenter, -zCenter, yTarget, -zTarget), this.rotateToPoint(-zCenter, xCenter, -zTarget, xTarget), this.rotateToPoint(yCenter, xCenter, yTarget, xTarget)};
        return rotations;
    }
}

