/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model;

import com.lycanitesmobs.client.ModelManager;
import com.lycanitesmobs.client.model.AnimationPart;
import com.lycanitesmobs.client.model.ItemObjModel;
import com.lycanitesmobs.client.model.ModelEquipmentPart;
import com.lycanitesmobs.client.renderer.CustomRenderStates;
import com.lycanitesmobs.client.renderer.IItemModelRenderer;
import com.lycanitesmobs.client.renderer.layer.LayerItem;
import com.lycanitesmobs.core.item.equipment.ItemEquipment;
import com.lycanitesmobs.core.item.equipment.ItemEquipmentPart;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Hand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;

public class EquipmentModel
implements IItemModelRenderer {
    protected List<LayerItem> renderLayers = new ArrayList<LayerItem>();
    protected List<ItemObjModel> renderedModels = new ArrayList<ItemObjModel>();

    public void render(ItemStack itemStack, Hand hand, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, IItemModelRenderer renderer, float loop, int brightness) {
        if (!(itemStack.func_77973_b() instanceof ItemEquipment)) {
            return;
        }
        ItemEquipment itemEquipment = (ItemEquipment)itemStack.func_77973_b();
        NonNullList<ItemStack> equipmentPartStacks = itemEquipment.getEquipmentPartStacks(itemStack);
        int slotId = -1;
        ItemObjModel modelPartBase = null;
        ItemObjModel modelPartHead = null;
        for (ItemStack partStack : equipmentPartStacks) {
            if (++slotId == 0) {
                modelPartBase = this.renderPart(partStack, hand, matrixStack, renderTypeBuffer, renderer, null, loop, brightness);
            } else if (slotId == 1) {
                if (modelPartBase == null || !modelPartBase.animationParts.containsKey("head")) continue;
                modelPartHead = this.renderPart(partStack, hand, matrixStack, renderTypeBuffer, renderer, modelPartBase.animationParts.get("head"), loop, brightness);
            } else if (slotId == 2) {
                if (modelPartHead == null || !modelPartHead.animationParts.containsKey("tipa")) continue;
                this.renderPart(partStack, hand, matrixStack, renderTypeBuffer, renderer, modelPartHead.animationParts.get("tipa"), loop, brightness);
            } else if (slotId == 3) {
                if (modelPartHead == null || !modelPartHead.animationParts.containsKey("tipb")) continue;
                this.renderPart(partStack, hand, matrixStack, renderTypeBuffer, renderer, modelPartHead.animationParts.get("tipb"), loop, brightness);
            } else if (slotId == 4) {
                if (modelPartHead == null || !modelPartHead.animationParts.containsKey("tipc")) continue;
                this.renderPart(partStack, hand, matrixStack, renderTypeBuffer, renderer, modelPartHead.animationParts.get("tipc"), loop, brightness);
            }
            if (slotId != 5 || modelPartBase == null || !modelPartBase.animationParts.containsKey("pommel")) continue;
            this.renderPart(partStack, hand, matrixStack, renderTypeBuffer, renderer, modelPartBase.animationParts.get("pommel"), loop, brightness);
        }
        for (ItemObjModel itemObjModel : this.renderedModels) {
            itemObjModel.clearAnimationFrames();
        }
        this.renderedModels.clear();
    }

    public ItemObjModel renderPart(ItemStack partStack, Hand hand, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, IItemModelRenderer renderer, AnimationPart offsetPart, float loop, int brightness) {
        if (partStack.func_190926_b() || !(partStack.func_77973_b() instanceof ItemEquipmentPart)) {
            return null;
        }
        ItemEquipmentPart itemEquipmentPart = (ItemEquipmentPart)partStack.func_77973_b();
        ModelEquipmentPart itemObjModel = ModelManager.getInstance().getEquipmentPartModel(itemEquipmentPart);
        if (itemObjModel == null) {
            return null;
        }
        if (itemObjModel.animationParts.containsKey("base")) {
            itemObjModel.animationParts.get("base").setOffset(offsetPart);
        }
        this.renderLayers.clear();
        itemObjModel.addCustomLayers(this);
        itemObjModel.generateAnimationFrames(partStack, null, loop, offsetPart);
        ResourceLocation texture = ((ItemObjModel)itemObjModel).getTexture(partStack, null);
        RenderType renderType = CustomRenderStates.getObjRenderType(texture);
        itemObjModel.render(partStack, hand, matrixStack, renderTypeBuffer.getBuffer(renderType), renderer, offsetPart, null, loop, brightness);
        for (LayerItem layer : this.renderLayers) {
            texture = ((ItemObjModel)itemObjModel).getTexture(partStack, layer);
            renderType = CustomRenderStates.getObjRenderType(texture);
            itemObjModel.render(partStack, hand, matrixStack, renderTypeBuffer.getBuffer(renderType), renderer, offsetPart, layer, loop, brightness);
        }
        this.renderedModels.add(itemObjModel);
        return itemObjModel;
    }

    @Override
    public void bindItemTexture(ResourceLocation location) {
    }

    @Override
    public List<LayerItem> addLayer(LayerItem renderLayer) {
        if (!this.renderLayers.contains(renderLayer)) {
            this.renderLayers.add(renderLayer);
        }
        return this.renderLayers;
    }
}

