/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.CreatureModel;
import com.lycanitesmobs.client.obj.ObjModel;
import com.lycanitesmobs.client.obj.ObjPart;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ModInfo;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class CreatureObjModelOld
extends CreatureModel {
    public static float modelXRotOffset = 180.0f;
    public static float modelYPosOffset = -1.5f;
    public ObjModel objModel;
    public List<ObjPart> wavefrontParts;
    public Map<String, float[]> partCenters = new HashMap<String, float[]>();
    public Map<String, float[]> partSubCenters = new HashMap<String, float[]>();
    public Map<String, float[]> offsets = new HashMap<String, float[]>();
    public boolean lockHeadX = false;
    public boolean lockHeadY = false;
    public boolean bodyIsTrophy = true;
    public float trophyScale = 1.0f;
    public float[] trophyOffset = new float[0];
    public float[] trophyMouthOffset = new float[0];
    public boolean dontColor = false;

    public CreatureObjModelOld() {
        this(1.0f);
    }

    public CreatureObjModelOld(float shadowSize) {
    }

    public CreatureObjModelOld initModel(String name, ModInfo modInfo, String path) {
        CreatureInfo creatureInfo = CreatureManager.getInstance().getCreature(name);
        if (creatureInfo != null && !creatureInfo.enabled) {
            return this;
        }
        this.objModel = new ObjModel(new ResourceLocation(modInfo.modid, "models/" + path + ".obj"));
        this.wavefrontParts = this.objModel.objParts;
        if (this.wavefrontParts.isEmpty()) {
            LycanitesMobs.logWarning("", "Unable to load (old format) model obj for: " + name + "");
        }
        return this;
    }

    @Override
    public void render(BaseCreatureEntity entity, MatrixStack matrixStack, IVertexBuilder vertexBuilder, LayerCreatureBase layer, float time, float distance, float loop, float lookY, float lookX, float scale, int brightness, int fade) {
        this.matrixStack = matrixStack;
        boolean isChild = false;
        if (entity != null) {
            isChild = entity.func_70631_g_();
        }
        boolean trophyModel = false;
        if (scale < 0.0f) {
            trophyModel = true;
            scale = -scale;
        } else if (entity != null) {
            scale *= entity.func_213355_cm();
        }
        if (entity != null && entity.onlyRenderTicks >= 0.0f) {
            loop = entity.onlyRenderTicks;
        }
        for (ObjPart part : this.wavefrontParts) {
            if (part.getName() == null) continue;
            String partName = part.getName().toLowerCase();
            boolean isTrophyPart = this.isTrophyPart(partName);
            if (this.bodyIsTrophy && partName.contains("body")) {
                isTrophyPart = true;
            }
            if (!this.canRenderPart(partName, (Entity)entity, layer, trophyModel) || trophyModel && !isTrophyPart) continue;
            matrixStack.func_227860_a_();
            this.doAngle(modelXRotOffset, 1.0f, 0.0f, 0.0f);
            this.doTranslate(0.0f, modelYPosOffset, 0.0f);
            if (isChild && !trophyModel) {
                this.childScale(partName);
            }
            this.doScale(scale, scale, scale);
            if (trophyModel) {
                this.doScale(this.trophyScale, this.trophyScale, this.trophyScale);
            }
            if (entity != null && entity.hasPerchTarget()) {
                distance = 0.0f;
            }
            this.centerPart(partName);
            this.animatePart(partName, (LivingEntity)entity, time, distance, loop, -lookY, lookX, scale);
            if (trophyModel) {
                if (!partName.contains("head") && !partName.contains("body")) {
                    float[] mouthOffset = this.comparePartCenters(this.bodyIsTrophy ? "body" : "head", partName);
                    this.doTranslate(mouthOffset[0], mouthOffset[1], mouthOffset[2]);
                    if (this.trophyMouthOffset.length >= 3) {
                        this.doTranslate(this.trophyMouthOffset[0], this.trophyMouthOffset[1], this.trophyMouthOffset[2]);
                    }
                }
                if (partName.contains("head")) {
                    if (!partName.contains("left")) {
                        this.doTranslate(-0.3f, 0.0f, 0.0f);
                        this.doAngle(5.0f, 0.0f, 1.0f, 0.0f);
                    }
                    if (!partName.contains("right")) {
                        this.doTranslate(0.3f, 0.0f, 0.0f);
                        this.doAngle(-5.0f, 0.0f, 1.0f, 0.0f);
                    }
                }
                this.uncenterPart(partName);
                if (this.trophyOffset.length >= 3) {
                    this.doTranslate(this.trophyOffset[0], this.trophyOffset[1], this.trophyOffset[2]);
                }
            }
            this.uncenterPart(partName);
            this.objModel.renderPart(vertexBuilder, matrixStack.func_227866_c_().func_227872_b_(), matrixStack.func_227866_c_().func_227870_a_(), this.getBrightness(partName, layer, entity, brightness), fade, part, this.getPartColor(partName, (Entity)entity, layer, trophyModel, loop), this.getPartTextureOffset(partName, (Entity)entity, layer, trophyModel, loop));
            matrixStack.func_227865_b_();
        }
    }

    public boolean isTrophyPart(String partName) {
        if (partName == null) {
            return false;
        }
        return (partName = partName.toLowerCase()).contains("head") || partName.contains("mouth") || partName.contains("eye");
    }

    public void animatePart(String partName, LivingEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        float pi = (float)Math.PI;
        float posX = 0.0f;
        float posY = 0.0f;
        float posZ = 0.0f;
        float angleX = 0.0f;
        float angleY = 0.0f;
        float angleZ = 0.0f;
        float rotation = 0.0f;
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (partName.toLowerCase().contains("head")) {
            if (!this.lockHeadX) {
                rotX = (float)((double)rotX + Math.toDegrees(lookX / 57.295776f));
            }
            if (!this.lockHeadY) {
                rotY = (float)((double)rotY + Math.toDegrees(lookY / 57.295776f));
            }
        }
        this.doAngle(rotation, angleX, angleY, angleZ);
        this.doRotate(rotX, rotY, rotZ);
        this.doTranslate(posX, posY, posZ);
    }

    public void childScale(String partName) {
        this.doScale(0.5f, 0.5f, 0.5f);
    }

    public void setPartCenter(String partName, float centerX, float centerY, float centerZ) {
        if (this.isTrophyPart(partName)) {
            this.bodyIsTrophy = false;
        }
        this.partCenters.put(partName, new float[]{centerX, centerY, centerZ});
    }

    public void setPartCenters(float centerX, float centerY, float centerZ, String ... partNames) {
        for (String partName : partNames) {
            this.setPartCenter(partName, centerX, centerY, centerZ);
        }
    }

    public float[] getPartCenter(String partName) {
        if (!this.partCenters.containsKey(partName)) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        return this.partCenters.get(partName);
    }

    public void centerPart(String partName) {
        if (!this.partCenters.containsKey(partName)) {
            return;
        }
        float[] partCenter = this.partCenters.get(partName);
        this.doTranslate(partCenter[0], partCenter[1], partCenter[2]);
    }

    public void uncenterPart(String partName) {
        if (!this.partCenters.containsKey(partName)) {
            return;
        }
        float[] partCenter = this.partCenters.get(partName);
        this.doTranslate(-partCenter[0], -partCenter[1], -partCenter[2]);
    }

    public void centerPartToPart(String part, String targetPart) {
        this.uncenterPart(part);
        float[] partCenter = this.partCenters.get(targetPart);
        if (partCenter != null) {
            this.doTranslate(partCenter[0], partCenter[1], partCenter[2]);
        }
    }

    public void uncenterPartToPart(String part, String targetPart) {
        float[] partCenter = this.partCenters.get(targetPart);
        if (partCenter != null) {
            this.doTranslate(-partCenter[0], -partCenter[1], -partCenter[2]);
        }
        this.centerPart(part);
    }

    public float[] comparePartCenters(String centerPartName, String targetPartName) {
        float[] centerPart = this.getPartCenter(centerPartName);
        float[] targetPart = this.getPartCenter(targetPartName);
        float[] partDifference = new float[3];
        if (targetPart == null) {
            return partDifference;
        }
        for (int i = 0; i < 3; ++i) {
            partDifference[i] = targetPart[i] - centerPart[i];
        }
        return partDifference;
    }

    public void setPartSubCenter(String partName, float centerX, float centerY, float centerZ) {
        this.partSubCenters.put(partName, new float[]{centerX, centerY, centerZ});
    }

    public void setPartSubCenters(float centerX, float centerY, float centerZ, String ... partNames) {
        for (String partName : partNames) {
            this.setPartSubCenter(partName, centerX, centerY, centerZ);
        }
    }

    public void subCenterPart(String partName) {
        float[] offset = this.getSubCenterOffset(partName);
        if (offset == null) {
            return;
        }
        this.doTranslate(offset[0], offset[1], offset[2]);
    }

    public void unsubCenterPart(String partName) {
        float[] offset = this.getSubCenterOffset(partName);
        if (offset == null) {
            return;
        }
        this.doTranslate(-offset[0], -offset[1], -offset[2]);
    }

    public float[] getSubCenterOffset(String partName) {
        if (!this.partCenters.containsKey(partName)) {
            return null;
        }
        if (!this.partSubCenters.containsKey(partName)) {
            return null;
        }
        float[] partCenter = this.partCenters.get(partName);
        float[] partSubCenter = this.partSubCenters.get(partName);
        float[] offset = new float[3];
        for (int coord = 0; coord < 3; ++coord) {
            offset[coord] = partSubCenter[coord] - partCenter[coord];
        }
        return offset;
    }

    public void setOffset(String offsetName, float[] offset) {
        this.offsets.put(offsetName, offset);
    }

    public float[] getOffset(String offsetName) {
        if (!this.offsets.containsKey(offsetName)) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        return this.offsets.get(offsetName);
    }
}

