/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.model.AnimationPart;
import com.lycanitesmobs.client.model.Animator;
import com.lycanitesmobs.client.model.CreatureModel;
import com.lycanitesmobs.client.model.ModelAnimation;
import com.lycanitesmobs.client.model.ModelObjAnimationFrame;
import com.lycanitesmobs.client.model.ModelObjState;
import com.lycanitesmobs.client.obj.ObjModel;
import com.lycanitesmobs.client.obj.ObjPart;
import com.lycanitesmobs.client.renderer.CreatureRenderer;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ModInfo;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.io.IOUtils;

@OnlyIn(value=Dist.CLIENT)
public class CreatureObjModel
extends CreatureModel {
    public static float MODEL_OFFSET_ROT_X = 180.0f;
    public static float MODEL_OFFSET_POS_Y = -1.5f;
    public ObjModel objModel;
    public List<ObjPart> objParts;
    public Map<String, AnimationPart> animationParts = new HashMap<String, AnimationPart>();
    public float lookHeadScaleX = 1.0f;
    public float lookHeadScaleY = 1.0f;
    public float lookNeckScaleX = 0.0f;
    public float lookNeckScaleY = 0.0f;
    public float lookBodyScaleX = 0.0f;
    public float lookBodyScaleY = 0.0f;
    public boolean bigChildHead = false;
    public boolean bodyIsTrophy = true;
    public float trophyScale = 1.0f;
    public float[] trophyOffset = new float[0];
    public float[] trophyMouthOffset = new float[0];
    public boolean dontColor = false;
    protected Animator animator;
    protected AnimationPart currentAnimationPart;
    protected ModelAnimation animation;
    protected Map<Entity, ModelObjState> modelStates = new HashMap<Entity, ModelObjState>();
    protected ModelObjState currentModelState;

    public CreatureObjModel() {
        this(1.0f);
    }

    public CreatureObjModel(float shadowSize) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CreatureObjModel initModel(String name, ModInfo modInfo, String path) {
        CreatureInfo creatureInfo = CreatureManager.getInstance().getCreature(name);
        if (creatureInfo != null && !creatureInfo.enabled) {
            return this;
        }
        this.objModel = new ObjModel(new ResourceLocation(modInfo.modid, "models/" + path + ".obj"));
        this.objParts = this.objModel.objParts;
        if (this.objParts.isEmpty()) {
            LycanitesMobs.logWarning("", "Unable to load model obj for: " + name + "");
        }
        this.animator = new Animator(this);
        ResourceLocation modelPartsLocation = new ResourceLocation(modInfo.modid, "models/" + path + "_parts.json");
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            InputStream in = Minecraft.func_71410_x().func_195551_G().func_199002_a(modelPartsLocation).func_199027_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                JsonArray jsonArray = (JsonArray)JSONUtils.func_188173_a((Gson)gson, (Reader)reader, JsonArray.class, (boolean)false);
                Iterator jsonIterator = jsonArray.iterator();
                while (jsonIterator.hasNext()) {
                    JsonObject partJson = ((JsonElement)jsonIterator.next()).getAsJsonObject();
                    AnimationPart animationPart = new AnimationPart();
                    animationPart.loadFromJson(partJson);
                    this.addAnimationPart(animationPart);
                }
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("", "Unable to load model parts json for: " + name + "");
        }
        for (AnimationPart part : this.animationParts.values()) {
            part.addChildren(this.animationParts.values().toArray(new AnimationPart[this.animationParts.size()]));
        }
        ResourceLocation animationLocation = new ResourceLocation(modInfo.modid, "models/" + path + "_animation.json");
        try {
            Gson gson = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
            InputStream in = Minecraft.func_71410_x().func_195551_G().func_199002_a(animationLocation).func_199027_b();
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            try {
                JsonObject json = (JsonObject)JSONUtils.func_188173_a((Gson)gson, (Reader)reader, JsonObject.class, (boolean)false);
                this.animation = new ModelAnimation();
                this.animation.loadFromJson(json);
            }
            finally {
                IOUtils.closeQuietly((Reader)reader);
            }
        }
        catch (Exception e) {
            LycanitesMobs.logWarning("Models", "Unable to load animation json for: " + name + ".");
        }
        return this;
    }

    public void addAnimationPart(AnimationPart animationPart) {
        if (this.animationParts.containsKey(animationPart.name)) {
            LycanitesMobs.logWarning("", "Tried to add an animation part that already exists: " + animationPart.name + ".");
            return;
        }
        if (animationPart.parentName != null && animationPart.parentName.equals(animationPart.name)) {
            animationPart.parentName = null;
        }
        this.animationParts.put(animationPart.name, animationPart);
    }

    @Override
    public void addCustomLayers(CreatureRenderer renderer) {
        super.addCustomLayers(renderer);
        if (this.animation != null) {
            this.animation.addCreatureLayers(renderer);
        }
    }

    @Override
    public void generateAnimationFrames(BaseCreatureEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale, int brightness) {
        boolean renderAsTrophy = false;
        this.field_217114_e = false;
        if (entity != null) {
            this.field_217114_e = entity.func_70631_g_();
        }
        if (scale < 0.0f) {
            renderAsTrophy = true;
            scale = -scale;
        } else if (entity != null) {
            scale *= entity.func_213355_cm();
        }
        if (entity != null && entity.onlyRenderTicks >= 0.0f) {
            loop = entity.onlyRenderTicks;
        }
        this.currentModelState = this.getModelState((Entity)entity);
        this.updateAttackProgress((Entity)entity);
        if (entity != null && entity.hasPerchTarget()) {
            distance = 0.0f;
        }
        for (ObjPart part : this.objParts) {
            String partName = part.getName().toLowerCase();
            this.currentAnimationPart = this.animationParts.get(partName);
            if (this.currentAnimationPart == null) continue;
            this.animatePart(partName, (LivingEntity)entity, time, distance, loop, -lookY, lookX, scale);
            if (!renderAsTrophy) continue;
            if (partName.contains("head")) {
                if (!partName.contains("left")) {
                    this.translate(-0.3f, 0.0f, 0.0f);
                    this.angle(5.0f, 0.0f, 1.0f, 0.0f);
                }
                if (!partName.contains("right")) {
                    this.translate(0.3f, 0.0f, 0.0f);
                    this.angle(-5.0f, 0.0f, 1.0f, 0.0f);
                }
            }
            if (this.trophyOffset.length < 3) continue;
            this.translate(this.trophyOffset[0], this.trophyOffset[1], this.trophyOffset[2]);
        }
    }

    public void animatePart(String partName, LivingEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale) {
        float rotX = 0.0f;
        float rotY = 0.0f;
        float rotZ = 0.0f;
        if (partName.toLowerCase().equals("head")) {
            rotX = (float)((double)rotX + Math.toDegrees(lookX / 57.295776f) * (double)this.lookHeadScaleX);
            rotY = (float)((double)rotY + Math.toDegrees(lookY / 57.295776f) * (double)this.lookHeadScaleY);
        }
        if (partName.equals("neck")) {
            rotX = (float)((double)rotX + Math.toDegrees(lookX / 57.295776f) * (double)this.lookNeckScaleX);
            rotY = (float)((double)rotY + Math.toDegrees(lookY / 57.295776f) * (double)this.lookNeckScaleY);
        }
        this.rotate(rotX, rotY, rotZ);
    }

    @Override
    public void clearAnimationFrames() {
        for (AnimationPart animationPart : this.animationParts.values()) {
            animationPart.animationFrames.clear();
        }
    }

    @Override
    public void render(BaseCreatureEntity entity, MatrixStack matrixStack, IVertexBuilder vertexBuilder, LayerCreatureBase layer, float time, float distance, float loop, float lookY, float lookX, float scale, int brightness, int fade) {
        this.matrixStack = matrixStack;
        boolean renderAsTrophy = false;
        this.field_217114_e = false;
        if (entity != null) {
            this.field_217114_e = entity.func_70631_g_();
        }
        if (scale < 0.0f) {
            renderAsTrophy = true;
            scale = -scale;
        } else if (entity != null) {
            scale *= entity.func_213355_cm();
        }
        for (ObjPart part : this.objParts) {
            String partName = part.getName().toLowerCase();
            if (!this.canRenderPart(partName, (Entity)entity, layer, renderAsTrophy)) continue;
            this.currentAnimationPart = this.animationParts.get(partName);
            if (this.currentAnimationPart == null) continue;
            matrixStack.func_227860_a_();
            this.animator.doAngle(MODEL_OFFSET_ROT_X, 1.0f, 0.0f, 0.0f);
            this.animator.doTranslate(0.0f, MODEL_OFFSET_POS_Y, 0.0f);
            if (this.field_217114_e && !renderAsTrophy) {
                this.childScale(partName);
                if (this.bigChildHead && (partName.contains("head") || partName.contains("mouth"))) {
                    this.animator.doTranslate(-(this.currentAnimationPart.centerX / 2.0f), -(this.currentAnimationPart.centerY / 2.0f), -(this.currentAnimationPart.centerZ / 2.0f));
                }
            }
            if (renderAsTrophy) {
                this.animator.doScale(this.trophyScale, this.trophyScale, this.trophyScale);
            }
            this.animator.doScale(scale, scale, scale);
            this.currentAnimationPart.applyAnimationFrames(this.animator);
            this.objModel.renderPart(vertexBuilder, matrixStack.func_227866_c_().func_227872_b_(), matrixStack.func_227866_c_().func_227870_a_(), this.getBrightness(partName, layer, entity, brightness), fade, part, this.getPartColor(partName, (Entity)entity, layer, renderAsTrophy, loop), this.getPartTextureOffset(partName, (Entity)entity, layer, renderAsTrophy, loop));
            matrixStack.func_227865_b_();
        }
    }

    @Override
    public boolean canRenderPart(String partName, Entity entity, LayerCreatureBase layer, boolean trophy) {
        if (partName == null) {
            return false;
        }
        if (!this.animationParts.containsKey(partName = partName.toLowerCase())) {
            return false;
        }
        if (trophy && !this.isTrophyPart(partName)) {
            return false;
        }
        return super.canRenderPart(partName, entity, layer, trophy);
    }

    public boolean isTrophyPart(String partName) {
        if (partName == null) {
            return false;
        }
        if ((partName = partName.toLowerCase()).contains("head") || partName.contains("mouth") || partName.contains("eye")) {
            return true;
        }
        return this.bodyIsTrophy && partName.contains("body");
    }

    public ModelObjState getModelState(Entity entity) {
        if (entity == null) {
            return null;
        }
        if (this.modelStates.containsKey(entity)) {
            if (!entity.func_70089_S()) {
                this.modelStates.remove(entity);
                return null;
            }
            return this.modelStates.get(entity);
        }
        ModelObjState modelState = new ModelObjState(entity);
        this.modelStates.put(entity, modelState);
        return modelState;
    }

    public void childScale(String partName) {
        if (this.bigChildHead && (partName.contains("head") || partName.contains("mouth"))) {
            return;
        }
        this.animator.doScale(0.5f, 0.5f, 0.5f);
    }

    public void updateAttackProgress(Entity entity) {
        if (this.currentModelState == null || !(entity instanceof BaseCreatureEntity)) {
            return;
        }
        BaseCreatureEntity entityCreature = (BaseCreatureEntity)entity;
        if (this.currentModelState.attackAnimationPlaying) {
            if (this.currentModelState.attackAnimationIncreasing) {
                this.currentModelState.attackAnimationProgress = Math.min(this.currentModelState.attackAnimationProgress + this.currentModelState.attackAnimationSpeed, 1.0f);
                if (this.currentModelState.attackAnimationProgress >= 1.0f) {
                    this.currentModelState.attackAnimationIncreasing = false;
                }
            } else {
                this.currentModelState.attackAnimationProgress = Math.max(this.currentModelState.attackAnimationProgress - this.currentModelState.attackAnimationSpeed, 0.0f);
                if (this.currentModelState.attackAnimationProgress <= 0.0f) {
                    this.currentModelState.attackAnimationPlaying = false;
                }
            }
        } else if (entityCreature.isAttackOnCooldown()) {
            this.currentModelState.attackAnimationPlaying = true;
            this.currentModelState.attackAnimationIncreasing = true;
            this.currentModelState.attackAnimationProgress = 0.0f;
        }
    }

    public float getAttackProgress() {
        if (this.currentModelState == null) {
            return 0.0f;
        }
        return this.currentModelState.attackAnimationProgress;
    }

    @Override
    public void angle(float rotation, float angleX, float angleY, float angleZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("angle", rotation, angleX, angleY, angleZ));
    }

    @Override
    public void rotate(float rotX, float rotY, float rotZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("rotate", 1.0f, rotX, rotY, rotZ));
    }

    @Override
    public void translate(float posX, float posY, float posZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("translate", 1.0f, posX, posY, posZ));
    }

    @Override
    public void scale(float scaleX, float scaleY, float scaleZ) {
        this.currentAnimationPart.addAnimationFrame(new ModelObjAnimationFrame("scale", 1.0f, scaleX, scaleY, scaleZ));
    }

    public void shiftOrigin(String fromPartName, String toPartName) {
        AnimationPart fromPart = this.animationParts.get(fromPartName);
        AnimationPart toPart = this.animationParts.get(toPartName);
        float offsetX = toPart.centerX - fromPart.centerX;
        float offsetY = toPart.centerY - fromPart.centerY;
        float offsetZ = toPart.centerZ - fromPart.centerZ;
        this.translate(offsetX, offsetY, offsetZ);
    }

    public void shiftOriginBack(String fromPartName, String toPartName) {
        AnimationPart fromPart = this.animationParts.get(fromPartName);
        AnimationPart toPart = this.animationParts.get(toPartName);
        float offsetX = toPart.centerX - fromPart.centerX;
        float offsetY = toPart.centerY - fromPart.centerY;
        float offsetZ = toPart.centerZ - fromPart.centerZ;
        this.translate(-offsetX, -offsetY, -offsetZ);
    }
}

