/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.model;

import com.lycanitesmobs.client.model.IAnimationModel;
import com.lycanitesmobs.client.renderer.CreatureRenderer;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureBase;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureEquipment;
import com.lycanitesmobs.client.renderer.layer.LayerCreatureSaddle;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.Vector4f;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.Vec2f;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class CreatureModel
extends EntityModel<BaseCreatureEntity>
implements IAnimationModel {
    public MatrixStack matrixStack;

    public CreatureModel() {
        this(1.0f);
    }

    public CreatureModel(float shadowSize) {
        this.field_78090_t = 128;
        this.field_78089_u = 128;
    }

    public void func_225597_a_(BaseCreatureEntity entity, float time, float distance, float loop, float lookY, float lookX) {
    }

    public void func_225598_a_(MatrixStack matrixStack, IVertexBuilder vertexBuilder, int someIntA, int someIntB, float someFloatA, float someFloatB, float someFloatC, float someFloatD) {
    }

    public void generateAnimationFrames(BaseCreatureEntity entity, float time, float distance, float loop, float lookY, float lookX, float scale, int brightness) {
    }

    public void clearAnimationFrames() {
    }

    public abstract void render(BaseCreatureEntity var1, MatrixStack var2, IVertexBuilder var3, LayerCreatureBase var4, float var5, float var6, float var7, float var8, float var9, float var10, int var11, int var12);

    public void addCustomLayers(CreatureRenderer renderer) {
        renderer.func_177094_a(new LayerCreatureEquipment(renderer, "chest"));
        renderer.func_177094_a(new LayerCreatureSaddle(renderer));
    }

    public boolean canRenderPart(String partName, Entity entity, LayerCreatureBase layer, boolean trophy) {
        if (layer == null) {
            return this.canBaseRenderPart(partName, entity, trophy);
        }
        if (entity instanceof BaseCreatureEntity) {
            return layer.canRenderPart(partName, (BaseCreatureEntity)entity, trophy);
        }
        return false;
    }

    public boolean canBaseRenderPart(String partName, Entity entity, boolean trophy) {
        return true;
    }

    public Vector4f getPartColor(String partName, Entity entity, LayerCreatureBase layer, boolean trophy, float loop) {
        if (layer == null || !(entity instanceof BaseCreatureEntity)) {
            return this.getBasePartColor(partName, entity, trophy, loop);
        }
        return layer.getPartColor(partName, (BaseCreatureEntity)entity, trophy);
    }

    public Vector4f getBasePartColor(String partName, Entity entity, boolean trophy, float loop) {
        return new Vector4f(1.0f, 1.0f, 1.0f, 1.0f);
    }

    public Vec2f getPartTextureOffset(String partName, Entity entity, LayerCreatureBase layer, boolean trophy, float loop) {
        if (layer == null || !(entity instanceof BaseCreatureEntity)) {
            return this.getBaseTextureOffset(partName, entity, trophy, loop);
        }
        return layer.getTextureOffset(partName, (BaseCreatureEntity)entity, trophy, loop);
    }

    public Vec2f getBaseTextureOffset(String partName, Entity entity, boolean trophy, float loop) {
        return new Vec2f(0.0f, 0.0f);
    }

    public int getBrightness(String partName, LayerCreatureBase layer, BaseCreatureEntity entity, int brightness) {
        if (layer != null) {
            return layer.getBrightness(partName, entity, brightness);
        }
        return brightness;
    }

    @Override
    public void rotate(float rotX, float rotY, float rotZ) {
    }

    @Override
    public void angle(float rotation, float angleX, float angleY, float angleZ) {
    }

    @Override
    public void translate(float posX, float posY, float posZ) {
    }

    @Override
    public void scale(float scaleX, float scaleY, float scaleZ) {
    }

    @Override
    public void doRotate(float rotX, float rotY, float rotZ) {
        this.matrixStack.func_227863_a_(new Vector3f(1.0f, 0.0f, 0.0f).func_229187_a_(rotX));
        this.matrixStack.func_227863_a_(new Vector3f(0.0f, 1.0f, 0.0f).func_229187_a_(rotY));
        this.matrixStack.func_227863_a_(new Vector3f(0.0f, 0.0f, 1.0f).func_229187_a_(rotZ));
    }

    @Override
    public void doAngle(float rotation, float angleX, float angleY, float angleZ) {
        this.matrixStack.func_227863_a_(new Vector3f(angleX, angleY, angleZ).func_229187_a_(rotation));
    }

    @Override
    public void doTranslate(float posX, float posY, float posZ) {
        this.matrixStack.func_227861_a_((double)posX, (double)posY, (double)posZ);
    }

    @Override
    public void doScale(float scaleX, float scaleY, float scaleZ) {
        this.matrixStack.func_227862_a_(scaleX, scaleY, scaleZ);
    }

    @Override
    public double rotateToPoint(double aTarget, double bTarget) {
        return this.rotateToPoint(0.0, 0.0, aTarget, bTarget);
    }

    @Override
    public double rotateToPoint(double aCenter, double bCenter, double aTarget, double bTarget) {
        if (aTarget - aCenter == 0.0) {
            if (aTarget > aCenter) {
                return 0.0;
            }
            if (aTarget < aCenter) {
                return 180.0;
            }
        }
        if (bTarget - bCenter == 0.0) {
            if (bTarget > bCenter) {
                return 90.0;
            }
            if (bTarget < bCenter) {
                return -90.0;
            }
        }
        if (aTarget - aCenter == 0.0 && bTarget - bCenter == 0.0) {
            return 0.0;
        }
        return Math.toDegrees(Math.atan2(aCenter - aTarget, bCenter - bTarget) - 1.5707963267948966);
    }

    @Override
    public double[] rotateToPoint(double xCenter, double yCenter, double zCenter, double xTarget, double yTarget, double zTarget) {
        double[] rotations = new double[]{this.rotateToPoint(yCenter, -zCenter, yTarget, -zTarget), this.rotateToPoint(-zCenter, xCenter, -zTarget, xTarget), this.rotateToPoint(yCenter, xCenter, yTarget, xTarget)};
        return rotations;
    }
}

