/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui.widgets;

import com.lycanitesmobs.client.TextureManager;
import com.lycanitesmobs.client.gui.SummoningPedestalScreen;
import com.lycanitesmobs.client.gui.widgets.BaseList;
import com.lycanitesmobs.client.gui.widgets.BaseListEntry;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import java.util.List;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class SummoningPedestalList
extends BaseList<SummoningPedestalScreen> {
    public ExtendedPlayer playerExt;

    public SummoningPedestalList(SummoningPedestalScreen parentGui, ExtendedPlayer playerExt, int width, int height, int top, int bottom, int left) {
        super(parentGui, width, height, top, bottom, left, 28);
        this.playerExt = playerExt;
        this.createEntries();
    }

    @Override
    public void createEntries() {
        if (this.playerExt == null) {
            return;
        }
        for (String minionName : this.playerExt.getBeastiary().getSummonableList().values()) {
            this.addEntry((AbstractList.AbstractListEntry)new SummoningPedestalEntry(this, minionName));
        }
    }

    protected boolean isSelectedItem(int index) {
        if (!(this.getEntry(index) instanceof SummoningPedestalEntry)) {
            return false;
        }
        return ((SummoningPedestalScreen)((Object)this.screen)).getSelectedMinionName() != null && ((SummoningPedestalScreen)((Object)this.screen)).getSelectedMinionName().equals(((SummoningPedestalEntry)this.getEntry((int)index)).minionName);
    }

    @OnlyIn(value=Dist.CLIENT)
    public class SummoningPedestalEntry
    extends BaseListEntry {
        SummoningPedestalList parentGUI;
        String minionName;

        public SummoningPedestalEntry(SummoningPedestalList list, String minionName) {
            this.parentGUI = list;
            this.minionName = minionName;
        }

        @Override
        public void render(int index, int top, int left, int bottom, int right, int mouseX, int mouseY, boolean focus, float partialTicks) {
            CreatureInfo creatureInfo = CreatureManager.getInstance().getCreature(this.minionName);
            int levelBarWidth = 9;
            int levelBarHeight = 9;
            int levelBarX = left + 20;
            int levelBarY = top - levelBarHeight - 6;
            int level = creatureInfo.summonCost;
            if (level <= 10) {
                ((SummoningPedestalScreen)((Object)this.parentGUI.screen)).drawBar(TextureManager.getTexture("GUIPetLevel"), levelBarX, levelBarY, 0.0f, levelBarWidth, levelBarHeight, level, 10);
            }
            ((SummoningPedestalScreen)((Object)this.parentGUI.screen)).getFontRenderer().func_211126_b(creatureInfo.getTitle().func_150254_d(), (float)(left + 20), (float)(top + 4), 0xFFFFFF);
            ((SummoningPedestalScreen)((Object)this.parentGUI.screen)).drawTexture(creatureInfo.getIcon(), left + 2, top + 4, 0.0f, 1.0f, 1.0f, 16.0f, 16.0f);
        }

        @Override
        public List<? extends IGuiEventListener> children() {
            return null;
        }

        @Override
        protected void onClicked() {
            ((SummoningPedestalScreen)((Object)this.parentGUI.screen)).selectMinion(this.minionName);
        }
    }
}

