/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui.beastiary.lists;

import com.lycanitesmobs.client.gui.beastiary.BeastiaryScreen;
import com.lycanitesmobs.client.gui.widgets.BaseList;
import com.lycanitesmobs.client.gui.widgets.BaseListEntry;
import com.lycanitesmobs.core.info.ElementInfo;
import net.minecraft.client.gui.widget.list.AbstractList;
import net.minecraft.potion.Effect;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class ElementDescriptionList
extends BaseList {
    public ElementInfo elementInfo;

    public ElementDescriptionList(BeastiaryScreen parentGui, int width, int height, int top, int bottom, int x) {
        super(parentGui, width, height, top, bottom, x, 500);
    }

    @Override
    public void createEntries() {
        this.addEntry((AbstractList.AbstractListEntry)new Entry(this));
    }

    public String getContent() {
        ResourceLocation effectResource;
        Effect effect;
        if (this.elementInfo == null) {
            return "";
        }
        ITextComponent text = new StringTextComponent("\u00a7l").func_150257_a(this.elementInfo.getTitle()).func_150258_a(": \u00a7r\n").func_150257_a(this.elementInfo.getDescription());
        text.func_150258_a("\n\n\u00a7l").func_150257_a((ITextComponent)new TranslationTextComponent("gui.beastiary.elements.buffs", new Object[0])).func_150258_a(": \u00a7r");
        for (String buff : this.elementInfo.buffs) {
            effect = (Effect)GameRegistry.findRegistry(Effect.class).getValue(new ResourceLocation(buff));
            if (effect == null) continue;
            effectResource = new ResourceLocation(buff);
            text.func_150258_a("\n").func_150257_a(effect.func_199286_c()).func_150258_a(": ").func_150257_a((ITextComponent)new TranslationTextComponent("effect." + effectResource.func_110623_a() + ".description", new Object[0]));
        }
        text.func_150258_a("\n\n\u00a7l").func_150257_a((ITextComponent)new TranslationTextComponent("gui.beastiary.elements.debuffs", new Object[0])).func_150258_a(": \u00a7r");
        for (String debuff : this.elementInfo.debuffs) {
            if ("burning".equals(debuff)) {
                text.func_150258_a("\n").func_150257_a((ITextComponent)new TranslationTextComponent("effect.burning", new Object[0])).func_150258_a(": ").func_150257_a((ITextComponent)new TranslationTextComponent("effect.burning.description", new Object[0]));
                continue;
            }
            effect = (Effect)GameRegistry.findRegistry(Effect.class).getValue(new ResourceLocation(debuff));
            if (effect == null) continue;
            effectResource = new ResourceLocation(debuff);
            text.func_150258_a("\n").func_150257_a(effect.func_199286_c()).func_150258_a(": ").func_150257_a((ITextComponent)new TranslationTextComponent("effect." + effectResource.func_110623_a() + ".description", new Object[0]));
        }
        return text.func_150254_d();
    }

    public static class Entry
    extends BaseListEntry {
        private ElementDescriptionList parentList;

        public Entry(ElementDescriptionList parentList) {
            this.parentList = parentList;
        }

        @Override
        public void render(int index, int top, int left, int bottom, int right, int mouseX, int mouseY, boolean focus, float partialTicks) {
            if (index == 0) {
                this.drawSplitString(this.parentList.getContent(), left + 6, top, this.parentList.getWidth() - 20, 0xFFFFFF, true);
            }
        }

        @Override
        protected void onClicked() {
        }
    }
}

