/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui.beastiary.lists;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.client.TextureManager;
import com.lycanitesmobs.client.gui.beastiary.BeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.lists.CreatureFilterList;
import com.lycanitesmobs.client.gui.widgets.BaseList;
import com.lycanitesmobs.client.gui.widgets.BaseListEntry;
import com.lycanitesmobs.core.info.CreatureInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.network.MessageSummonSetSelection;
import com.lycanitesmobs.core.pets.PetEntry;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Locale;
import javax.annotation.Nullable;
import net.minecraft.client.gui.widget.list.AbstractList;

public class CreatureList
extends BaseList<BeastiaryScreen> {
    private Type listType;
    private CreatureFilterList filterList;
    private boolean releaseRefresh;

    public CreatureList(Type listType, BeastiaryScreen screen, CreatureFilterList filterList, int width, int height, int top, int bottom, int x) {
        super(screen, width, height, top, bottom, x, 24);
        this.listType = listType;
        this.filterList = filterList;
        if (this.filterList != null) {
            this.filterList.addFilteredList(this);
        }
        this.refreshList();
    }

    public void refreshList() {
        this.replaceEntries(new ArrayList());
        int creatureIndex = 0;
        if (this.listType == Type.KNOWLEDGE || this.listType == Type.SUMMONABLE) {
            ArrayList<String> creatures = new ArrayList<String>(((BeastiaryScreen)((Object)this.screen)).playerExt.getBeastiary().creatureKnowledgeList.keySet());
            creatures.sort(Collator.getInstance(new Locale("US")));
            for (String creatureName : creatures) {
                CreatureInfo creatureInfo = CreatureManager.getInstance().getCreature(creatureName.toLowerCase());
                if (this.listType == Type.SUMMONABLE && !creatureInfo.isSummonable() || creatureInfo == null || this.filterList != null && !this.filterList.canListCreature(creatureInfo, this.listType)) continue;
                this.addEntry((AbstractList.AbstractListEntry)new Entry(this, creatureIndex++, creatureInfo));
            }
            return;
        }
        if (this.listType == Type.PET || this.listType == Type.MOUNT || this.listType == Type.FAMILIAR) {
            String petType = "pet";
            if (this.listType == Type.MOUNT) {
                petType = "mount";
            } else if (this.listType == Type.FAMILIAR) {
                petType = "familiar";
            }
            ArrayList<PetEntry> creatures = new ArrayList<PetEntry>();
            creatures.addAll(((BeastiaryScreen)((Object)this.screen)).playerExt.petManager.getEntryList(petType));
            creatures.sort(Comparator.comparing(PetEntry::getName));
            for (PetEntry petEntry : creatures) {
                CreatureInfo creatureInfo = petEntry.getCreatureInfo();
                if (creatureInfo == null || this.filterList != null && !this.filterList.canListCreature(creatureInfo, this.listType)) continue;
                this.addEntry((AbstractList.AbstractListEntry)new Entry(this, creatureIndex++, petEntry));
            }
        }
    }

    public void changeType(Type listType) {
        this.listType = listType;
        this.refreshList();
    }

    public void setSelected(@Nullable BaseListEntry entry) {
        super.setSelected((AbstractList.AbstractListEntry)entry);
        if (!(entry instanceof Entry)) {
            return;
        }
        Entry creatureEntry = (Entry)entry;
        if (this.listType == Type.KNOWLEDGE) {
            ((BeastiaryScreen)((Object)this.screen)).playerExt.selectedCreature = creatureEntry.creatureInfo;
            ((BeastiaryScreen)((Object)this.screen)).playerExt.selectedSubspecies = 0;
        } else if (this.listType == Type.SUMMONABLE) {
            ((BeastiaryScreen)((Object)this.screen)).playerExt.getSelectedSummonSet().setSummonType(creatureEntry.creatureInfo.getName());
            int subspeciesId = ((BeastiaryScreen)((Object)this.screen)).playerExt.getSelectedSummonSet().getSubspecies();
            if (!((BeastiaryScreen)((Object)this.screen)).playerExt.getBeastiary().hasKnowledgeRank(creatureEntry.creatureInfo.getName(), 2)) {
                subspeciesId = 0;
            }
            ((BeastiaryScreen)((Object)this.screen)).playerExt.getSelectedSummonSet().setSubspecies(subspeciesId);
            ((BeastiaryScreen)((Object)this.screen)).playerExt.sendSummonSetToServer((byte)((BeastiaryScreen)((Object)this.screen)).playerExt.selectedSummonSet);
            MessageSummonSetSelection message = new MessageSummonSetSelection(((BeastiaryScreen)((Object)this.screen)).playerExt);
            LycanitesMobs.packetHandler.sendToServer(message);
        } else if (this.listType == Type.PET || this.listType == Type.MOUNT || this.listType == Type.FAMILIAR) {
            ((BeastiaryScreen)((Object)this.screen)).playerExt.selectedPet = creatureEntry.petEntry;
        }
    }

    protected boolean isSelectedItem(int index) {
        if (!(this.getEntry(index) instanceof Entry)) {
            return false;
        }
        Entry creatureEntry = (Entry)this.getEntry(index);
        if (this.listType == Type.KNOWLEDGE) {
            return ((BeastiaryScreen)((Object)this.screen)).playerExt.selectedCreature != null && ((BeastiaryScreen)((Object)this.screen)).playerExt.selectedCreature.equals(creatureEntry.creatureInfo);
        }
        if (this.listType == Type.SUMMONABLE) {
            return ((BeastiaryScreen)((Object)this.screen)).playerExt.getSelectedSummonSet().getCreatureInfo() != null && ((BeastiaryScreen)((Object)this.screen)).playerExt.getSelectedSummonSet().getCreatureInfo().equals(creatureEntry.creatureInfo);
        }
        if (this.listType == Type.PET || this.listType == Type.MOUNT || this.listType == Type.FAMILIAR) {
            return ((BeastiaryScreen)((Object)this.screen)).playerExt.selectedPet != null && ((BeastiaryScreen)((Object)this.screen)).playerExt.selectedPet.equals(creatureEntry.petEntry);
        }
        return false;
    }

    protected void renderBackground() {
        if ((this.listType == Type.PET || this.listType == Type.MOUNT || this.listType == Type.FAMILIAR) && ((BeastiaryScreen)((Object)this.screen)).playerExt.selectedPet != null && this.releaseRefresh != ((BeastiaryScreen)((Object)this.screen)).playerExt.selectedPet.releaseEntity) {
            this.releaseRefresh = ((BeastiaryScreen)((Object)this.screen)).playerExt.selectedPet.releaseEntity;
            this.refreshList();
        }
    }

    public static class Entry
    extends BaseListEntry {
        private CreatureList parentList;
        public CreatureInfo creatureInfo;
        public PetEntry petEntry;

        public Entry(CreatureList parentList, int index, CreatureInfo creatureInfo) {
            this.parentList = parentList;
            this.index = index;
            this.creatureInfo = creatureInfo;
        }

        public Entry(CreatureList parentList, int index, PetEntry petEntry) {
            this.parentList = parentList;
            this.index = index;
            this.petEntry = petEntry;
        }

        @Override
        public void render(int index, int top, int left, int bottom, int right, int mouseX, int mouseY, boolean focus, float partialTicks) {
            if (this.parentList.listType == Type.KNOWLEDGE || this.parentList.listType == Type.SUMMONABLE) {
                if (this.creatureInfo == null) {
                    return;
                }
                int nameY = top + 6;
                if (this.parentList.listType == Type.SUMMONABLE) {
                    nameY = top + 2;
                }
                ((BeastiaryScreen)((Object)this.parentList.screen)).getFontRenderer().func_211126_b(this.creatureInfo.getTitle().func_150254_d(), (float)(left + 20), (float)nameY, 0xFFFFFF);
                if (this.parentList.listType == Type.SUMMONABLE) {
                    ((BeastiaryScreen)((Object)this.parentList.screen)).drawLevel(this.creatureInfo, TextureManager.getTexture("GUIPetLevel"), left + 18, top + 10);
                }
                if (this.creatureInfo.getIcon() != null) {
                    ((BeastiaryScreen)((Object)this.parentList.screen)).drawTexture(this.creatureInfo.getIcon(), left + 2, top + 2, 0.0f, 1.0f, 1.0f, 16.0f, 16.0f);
                }
            } else {
                if (this.petEntry == null) {
                    return;
                }
                int nameY = top + 6;
                if (this.parentList.listType == Type.PET || this.parentList.listType == Type.MOUNT) {
                    nameY = top + 2;
                }
                ((BeastiaryScreen)((Object)this.parentList.screen)).getFontRenderer().func_211126_b(this.petEntry.getDisplayName().func_150254_d(), (float)(left + 20), (float)nameY, 0xFFFFFF);
                if (this.parentList.listType == Type.PET || this.parentList.listType == Type.MOUNT) {
                    ((BeastiaryScreen)((Object)this.parentList.screen)).drawLevel(this.petEntry.getCreatureInfo(), TextureManager.getTexture("GUIPetLevel"), left + 18, top + 10);
                }
                if (this.petEntry.getCreatureInfo().getIcon() != null) {
                    ((BeastiaryScreen)((Object)this.parentList.screen)).drawTexture(this.petEntry.getCreatureInfo().getIcon(), left + 2, top + 2, 0.0f, 1.0f, 1.0f, 16.0f, 16.0f);
                }
            }
        }

        @Override
        protected void onClicked() {
            this.parentList.setSelected(this);
        }
    }

    public static enum Type {
        KNOWLEDGE(0),
        SUMMONABLE(1),
        PET(2),
        MOUNT(3),
        FAMILIAR(4);

        public byte id;

        private Type(byte i) {
            this.id = i;
        }
    }
}

