/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui.beastiary;

import com.lycanitesmobs.client.gui.beastiary.BeastiaryScreen;
import com.lycanitesmobs.client.gui.beastiary.lists.BeastiaryIndexList;
import com.lycanitesmobs.client.gui.buttons.ButtonBase;
import com.lycanitesmobs.core.VersionChecker;
import java.net.URI;
import java.net.URISyntaxException;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public class IndexBeastiaryScreen
extends BeastiaryScreen {
    public BeastiaryIndexList indexList;
    VersionChecker.VersionInfo versionInfo = VersionChecker.getLatestVersion(false);

    public IndexBeastiaryScreen(PlayerEntity player) {
        super(player);
    }

    @Override
    protected void initWidgets() {
        super.initWidgets();
        int menuWidth = this.colRightWidth;
        int buttonCount = 4;
        int buttonPadding = 2;
        int buttonWidth = Math.round(menuWidth / buttonCount) - buttonPadding;
        int buttonWidthPadded = buttonWidth + buttonPadding;
        int buttonHeight = 20;
        int buttonX = this.colRightX + buttonPadding;
        int buttonY = this.colRightY + this.colRightHeight - buttonHeight;
        ButtonBase button = new ButtonBase(100, buttonX, buttonY, buttonWidth, buttonHeight, "Website", this);
        this.addButton((Widget)button);
        button = new ButtonBase(101, buttonX + buttonWidthPadded, buttonY, buttonWidth, buttonHeight, "Twitter", this);
        this.addButton((Widget)button);
        button = new ButtonBase(102, buttonX + buttonWidthPadded * 2, buttonY, buttonWidth, buttonHeight, "Patreon", this);
        this.addButton((Widget)button);
        button = new ButtonBase(103, buttonX + buttonWidthPadded * 3, buttonY, buttonWidth, buttonHeight, "Discord", this);
        this.addButton((Widget)button);
        if (this.versionInfo != null) {
            this.indexList = new BeastiaryIndexList(this, this.colRightWidth, this.colRightHeight, this.colRightY + 93, buttonY - buttonPadding, this.colRightX + 2, this.versionInfo);
            this.children.add(this.indexList);
        }
    }

    @Override
    public void renderBackground(int mouseX, int mouseY, float partialTicks) {
        super.renderBackground(mouseX, mouseY, partialTicks);
    }

    @Override
    public void renderWidgets(int mouseX, int mouseY, float partialTicks) {
        super.renderWidgets(mouseX, mouseY, partialTicks);
        if (this.indexList != null) {
            this.indexList.render(mouseX, mouseY, partialTicks);
        }
    }

    @Override
    public void renderForeground(int mouseX, int mouseY, float partialTicks) {
        super.renderForeground(mouseX, mouseY, partialTicks);
        int yOffset = this.colRightY + 13;
        String info = new TranslationTextComponent("gui.beastiary.index.description", new Object[0]).func_150254_d();
        this.drawSplitString(info, this.colRightX + 1, yOffset, this.colRightWidth, 0xFFFFFF, true);
        yOffset += this.getFontRenderer().func_78267_b(info, this.colRightWidth);
        if (this.versionInfo == null) {
            return;
        }
        String version = "\n\u00a7l" + new TranslationTextComponent("gui.beastiary.index.version", new Object[0]).func_150254_d() + ": \u00a7r";
        if (this.versionInfo.isNewer) {
            version = version + "\u00a74";
        }
        version = version + "2.2.0.0\u00a7r";
        if (this.versionInfo.isNewer) {
            version = version + " \u00a7l" + new TranslationTextComponent("gui.beastiary.index.version.newer", new Object[0]).func_150254_d() + ": \u00a7r\u00a72" + this.versionInfo.versionNumber + "\u00a7r";
        }
        this.drawSplitString(version, this.colRightX + 1, yOffset, this.colRightWidth, 0xFFFFFF, true);
    }

    @Override
    public void actionPerformed(int buttonId) {
        if (buttonId == 100) {
            try {
                this.openURI(new URI("http://lycanitesmobs.com"));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (buttonId == 101) {
            try {
                this.openURI(new URI("https://twitter.com/Lycanite05"));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (buttonId == 102) {
            try {
                this.openURI(new URI("https://www.patreon.com/lycanite"));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        if (buttonId == 103) {
            try {
                this.openURI(new URI("https://discord.gg/bFpV3z4"));
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        super.actionPerformed(buttonId);
    }

    @Override
    public ITextComponent getTitle() {
        return new TranslationTextComponent("gui.beastiary.index.title", new Object[0]);
    }
}

