/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui;

import com.lycanitesmobs.client.TextureManager;
import com.lycanitesmobs.client.gui.BaseContainerScreen;
import com.lycanitesmobs.client.gui.buttons.ButtonBase;
import com.lycanitesmobs.client.gui.buttons.MainTab;
import com.lycanitesmobs.client.gui.widgets.SummoningPedestalList;
import com.lycanitesmobs.core.container.SummoningPedestalContainer;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.pets.SummonSet;
import com.lycanitesmobs.core.tileentity.TileEntitySummoningPedestal;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.list.ExtendedList;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.lwjgl.opengl.GL11;

public class SummoningPedestalScreen
extends BaseContainerScreen<SummoningPedestalContainer> {
    public PlayerEntity player;
    public ExtendedPlayer playerExt;
    public TileEntitySummoningPedestal summoningPedestal;
    public SummonSet summonSet;
    public ExtendedList list;
    public int centerX;
    public int centerY;
    public int windowWidth;
    public int windowHeight;
    public int halfX;
    public int halfY;
    public int windowX;
    public int windowY;
    public static int TAB_BUTTON_ID = 55555;

    public SummoningPedestalScreen(SummoningPedestalContainer container, PlayerInventory playerInventory, ITextComponent name) {
        super(container, playerInventory, name);
        this.summoningPedestal = container.summoningPedestal;
        this.player = playerInventory.field_70458_d;
        this.playerExt = ExtendedPlayer.getForPlayer(this.player);
        this.summonSet = this.summoningPedestal.summonSet;
    }

    public boolean isPauseScreen() {
        return false;
    }

    @Override
    public void init() {
        super.init();
        this.buttons.clear();
        this.windowWidth = 256;
        this.windowHeight = 166;
        this.halfX = this.windowWidth / 2;
        this.halfY = this.windowHeight / 2;
        this.windowX = this.width / 2 - this.windowWidth / 2;
        this.windowY = this.height / 2 - this.windowHeight / 2;
        this.centerX = this.windowX + this.windowWidth / 2;
        this.centerY = this.windowY + this.windowHeight / 2;
    }

    @Override
    protected void initWidgets() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int buttonSpacing = 2;
        int buttonWidth = this.windowWidth / 4 - buttonSpacing * 2;
        int buttonHeight = 20;
        int buttonX = this.windowX + 6;
        int buttonY = this.windowY;
        buttonX = this.centerX + buttonSpacing;
        int buttonXRight = buttonX + buttonWidth + buttonSpacing;
        buttonY = this.windowY + 39 + buttonSpacing;
        this.addButton((Widget)new ButtonBase(BaseCreatureEntity.GUI_COMMAND.SITTING.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth * 2, buttonHeight, "...", this));
        this.addButton((Widget)new ButtonBase(BaseCreatureEntity.GUI_COMMAND.PASSIVE.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth, buttonHeight, "...", this));
        this.addButton((Widget)new ButtonBase(BaseCreatureEntity.GUI_COMMAND.STANCE.id, buttonXRight, buttonY, buttonWidth, buttonHeight, "...", this));
        this.addButton((Widget)new ButtonBase(BaseCreatureEntity.GUI_COMMAND.PVP.id, buttonX, buttonY += buttonHeight + buttonSpacing * 2, buttonWidth * 2, buttonHeight, "...", this));
        if (this.hasPets() && this.summoningPedestal.summonSet != null) {
            this.selectMinion(this.summoningPedestal.summonSet.summonType);
        }
        int listWidth = this.windowWidth / 2 - buttonSpacing * 4;
        int listHeight = this.windowHeight - (39 + buttonSpacing) - 16;
        int listTop = this.windowY + 39 + buttonSpacing;
        int listBottom = listTop + listHeight;
        int listX = this.windowX + buttonSpacing * 2;
        this.list = new SummoningPedestalList(this, this.playerExt, listWidth, listHeight, listTop, listBottom, listX);
        this.children.add(this.list);
    }

    @Override
    protected void renderBackground(int mouseX, int mouseY, float partialTicks) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getTexture());
        this.drawTexturedModalRect(this.windowX, this.windowY, 0, 0, this.windowWidth, this.windowHeight);
        this.drawTexturedModalRect(this.windowX + 40, this.windowY + this.windowHeight, 40, 224, this.windowWidth - 80, 29);
        if (!this.hasPets()) {
            int recipeWidth = 108;
            int recipeHeight = 54;
            this.drawTexturedModalRect(this.centerX - recipeWidth / 2, this.windowY + this.windowHeight - recipeHeight - 16, 0, 256 - recipeHeight, recipeWidth, recipeHeight);
            return;
        }
        this.drawFuel();
        this.drawCapacityBar();
        this.drawProgressBar();
    }

    @Override
    public void renderWidgets(int mouseX, int mouseY, float partialTicks) {
        for (Object buttonObj : this.buttons) {
            if (!(buttonObj instanceof ButtonBase)) continue;
            ButtonBase button = (ButtonBase)((Object)buttonObj);
            if (button instanceof MainTab) {
                button.active = true;
                button.visible = true;
                continue;
            }
            if (!this.hasSelectedPet()) {
                button.active = false;
                button.visible = false;
                continue;
            }
            if (button.buttonId == BaseCreatureEntity.GUI_COMMAND.SITTING.id) {
                button.setMessage(new TranslationTextComponent("gui.pet.sit", new Object[0]).func_150254_d() + ": " + (this.summonSet.getSitting() ? new TranslationTextComponent("common.yes", new Object[0]).func_150254_d() : new TranslationTextComponent("common.no", new Object[0]).func_150254_d()));
            }
            if (button.buttonId == BaseCreatureEntity.GUI_COMMAND.PASSIVE.id) {
                button.setMessage(new TranslationTextComponent("gui.pet.passive", new Object[0]).func_150254_d() + ": " + (this.summonSet.getPassive() ? new TranslationTextComponent("common.yes", new Object[0]).func_150254_d() : new TranslationTextComponent("common.no", new Object[0]).func_150254_d()));
            }
            if (button.buttonId == BaseCreatureEntity.GUI_COMMAND.STANCE.id) {
                button.setMessage(this.summonSet.getAggressive() ? new TranslationTextComponent("gui.pet.aggressive", new Object[0]).func_150254_d() : new TranslationTextComponent("gui.pet.defensive", new Object[0]).func_150254_d());
            }
            if (button.buttonId != BaseCreatureEntity.GUI_COMMAND.PVP.id) continue;
            button.setMessage(new TranslationTextComponent("gui.pet.pvp", new Object[0]).func_150254_d() + ": " + (this.summonSet.getPVP() ? new TranslationTextComponent("common.yes", new Object[0]).func_150254_d() : new TranslationTextComponent("common.no", new Object[0]).func_150254_d()));
        }
        if (this.hasPets()) {
            this.list.render(mouseX, mouseY, partialTicks);
        }
        super.renderWidgets(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void renderForeground(int mouseX, int mouseY, float partialTicks) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Minecraft.func_71410_x().func_110434_K().func_110577_a(this.getTexture());
        if (!this.hasPets()) {
            this.getFontRenderer().func_211126_b(new TranslationTextComponent("gui.beastiary.summoning.empty.title", new Object[0]).func_150254_d(), (float)(this.centerX - 96), (float)(this.windowY + 6), 0xFFFFFF);
            this.getFontRenderer().func_78279_b(new TranslationTextComponent("gui.beastiary.summoning.empty.info", new Object[0]).func_150254_d(), this.windowX + 16, this.windowY + 30, this.windowWidth - 32, 0xFFFFFF);
            return;
        }
        this.getFontRenderer().func_211126_b(this.getTitle().func_150254_d(), (float)(this.centerX - 24), (float)(this.windowY + 6), 0xFFFFFF);
        this.getFontRenderer().func_211126_b(this.getEnergyTitle().func_150254_d(), (float)(this.windowX + 16), (float)(this.windowY + 20), 0xFFFFFF);
    }

    @Override
    public void actionPerformed(int buttonId) {
        if (!this.hasSelectedPet()) {
            return;
        }
        if (buttonId == BaseCreatureEntity.GUI_COMMAND.SITTING.id) {
            boolean bl = this.summonSet.sitting = !this.summonSet.sitting;
        }
        if (buttonId == BaseCreatureEntity.GUI_COMMAND.FOLLOWING.id) {
            boolean bl = this.summonSet.following = !this.summonSet.following;
        }
        if (buttonId == BaseCreatureEntity.GUI_COMMAND.PASSIVE.id) {
            boolean bl = this.summonSet.passive = !this.summonSet.passive;
        }
        if (buttonId == BaseCreatureEntity.GUI_COMMAND.STANCE.id) {
            boolean bl = this.summonSet.aggressive = !this.summonSet.aggressive;
        }
        if (buttonId == BaseCreatureEntity.GUI_COMMAND.PVP.id) {
            boolean bl = this.summonSet.pvp = !this.summonSet.pvp;
        }
        if (buttonId < 100) {
            this.sendCommandsToServer();
        }
    }

    public ITextComponent getTitle() {
        return new TranslationTextComponent("gui.summoningpedestal", new Object[0]);
    }

    public ITextComponent getEnergyTitle() {
        return new TranslationTextComponent("stat.portal", new Object[0]);
    }

    public void drawFuel() {
        int fuelX = this.windowX + 132;
        int fuelY = this.windowY + 42;
        this.drawTexturedModalRect(fuelX, fuelY, 47, 170, 18, 18);
        int barWidth = 38;
        int barHeight = 11;
        int barX = fuelX + 22;
        int barY = fuelY + 3;
        int barU = 218;
        int barV = 225;
        this.drawTexturedModalRect(barX, barY, barU, barV + barHeight, barWidth, barHeight);
        barWidth = Math.round((float)barWidth * ((float)this.summoningPedestal.summoningFuel / (float)this.summoningPedestal.summoningFuelMax));
        this.drawTexturedModalRect(barX, barY, barU, barV, barWidth, barHeight);
    }

    public void drawCapacityBar() {
        int energyBarWidth = 9;
        int energyBarHeight = 9;
        int energyBarX = this.windowX + 16;
        int energyBarY = this.windowY + 40 - energyBarHeight;
        this.drawBar(TextureManager.getTexture("GUIPetSpiritEmpty"), energyBarX, energyBarY, 0.0f, energyBarWidth, energyBarHeight, 10, 10);
        this.drawBar(TextureManager.getTexture("GUIPetSpirit"), energyBarX, energyBarY, 0.0f, energyBarWidth, energyBarHeight, this.summoningPedestal.capacity / this.summoningPedestal.capacityCharge, 10);
    }

    public void drawProgressBar() {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        int barWidth = 80;
        int barHeight = 10;
        int barX = this.centerX + 2;
        int barY = this.windowY + 26;
        this.drawTexture(TextureManager.getTexture("GUIPetBarEmpty"), barX, barY, 0.0f, 1.0f, 1.0f, barWidth, barHeight);
        float respawnNormal = (float)this.summoningPedestal.summonProgress / (float)this.summoningPedestal.summonProgressMax;
        this.drawTexture(TextureManager.getTexture("GUIPetBarRespawn"), barX, barY, 0.0f, respawnNormal, 1.0f, (float)barWidth * respawnNormal, barHeight);
    }

    public void sendCommandsToServer() {
        this.summoningPedestal.sendSummonSetToServer(this.summonSet);
    }

    public void selectMinion(String minionName) {
        if (this.summonSet == null) {
            if (this.summoningPedestal.summonSet == null) {
                this.summoningPedestal.summonSet = new SummonSet(this.playerExt);
                this.summoningPedestal.sendSummonSetToServer(this.summoningPedestal.summonSet);
            }
            this.summonSet = this.summoningPedestal.summonSet;
        }
        this.summonSet.setSummonType(minionName);
        this.sendCommandsToServer();
    }

    public String getSelectedMinionName() {
        if (this.summonSet == null) {
            return null;
        }
        return this.summonSet.summonType;
    }

    public boolean hasPets() {
        return this.playerExt.getBeastiary().getSummonableList().size() > 0;
    }

    public boolean hasSelectedPet() {
        return this.hasPets() && this.summonSet != null && !this.summonSet.summonType.equals("");
    }

    protected ResourceLocation getTexture() {
        return TextureManager.getTexture("GUISummoningPedestal");
    }
}

