/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.client.gui;

import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.client.gui.buttons.ButtonBase;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.inventory.ContainerScreen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;

public abstract class BaseContainerScreen<T extends Container>
extends ContainerScreen<T>
implements Button.IPressable {
    public int zLevel = 0;
    public FontRenderer fontRenderer;

    public BaseContainerScreen(T container, PlayerInventory playerInventory, ITextComponent name) {
        super(container, playerInventory, name);
        this.fontRenderer = Minecraft.func_71410_x().field_71466_p;
    }

    public void init(Minecraft minecraft, int width, int height) {
        this.minecraft = minecraft;
        super.init(minecraft, width, height);
        this.initWidgets();
    }

    protected void init() {
        super.init();
    }

    protected abstract void initWidgets();

    public void render(int mouseX, int mouseY, float partialTicks) {
        this.renderBackground(mouseX, mouseY, partialTicks);
        this.renderWidgets(mouseX, mouseY, partialTicks);
        super.render(mouseX, mouseY, partialTicks);
        this.renderForeground(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected abstract void renderBackground(int var1, int var2, float var3);

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
    }

    protected void renderWidgets(int mouseX, int mouseY, float partialTicks) {
        for (int i = 0; i < this.buttons.size(); ++i) {
            ((Widget)this.buttons.get(i)).render(mouseX, mouseY, partialTicks);
        }
    }

    protected abstract void renderForeground(int var1, int var2, float var3);

    public void onPress(Button guiButton) {
        if (!(guiButton instanceof ButtonBase)) {
            return;
        }
        this.actionPerformed(((ButtonBase)guiButton).buttonId);
    }

    public abstract void actionPerformed(int var1);

    public FontRenderer getFontRenderer() {
        return ClientManager.getInstance().getFontRenderer();
    }

    public void drawBar(ResourceLocation texture, int x, int y, float z, float width, float height, int segments, int segmentLimit) {
        boolean reverse;
        boolean bl = reverse = segmentLimit < 0;
        if (reverse) {
            segmentLimit = -segmentLimit;
        }
        for (int i = 0; i < segments; ++i) {
            int currentSegment = i;
            if (reverse) {
                currentSegment = segmentLimit - i - 1;
            }
            this.drawTexture(texture, (float)x + width * (float)currentSegment, y, z, 1.0f, 1.0f, width, height);
        }
    }

    public void drawTexture(ResourceLocation texture, float x, float y, float z, float u, float v, float width, float height) {
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.depthMask((boolean)false);
        RenderSystem.blendFunc((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.disableAlphaTest();
        this.getMinecraft().func_110434_K().func_110577_a(texture);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder buffer = tessellator.func_178180_c();
        buffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        buffer.func_225582_a_((double)x, (double)(y + height), (double)z).func_225583_a_(0.0f, v).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)(y + height), (double)z).func_225583_a_(u, v).func_181675_d();
        buffer.func_225582_a_((double)(x + width), (double)y, (double)z).func_225583_a_(u, 0.0f).func_181675_d();
        buffer.func_225582_a_((double)x, (double)y, (double)z).func_225583_a_(0.0f, 0.0f).func_181675_d();
        tessellator.func_78381_a();
        RenderSystem.enableAlphaTest();
        RenderSystem.depthMask((boolean)true);
        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height) {
        this.drawTexturedModalRect(x, y, u, v, width, height, 1);
    }

    public void drawTexturedModalRect(int x, int y, int u, int v, int width, int height, int resolution) {
        float scaleX;
        float scaleY = scaleX = 0.00390625f * (float)resolution;
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        bufferBuilder.func_225582_a_((double)(x + 0), (double)(y + height), (double)this.zLevel).func_225583_a_((float)(u + 0) * scaleX, (float)(v + height) * scaleY).func_181675_d();
        bufferBuilder.func_225582_a_((double)(x + width), (double)(y + height), (double)this.zLevel).func_225583_a_((float)(u + width) * scaleX, (float)(v + height) * scaleY).func_181675_d();
        bufferBuilder.func_225582_a_((double)(x + width), (double)(y + 0), (double)this.zLevel).func_225583_a_((float)(u + width) * scaleX, (float)(v + 0) * scaleY).func_181675_d();
        bufferBuilder.func_225582_a_((double)(x + 0), (double)(y + 0), (double)this.zLevel).func_225583_a_((float)(u + 0) * scaleX, (float)(v + 0) * scaleY).func_181675_d();
        tessellator.func_78381_a();
    }
}

