/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import java.time.temporal.ChronoUnit;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceContext;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;

public class Utilities {
    protected static Calendar easterCalendar;

    public static RayTraceResult raytrace(World world, double x, double y, double z, double tx, double ty, double tz, float borderSize, Entity entity, HashSet<Entity> excluded) {
        Vec3d startVec = new Vec3d(x, y, z);
        Vec3d lookVec = new Vec3d(tx - x, ty - y, tz - z);
        Vec3d endVec = new Vec3d(tx, ty, tz);
        float minX = (float)(x < tx ? x : tx);
        float minY = (float)(y < ty ? y : ty);
        float minZ = (float)(z < tz ? z : tz);
        float maxX = (float)(x > tx ? x : tx);
        float maxY = (float)(y > ty ? y : ty);
        float maxZ = (float)(z > tz ? z : tz);
        BlockRayTraceResult collision = world.func_217299_a(new RayTraceContext(startVec, endVec, RayTraceContext.BlockMode.COLLIDER, RayTraceContext.FluidMode.NONE, entity));
        startVec = new Vec3d(x, y, z);
        if (excluded != null) {
            AxisAlignedBB bb = new AxisAlignedBB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).func_72321_a((double)borderSize, (double)borderSize, (double)borderSize);
            List allHitEntities = world.func_72839_b(null, bb);
            Entity closestHitEntity = null;
            double closestEntDistance = Double.POSITIVE_INFINITY;
            for (Entity hitEntity : allHitEntities) {
                double entDistance;
                if (!hitEntity.func_70067_L() || excluded.contains(hitEntity) || !((entDistance = startVec.func_72438_d(hitEntity.func_213303_ch())) < closestEntDistance)) continue;
                closestEntDistance = entDistance;
                closestHitEntity = hitEntity;
            }
            if (closestHitEntity != null) {
                collision = new EntityRayTraceResult(closestHitEntity);
            }
        }
        return collision;
    }

    public static boolean isValentines() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 1 && calendar.get(5) >= 7 && calendar.get(5) <= 14;
    }

    public static boolean isEaster() {
        long daysUntilEaster;
        Calendar calendar = Calendar.getInstance();
        if (easterCalendar == null) {
            int Y = calendar.get(1);
            int a = Y % 19;
            int b = Y / 100;
            int c = Y % 100;
            int d = b / 4;
            int e = b % 4;
            int f = (b + 8) / 25;
            int g = (b - f + 1) / 3;
            int h = (19 * a + b - d - g + 15) % 30;
            int i = c / 4;
            int k = c % 4;
            int L = (32 + 2 * e + 2 * i - h - k) % 7;
            int m = (a + 11 * h + 22 * L) / 451;
            int easterMonth = (h + L - 7 * m + 114) / 31;
            int easterDay = (h + L - 7 * m + 114) % 31 + 1;
            easterCalendar = new GregorianCalendar(Y, easterMonth, easterDay);
        }
        return (daysUntilEaster = ChronoUnit.DAYS.between(calendar.toInstant(), easterCalendar.toInstant())) <= 7L && daysUntilEaster >= 0L;
    }

    public static boolean isMidsummer() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 6 && calendar.get(5) >= 10 && calendar.get(5) <= 20;
    }

    public static boolean isHalloween() {
        block4: {
            block3: {
                Calendar calendar;
                block2: {
                    calendar = Calendar.getInstance();
                    if (calendar.get(5) < 25) break block2;
                    if (calendar.get(2) == 9) break block3;
                }
                if (calendar.get(5) != 1) break block4;
                if (calendar.get(2) != 10) break block4;
            }
            return true;
        }
        return false;
    }

    public static boolean isYuletide() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 11 && calendar.get(5) >= 10 && calendar.get(5) <= 25;
    }

    public static boolean isYuletidePeak() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 11 && calendar.get(5) == 25;
    }

    public static boolean isNewYear() {
        Calendar calendar = Calendar.getInstance();
        return calendar.get(2) == 0 && calendar.get(5) == 1;
    }

    public static int daysBetween(Date d1, Date d2) {
        return (int)((d2.getTime() - d1.getTime()) / 86400000L);
    }
}

