/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.core.EffectBase;
import com.lycanitesmobs.core.container.CreatureContainer;
import com.lycanitesmobs.core.container.EquipmentForgeContainer;
import com.lycanitesmobs.core.container.SummoningPedestalContainer;
import com.lycanitesmobs.core.entity.EntityFactory;
import com.lycanitesmobs.core.info.ItemManager;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.tileentity.TileEntityEquipmentForge;
import com.lycanitesmobs.core.tileentity.TileEntitySummoningPedestal;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntityType;
import net.minecraft.fluid.FlowingFluid;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.potion.Effect;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ObjectManager {
    public static ObjectManager INSTANCE;
    public static Map<String, Block> blocks;
    public static Map<String, Item> items;
    public static Map<Item, ModInfo> itemGroups;
    public static Map<String, RegistryObject<FlowingFluid>> fluids;
    public static Map<Block, Item> buckets;
    public static Map<String, Class> tileEntities;
    public static Map<String, EffectBase> effects;
    public static Map<String, SoundEvent> sounds;
    public static Map<String, Class<? extends Entity>> specialEntities;
    public static Map<Class<? extends Entity>, Constructor<? extends Entity>> specialEntityConstructors;
    public static Map<Class<? extends Entity>, EntityType<? extends Entity>> specialEntityTypes;
    public static Map<Class<? extends TileEntity>, TileEntityType<? extends TileEntity>> tileEntityTypes;
    public static Map<String, DamageSource> damageSources;
    public static ModInfo currentModInfo;
    protected static int nextSpecialEntityNetworkId;

    public static ObjectManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ObjectManager();
        }
        return INSTANCE;
    }

    public static void setCurrentModInfo(ModInfo group) {
        currentModInfo = group;
    }

    public static int getNextSpecialEntityNetworkId() {
        return nextSpecialEntityNetworkId++;
    }

    public static Block addBlock(String name, Block block) {
        blocks.put(name, block);
        return block;
    }

    public static RegistryObject<FlowingFluid> addFluid(String name, RegistryObject<FlowingFluid> fluid) {
        fluids.put(name, fluid);
        return fluid;
    }

    public static Item addItem(String name, Item item) {
        items.put(name, item);
        itemGroups.put(item, currentModInfo);
        return item;
    }

    public static Class addTileEntity(String name, Class tileEntityClass) {
        name = name.toLowerCase();
        tileEntities.put(name, tileEntityClass);
        return tileEntityClass;
    }

    public static EffectBase addPotionEffect(String name, boolean isBad, int color, boolean goodEffect) {
        EffectBase effect = new EffectBase(name, isBad, color);
        effects.put(name, effect);
        ObjectLists.addEffect(goodEffect ? "buffs" : "debuffs", effect, name);
        return effect;
    }

    public static void addSpecialEntity(String name, Class<? extends Entity> entityClass, Constructor<? extends Entity> specialEntityConstructor) {
        specialEntities.put(name, entityClass);
        specialEntityConstructors.put(entityClass, specialEntityConstructor);
    }

    public static void addDamageSource(String name, DamageSource damageSource) {
        name = name.toLowerCase();
        damageSources.put(name, damageSource);
    }

    public static void addSound(String name, ModInfo modInfo, String path) {
        name = name.toLowerCase();
        ResourceLocation resourceLocation = new ResourceLocation(modInfo.modid, path);
        SoundEvent soundEvent = new SoundEvent(resourceLocation);
        soundEvent.setRegistryName(resourceLocation);
        sounds.put(name, soundEvent);
    }

    public static Block getBlock(String name) {
        if (!blocks.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return blocks.get(name);
    }

    public static Item getItem(String name) {
        if (!items.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return items.get(name);
    }

    public static RegistryObject<FlowingFluid> getFluid(String name) {
        if (!fluids.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return fluids.get(name);
    }

    public static Class getTileEntity(String name) {
        if (!tileEntities.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return tileEntities.get(name);
    }

    public static EffectBase getEffect(String name) {
        if (!effects.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return effects.get(name);
    }

    public static DamageSource getDamageSource(String name) {
        if (!damageSources.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return damageSources.get(name);
    }

    public static SoundEvent getSound(String name) {
        if (!sounds.containsKey(name = name.toLowerCase())) {
            return null;
        }
        return sounds.get(name);
    }

    @SubscribeEvent
    public void registerBlocks(RegistryEvent.Register<Block> event) {
        for (Block block : blocks.values()) {
            LycanitesMobs.logDebug("Item", "Registering block: " + block.getRegistryName());
            if (block.getRegistryName() == null) {
                LycanitesMobs.logWarning("", "Block: " + block + " has no Registry Name!");
            }
            event.getRegistry().register((IForgeRegistryEntry)block);
        }
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        for (Item item : items.values()) {
            LycanitesMobs.logDebug("Item", "Registering item: " + item.getRegistryName());
            if (item.getRegistryName() == null) {
                LycanitesMobs.logWarning("", "Item: " + item + " has no Registry Name!");
            }
            event.getRegistry().register((IForgeRegistryEntry)item);
        }
        Item.Properties blockItemProperties = new Item.Properties().func_200916_a(ItemManager.getInstance().blocksGroup);
        for (Block block : blocks.values()) {
            BlockItem blockItem = new BlockItem(block, blockItemProperties);
            blockItem.setRegistryName(block.getRegistryName());
            LycanitesMobs.logDebug("Item", "Registering item block: " + blockItem.getRegistryName());
            if (block.getRegistryName() == null) {
                LycanitesMobs.logWarning("", "Block Item: " + blockItem + " has no Registry Name!");
            }
            event.getRegistry().register((IForgeRegistryEntry)blockItem);
        }
    }

    @SubscribeEvent
    public void registerEffects(RegistryEvent.Register<Effect> event) {
        for (EffectBase effect : effects.values()) {
            event.getRegistry().register((IForgeRegistryEntry)effect);
        }
    }

    @SubscribeEvent
    public void registerEntities(RegistryEvent.Register<EntityType<?>> event) {
        for (String entityName : specialEntities.keySet()) {
            EntityType.Builder entityTypeBuilder = EntityType.Builder.func_220322_a((EntityType.IFactory)EntityFactory.getInstance(), (EntityClassification)EntityClassification.MISC);
            entityTypeBuilder.setTrackingRange(10);
            entityTypeBuilder.setUpdateInterval(3);
            entityTypeBuilder.setShouldReceiveVelocityUpdates(true);
            entityTypeBuilder.func_200705_b();
            EntityType entityType = entityTypeBuilder.func_206830_a(entityName);
            entityType.setRegistryName("lycanitesmobs", entityName);
            EntityFactory.getInstance().addEntityType(entityType, specialEntityConstructors.get(specialEntities.get(entityName)), entityName);
            specialEntityTypes.put(specialEntities.get(entityName), (EntityType<? extends Entity>)entityType);
            event.getRegistry().register((IForgeRegistryEntry)entityType);
        }
    }

    @SubscribeEvent
    public void registerSounds(RegistryEvent.Register<SoundEvent> event) {
        for (SoundEvent soundEvent : sounds.values()) {
            if (soundEvent.getRegistryName() == null) {
                LycanitesMobs.logWarning("", "Sound: " + soundEvent + " has no Registry Name!");
            }
            event.getRegistry().register((IForgeRegistryEntry)soundEvent);
        }
    }

    @SubscribeEvent
    public void registerContainers(RegistryEvent.Register<ContainerType<?>> event) {
        event.getRegistry().register(CreatureContainer.TYPE);
        event.getRegistry().register(SummoningPedestalContainer.TYPE);
        event.getRegistry().register(EquipmentForgeContainer.TYPE);
    }

    @SubscribeEvent
    public void registerTileEntities(RegistryEvent.Register<TileEntityType<?>> event) {
        TileEntityType summoningPedestalType = TileEntityType.Builder.func_223042_a(TileEntitySummoningPedestal::new, (Block[])new Block[]{ObjectManager.getBlock("summoningpedestal")}).func_206865_a(null);
        summoningPedestalType.setRegistryName("lycanitesmobs", "summoningpedestal");
        event.getRegistry().register((IForgeRegistryEntry)summoningPedestalType);
        tileEntityTypes.put(TileEntitySummoningPedestal.class, (TileEntityType<? extends TileEntity>)summoningPedestalType);
        TileEntityType equipmentForgeType = TileEntityType.Builder.func_223042_a(TileEntityEquipmentForge::new, (Block[])new Block[]{ObjectManager.getBlock("equipmentforge_lesser"), ObjectManager.getBlock("equipmentforge_greater"), ObjectManager.getBlock("equipmentforge_master")}).func_206865_a(null);
        equipmentForgeType.setRegistryName("lycanitesmobs", "equipmentforge");
        event.getRegistry().register((IForgeRegistryEntry)equipmentForgeType);
        tileEntityTypes.put(TileEntityEquipmentForge.class, (TileEntityType<? extends TileEntity>)equipmentForgeType);
    }

    static {
        blocks = new HashMap<String, Block>();
        items = new HashMap<String, Item>();
        itemGroups = new HashMap<Item, ModInfo>();
        fluids = new HashMap<String, RegistryObject<FlowingFluid>>();
        buckets = new HashMap<Block, Item>();
        tileEntities = new HashMap<String, Class>();
        effects = new HashMap<String, EffectBase>();
        sounds = new HashMap<String, SoundEvent>();
        specialEntities = new HashMap<String, Class<? extends Entity>>();
        specialEntityConstructors = new HashMap<Class<? extends Entity>, Constructor<? extends Entity>>();
        specialEntityTypes = new HashMap<Class<? extends Entity>, EntityType<? extends Entity>>();
        tileEntityTypes = new HashMap<Class<? extends TileEntity>, TileEntityType<? extends TileEntity>>();
        damageSources = new HashMap<String, DamageSource>();
        nextSpecialEntityNetworkId = 0;
    }
}

