/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.ClientManager;
import com.lycanitesmobs.GameEventListener;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.client.ClientProxy;
import com.lycanitesmobs.client.ModelManager;
import com.lycanitesmobs.client.TextureManager;
import com.lycanitesmobs.core.Effects;
import com.lycanitesmobs.core.FileLoader;
import com.lycanitesmobs.core.IProxy;
import com.lycanitesmobs.core.ServerProxy;
import com.lycanitesmobs.core.StreamLoader;
import com.lycanitesmobs.core.capabilities.ExtendedEntityStorage;
import com.lycanitesmobs.core.capabilities.ExtendedPlayerStorage;
import com.lycanitesmobs.core.capabilities.IExtendedEntity;
import com.lycanitesmobs.core.capabilities.IExtendedPlayer;
import com.lycanitesmobs.core.command.CommandManager;
import com.lycanitesmobs.core.compatibility.DLDungeons;
import com.lycanitesmobs.core.config.ConfigDebug;
import com.lycanitesmobs.core.config.CoreConfig;
import com.lycanitesmobs.core.dungeon.DungeonManager;
import com.lycanitesmobs.core.entity.ExtendedEntity;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.helpers.LMReflectionHelper;
import com.lycanitesmobs.core.info.AltarInfo;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.ElementManager;
import com.lycanitesmobs.core.info.ItemManager;
import com.lycanitesmobs.core.info.ModInfo;
import com.lycanitesmobs.core.info.ObjectLists;
import com.lycanitesmobs.core.info.projectile.ProjectileManager;
import com.lycanitesmobs.core.item.consumable.ItemHalloweenTreat;
import com.lycanitesmobs.core.item.consumable.ItemWinterGift;
import com.lycanitesmobs.core.item.equipment.EquipmentPartManager;
import com.lycanitesmobs.core.mobevent.MobEventListener;
import com.lycanitesmobs.core.mobevent.MobEventManager;
import com.lycanitesmobs.core.network.PacketHandler;
import com.lycanitesmobs.core.spawner.SpawnerEventListener;
import com.lycanitesmobs.core.spawner.SpawnerManager;
import com.lycanitesmobs.core.worldgen.WorldGenManager;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.RangedAttribute;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityInject;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.event.server.FMLServerStartingEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="lycanitesmobs")
public class LycanitesMobs {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final String MODID = "lycanitesmobs";
    public static final String name = "Lycanites Mobs";
    public static final String versionNumber = "2.2.0.0";
    public static final String versionMC = "1.15.1";
    public static final String version = "2.2.0.0 - MC 1.15.1";
    public static final String website = "http://lycanitesmobs.com";
    public static final String websiteAPI = "http://api.lycanitesmobs.com";
    public static final String twitter = "https://twitter.com/Lycanite05";
    public static final String patreon = "https://www.patreon.com/lycanite";
    public static final String discord = "https://discord.gg/bFpV3z4";
    public static final PacketHandler packetHandler = new PacketHandler();
    public static ModInfo modInfo;
    public static boolean configReady;
    public static boolean earlyDebug;
    public static IProxy PROXY;
    @CapabilityInject(value=IExtendedEntity.class)
    public static final Capability<IExtendedEntity> EXTENDED_ENTITY;
    @CapabilityInject(value=IExtendedPlayer.class)
    public static final Capability<IExtendedPlayer> EXTENDED_PLAYER;
    public static Effects EFFECTS;

    public LycanitesMobs() {
        modInfo = new ModInfo(this, name, 1000);
        FileLoader.initAll(LycanitesMobs.modInfo.modid);
        StreamLoader.initAll(LycanitesMobs.modInfo.modid);
        CoreConfig.buildSpec();
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, CoreConfig.SPEC);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(this::commonSetup);
        modEventBus.addListener(this::clientSetup);
        modEventBus.addListener(this::serverStarting);
        modEventBus.addListener(this::enqueueIMC);
        modEventBus.addListener(this::processIMC);
        modEventBus.register((Object)ObjectManager.getInstance());
        modEventBus.register((Object)ItemManager.getInstance());
        modEventBus.register((Object)CreatureManager.getInstance());
        modEventBus.register((Object)ProjectileManager.getInstance());
        modEventBus.register((Object)WorldGenManager.getInstance());
        PROXY.registerEvents();
        ItemManager.FLUIDS.register(modEventBus);
        MinecraftForge.EVENT_BUS.register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)CommandManager.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)new GameEventListener());
        MinecraftForge.EVENT_BUS.register((Object)SpawnerEventListener.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)MobEventManager.getInstance());
        MinecraftForge.EVENT_BUS.register((Object)MobEventListener.getInstance());
        packetHandler.register();
        this.loadContent();
    }

    public void loadContent() {
        ObjectLists.createVanillaLists();
        EFFECTS = new Effects();
        ItemManager.getInstance().startup(modInfo);
        EquipmentPartManager.getInstance().loadAllFromJson(modInfo);
        ElementManager.getInstance().loadAllFromJson(modInfo);
        CreatureManager.getInstance().startup(modInfo);
        ProjectileManager.getInstance().startup(modInfo);
        SpawnerManager.getInstance().loadAllFromJson(modInfo);
        AltarInfo.createAltars();
        MobEventManager.getInstance().loadAllFromJson(modInfo);
        DungeonManager.getInstance().loadAllFromJson(modInfo);
        ItemHalloweenTreat.createObjectLists();
        ItemWinterGift.createObjectLists();
    }

    private void commonSetup(FMLCommonSetupEvent event) {
        configReady = true;
        ObjectManager.setCurrentModInfo(modInfo);
        this.loadConfigs();
        CapabilityManager.INSTANCE.register(IExtendedPlayer.class, (Capability.IStorage)new ExtendedPlayerStorage(), ExtendedPlayer::new);
        CapabilityManager.INSTANCE.register(IExtendedEntity.class, (Capability.IStorage)new ExtendedEntityStorage(), ExtendedEntity::new);
        LMReflectionHelper.setPrivateFinalValue(RangedAttribute.class, (RangedAttribute)SharedMonsterAttributes.field_111267_a, 100000, "maximumValue");
        DLDungeons.init();
        WorldGenManager.getInstance().addToBiomes();
    }

    @SubscribeEvent
    public void clientSetup(FMLClientSetupEvent event) {
        ClientManager.getInstance().initLanguageManager();
        ClientManager.getInstance().registerScreens();
        ClientManager.getInstance().registerEvents();
        TextureManager.getInstance().createTextures(modInfo);
        ModelManager.getInstance().createModels();
        ClientManager.getInstance().initRenderRegister();
    }

    @SubscribeEvent
    public void serverStarting(FMLServerStartingEvent event) {
    }

    public void loadConfigs() {
        ItemManager.getInstance().loadConfig();
        CreatureManager.getInstance().loadConfig();
        MobEventManager.getInstance().loadConfig();
        AltarInfo.loadGlobalSettings();
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
    }

    public static void logInfo(String key, String message) {
        if ("".equals(key) || !configReady && earlyDebug || ConfigDebug.INSTANCE.isEnabled(key.toLowerCase())) {
            LOGGER.info("[LycanitesMobs] [Info] [" + key + "] " + message);
        }
    }

    public static void logDebug(String key, String message) {
        if ("".equals(key) || !configReady && earlyDebug || ConfigDebug.INSTANCE.isEnabled(key.toLowerCase())) {
            LOGGER.debug("[LycanitesMobs] [Debug] [" + key + "] " + message);
        }
    }

    public static void logWarning(String key, String message) {
        if ("".equals(key) || !configReady && earlyDebug || ConfigDebug.INSTANCE.isEnabled(key.toLowerCase())) {
            LOGGER.warn("[LycanitesMobs] [WARNING] [" + key + "] " + message);
        }
    }

    public static void logError(String message) {
        LOGGER.error("[LycanitesMobs] " + message);
    }

    static {
        configReady = false;
        earlyDebug = false;
        PROXY = (IProxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
        EXTENDED_ENTITY = null;
        EXTENDED_PLAYER = null;
    }
}

