/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.ExtendedWorld;
import com.lycanitesmobs.LycanitesMobs;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.Utilities;
import com.lycanitesmobs.core.capabilities.CapabilityProviderEntity;
import com.lycanitesmobs.core.capabilities.CapabilityProviderPlayer;
import com.lycanitesmobs.core.config.ConfigDebug;
import com.lycanitesmobs.core.entity.BaseCreatureEntity;
import com.lycanitesmobs.core.entity.CustomItemEntity;
import com.lycanitesmobs.core.entity.ExtendedEntity;
import com.lycanitesmobs.core.entity.ExtendedPlayer;
import com.lycanitesmobs.core.entity.RideableCreatureEntity;
import com.lycanitesmobs.core.entity.TameableCreatureEntity;
import com.lycanitesmobs.core.info.ItemConfig;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Effects;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.event.entity.EntityMountEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.LivingSetAttackTargetEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.FillBucketEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class GameEventListener {
    @SubscribeEvent
    public void onWorldLoading(WorldEvent.Load event) {
        if (!(event.getWorld() instanceof World)) {
            return;
        }
        ExtendedWorld.getForWorld((World)event.getWorld());
    }

    @SubscribeEvent
    public void onAttachCapabilities(AttachCapabilitiesEvent<Entity> event) {
        if (event.getObject() instanceof LivingEntity) {
            event.addCapability(new ResourceLocation("lycanitesmobs", "entity"), (ICapabilityProvider)new CapabilityProviderEntity());
        }
        if (event.getObject() instanceof PlayerEntity) {
            event.addCapability(new ResourceLocation("lycanitesmobs", "player"), (ICapabilityProvider)new CapabilityProviderPlayer());
        }
    }

    @SubscribeEvent
    public void onPlayerClone(PlayerEvent.Clone event) {
        ExtendedPlayer extendedPlayer = ExtendedPlayer.getForPlayer(event.getOriginal());
        if (extendedPlayer != null) {
            extendedPlayer.backupPlayer();
        }
    }

    @SubscribeEvent
    public void onEntityConstructing(EntityEvent.EntityConstructing event) {
        if (event.getEntity() == null || event.getEntity().func_130014_f_() == null || event.getEntity().func_130014_f_().field_72995_K) {
            return;
        }
        if (!(event.getEntity() instanceof LivingEntity) && ExtendedEntity.FORCE_REMOVE_ENTITY_IDS != null && ExtendedEntity.FORCE_REMOVE_ENTITY_IDS.size() > 0) {
            LycanitesMobs.logDebug("ForceRemoveEntity", "Forced entity removal, checking: " + event.getEntity().func_200200_C_());
            for (String string : ExtendedEntity.FORCE_REMOVE_ENTITY_IDS) {
                if (!string.equalsIgnoreCase(event.getEntity().func_200600_R().getRegistryName().toString())) continue;
                event.getEntity().func_70106_y();
                break;
            }
        }
    }

    @SubscribeEvent
    public void onLivingDeathEvent(LivingDeathEvent event) {
        PlayerEntity player;
        ExtendedPlayer extendedPlayer;
        LivingEntity entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(entity);
        if (extendedEntity != null) {
            extendedEntity.onDeath();
        }
        if (entity instanceof PlayerEntity && (extendedPlayer = ExtendedPlayer.getForPlayer(player = (PlayerEntity)entity)) != null) {
            extendedPlayer.onDeath();
        }
    }

    @SubscribeEvent
    public void onEntityUpdate(LivingEvent.LivingUpdateEvent event) {
        PlayerEntity player;
        ExtendedPlayer playerExt;
        LivingEntity entity = event.getEntityLiving();
        if (entity == null) {
            return;
        }
        ExtendedEntity extendedEntity = ExtendedEntity.getForEntity(entity);
        if (extendedEntity != null) {
            extendedEntity.onUpdate();
        }
        if (entity instanceof PlayerEntity && (playerExt = ExtendedPlayer.getForPlayer(player = (PlayerEntity)entity)) != null) {
            playerExt.onUpdate();
        }
    }

    @SubscribeEvent
    public void onEntityInteract(PlayerInteractEvent.EntityInteract event) {
        PlayerEntity player = event.getPlayer();
        Entity entity = event.getTarget();
        if (player == null || !(entity instanceof LivingEntity)) {
            return;
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAttackTarget(LivingSetAttackTargetEvent event) {
        LivingEntity targetEntity = event.getTarget();
        if (event.getEntityLiving() == null || targetEntity == null) {
            return;
        }
        if (!event.getEntityLiving().func_70644_a(Effects.field_76441_p) && targetEntity.func_82150_aj()) {
            if (event.isCancelable()) {
                event.setCanceled(true);
            }
            return;
        }
        if (event.getEntityLiving() instanceof MobEntity && targetEntity instanceof BaseCreatureEntity && !((BaseCreatureEntity)targetEntity).canBeTargetedBy(event.getEntityLiving()) && event.isCancelable()) {
            event.setCanceled(true);
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onLivingHurt(LivingHurtEvent event) {
        ExtendedEntity attackerExtendedEntity;
        EntityDamageSource entityDamageSource;
        if (event.isCanceled()) {
            return;
        }
        if (event.getSource() == null || event.getEntityLiving() == null) {
            return;
        }
        LivingEntity damagedEntity = event.getEntityLiving();
        ExtendedEntity damagedEntityExt = ExtendedEntity.getForEntity(damagedEntity);
        if (event.getSource() instanceof EntityDamageSource && (entityDamageSource = (EntityDamageSource)event.getSource()).func_76346_g() != null && entityDamageSource.func_76346_g() instanceof LivingEntity && (attackerExtendedEntity = ExtendedEntity.getForEntity((LivingEntity)entityDamageSource.func_76346_g())) != null) {
            attackerExtendedEntity.setLastAttackedEntity(damagedEntity);
        }
        if (damagedEntity.func_184187_bx() != null && damagedEntity.func_184187_bx() instanceof RideableCreatureEntity) {
            RideableCreatureEntity creatureRideable = (RideableCreatureEntity)event.getEntityLiving().func_184187_bx();
            if (creatureRideable.isBlocking()) {
                event.setAmount(0.0f);
                event.setCanceled(true);
                return;
            }
            if ("inWall".equals(event.getSource().field_76373_n)) {
                event.setAmount(0.0f);
                event.setCanceled(true);
                return;
            }
            if (!creatureRideable.isInvulnerableTo(event.getSource().field_76373_n, event.getSource(), event.getAmount())) {
                event.setAmount(0.0f);
                event.setCanceled(true);
                return;
            }
        }
        if (damagedEntityExt != null && damagedEntityExt.isPickedUp() && "inWall".equals(event.getSource().field_76373_n)) {
            event.setAmount(0.0f);
            event.setCanceled(true);
            return;
        }
    }

    @SubscribeEvent
    public void onLivingDrops(LivingDropsEvent event) {
        World world = event.getEntityLiving().func_130014_f_();
        if (ItemConfig.seasonalItemDropChance > 0.0 && (Utilities.isHalloween() || Utilities.isYuletide() || Utilities.isNewYear())) {
            boolean noSeaonalDrop = false;
            boolean alwaysDrop = false;
            if (event.getEntityLiving() instanceof BaseCreatureEntity) {
                if (((BaseCreatureEntity)event.getEntityLiving()).isMinion()) {
                    noSeaonalDrop = true;
                }
                if (((BaseCreatureEntity)event.getEntityLiving()).getSubspecies() != null) {
                    alwaysDrop = true;
                }
            }
            Item seasonalItem = null;
            if (Utilities.isHalloween()) {
                seasonalItem = ObjectManager.getItem("halloweentreat");
            }
            if (Utilities.isYuletide()) {
                seasonalItem = ObjectManager.getItem("wintergift");
                if (Utilities.isYuletidePeak() && world.field_73012_v.nextBoolean()) {
                    seasonalItem = ObjectManager.getItem("wintergiftlarge");
                }
            }
            if (seasonalItem != null && !noSeaonalDrop && (alwaysDrop || (double)event.getEntityLiving().func_70681_au().nextFloat() < ItemConfig.seasonalItemDropChance)) {
                ItemStack dropStack = new ItemStack((IItemProvider)seasonalItem, 1);
                CustomItemEntity entityItem = new CustomItemEntity(world, event.getEntityLiving().func_213303_ch().func_82615_a(), event.getEntityLiving().func_213303_ch().func_82617_b(), event.getEntityLiving().func_213303_ch().func_82616_c(), dropStack);
                entityItem.func_174867_a(10);
                world.func_217376_c((Entity)entityItem);
            }
        }
    }

    @SubscribeEvent
    public void onBucketFill(FillBucketEvent event) {
        World world = event.getWorld();
        RayTraceResult target = event.getTarget();
        if (target == null || !(target instanceof BlockRayTraceResult)) {
            return;
        }
        BlockPos pos = ((BlockRayTraceResult)target).func_216350_a();
        Block block = world.func_180495_p(pos).func_177230_c();
        Item bucket = ObjectManager.buckets.get(block);
        if (bucket != null && world.func_204610_c(pos).func_206882_g() == 0) {
            world.func_217377_a(pos, true);
        }
        if (bucket == null) {
            return;
        }
        event.setFilledBucket(new ItemStack((IItemProvider)bucket));
        event.setResult(Event.Result.ALLOW);
    }

    @SubscribeEvent
    public void onBlockBreak(BlockEvent.BreakEvent event) {
        if (event.getState() == null || event.getWorld() == null || event.getPlayer() == null || event.getWorld().func_201670_d() || event.isCanceled()) {
            return;
        }
        ExtendedPlayer extendedPlayer = ExtendedPlayer.getForPlayer(event.getPlayer());
        if (extendedPlayer == null) {
            return;
        }
        extendedPlayer.setJustBrokenBlock(event.getState());
    }

    @SubscribeEvent
    public void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        BaseCreatureEntity baseCreatureEntity;
        LivingEntity entity;
        if (event.isSpawner() && (entity = event.getEntityLiving()) instanceof BaseCreatureEntity && !(baseCreatureEntity = (BaseCreatureEntity)entity).checkSpawnGroupLimit(event.getWorld().func_201672_e(), event.getSpawner().func_177221_b(), 16.0)) {
            event.setResult(Event.Result.DENY);
        }
    }

    @SubscribeEvent
    public void onEntityMount(EntityMountEvent event) {
        if (!(event.isDismounting() && event.getEntityMounting() instanceof PlayerEntity && event.getEntityBeingMounted() instanceof RideableCreatureEntity)) {
            return;
        }
        event.setCanceled(event.getEntityMounting().func_225608_bj_());
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public void onGameOverlay(RenderGameOverlayEvent.Text event) {
        Entity mouseOverEntity;
        if (!((Boolean)ConfigDebug.INSTANCE.creatureOverlay.get()).booleanValue()) {
            return;
        }
        RayTraceResult mouseOver = Minecraft.func_71410_x().field_71476_x;
        if (mouseOver instanceof EntityRayTraceResult && (mouseOverEntity = ((EntityRayTraceResult)mouseOver).func_216348_a()) instanceof BaseCreatureEntity) {
            BaseCreatureEntity mouseOverCreature = (BaseCreatureEntity)mouseOverEntity;
            event.getLeft().add("");
            event.getLeft().add("Target Creature: " + mouseOverCreature.func_200200_C_().func_150254_d());
            event.getLeft().add("Distance To player: " + mouseOverCreature.func_70032_d((Entity)Minecraft.func_71410_x().field_71439_g));
            event.getLeft().add("Elements: " + mouseOverCreature.creatureInfo.getElementNames(mouseOverCreature.getSubspecies()).func_150254_d());
            event.getLeft().add("Subspecies: " + mouseOverCreature.getSubspeciesIndex());
            event.getLeft().add("Level: " + mouseOverCreature.getLevel());
            event.getLeft().add("Size: " + mouseOverCreature.sizeScale);
            event.getLeft().add("");
            event.getLeft().add("Health: " + mouseOverCreature.func_110143_aJ() + "/" + mouseOverCreature.func_110138_aP() + " Fresh: " + mouseOverCreature.creatureStats.getHealth());
            event.getLeft().add("Speed: " + mouseOverCreature.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() + "/" + mouseOverCreature.creatureStats.getSpeed());
            event.getLeft().add("");
            event.getLeft().add("Defense: " + mouseOverCreature.creatureStats.getDefense());
            event.getLeft().add("Armor: " + mouseOverCreature.func_70658_aO());
            event.getLeft().add("");
            event.getLeft().add("Damage: " + mouseOverCreature.creatureStats.getDamage());
            event.getLeft().add("Melee Speed: " + mouseOverCreature.creatureStats.getAttackSpeed());
            event.getLeft().add("Melee Range: " + mouseOverCreature.getPhysicalRange());
            event.getLeft().add("Ranged Speed: " + mouseOverCreature.creatureStats.getRangedSpeed());
            event.getLeft().add("Pierce: " + mouseOverCreature.creatureStats.getPierce());
            event.getLeft().add("");
            event.getLeft().add("Effect Duration: " + mouseOverCreature.creatureStats.getEffect() + " Base Seconds");
            event.getLeft().add("Effect Amplifier: x" + mouseOverCreature.creatureStats.getAmplifier());
            event.getLeft().add("");
            event.getLeft().add("Has Attack Target: " + mouseOverCreature.hasAttackTarget());
            event.getLeft().add("Has Avoid Target: " + mouseOverCreature.hasAvoidTarget());
            event.getLeft().add("Has Master Target: " + mouseOverCreature.hasMaster());
            event.getLeft().add("Has Parent Target: " + mouseOverCreature.hasParent());
            if (mouseOverEntity instanceof TameableCreatureEntity) {
                TameableCreatureEntity mouseOverTameable = (TameableCreatureEntity)mouseOverCreature;
                event.getLeft().add("");
                event.getLeft().add("Owner ID: " + (mouseOverTameable.getOwnerId() != null ? mouseOverTameable.getOwnerId().toString() : "None"));
                event.getLeft().add("Owner Name: " + mouseOverTameable.getOwnerName().func_150254_d());
            }
        }
    }
}

