/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs;

import com.lycanitesmobs.client.ClientEventListener;
import com.lycanitesmobs.client.KeyHandler;
import com.lycanitesmobs.client.gui.CreatureInventoryScreen;
import com.lycanitesmobs.client.gui.EquipmentForgeScreen;
import com.lycanitesmobs.client.gui.SummoningPedestalScreen;
import com.lycanitesmobs.client.gui.beastiary.SummoningBeastiaryScreen;
import com.lycanitesmobs.client.gui.overlays.BaseOverlay;
import com.lycanitesmobs.client.localisation.LanguageLoader;
import com.lycanitesmobs.client.localisation.LanguageManager;
import com.lycanitesmobs.client.renderer.RenderRegister;
import com.lycanitesmobs.core.container.CreatureContainer;
import com.lycanitesmobs.core.container.EquipmentForgeContainer;
import com.lycanitesmobs.core.container.SummoningPedestalContainer;
import com.lycanitesmobs.core.info.CreatureManager;
import com.lycanitesmobs.core.info.CreatureType;
import com.lycanitesmobs.core.item.ItemColorCustomSpawnEgg;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.color.IItemColor;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class ClientManager {
    public static int GL_TEXTURE0 = 33984;
    public static int GL_TEXTURE1 = 33986;
    public static int GL_FULL_BRIGHT = 0xF000F0;
    public static int FULL_BRIGHT = 240;
    protected static ClientManager INSTANCE;
    protected FontRenderer fontRenderer;

    public static ClientManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ClientManager();
        }
        return INSTANCE;
    }

    public void initLanguageManager() {
        LanguageManager.getInstance();
    }

    public void registerScreens() {
        ScreenManager.func_216911_a(CreatureContainer.TYPE, CreatureInventoryScreen::new);
        ScreenManager.func_216911_a(SummoningPedestalContainer.TYPE, SummoningPedestalScreen::new);
        ScreenManager.func_216911_a(EquipmentForgeContainer.TYPE, EquipmentForgeScreen::new);
    }

    public void registerEvents() {
        MinecraftForge.EVENT_BUS.register((Object)new KeyHandler(Minecraft.func_71410_x()));
        MinecraftForge.EVENT_BUS.register((Object)new BaseOverlay(Minecraft.func_71410_x()));
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventListener());
        IResourceManager resourceManager = Minecraft.func_71410_x().func_195551_G();
        if (resourceManager instanceof IReloadableResourceManager) {
            ((IReloadableResourceManager)resourceManager).func_219534_a((IFutureReloadListener)LanguageLoader.getInstance());
        }
    }

    public void initRenderRegister() {
        RenderRegister renderRegister = new RenderRegister();
        renderRegister.registerModelLoaders();
        renderRegister.registerRenderFactories();
    }

    public PlayerEntity getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    public void displayGuiScreen(String screenName, PlayerEntity player) {
        if ("beastiary".equals(screenName)) {
            Minecraft.func_71410_x().func_147108_a((Screen)new SummoningBeastiaryScreen(player));
        }
    }

    public FontRenderer getFontRenderer() {
        return Minecraft.func_71410_x().field_71466_p;
    }

    @SubscribeEvent
    public void registerItemColors(ColorHandlerEvent.Item event) {
        for (CreatureType creatureType : CreatureManager.getInstance().creatureTypes.values()) {
            if (creatureType.spawnEgg == null) continue;
            event.getItemColors().func_199877_a((IItemColor)new ItemColorCustomSpawnEgg(), new IItemProvider[]{creatureType.spawnEgg});
        }
    }
}

