/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.script;

import java.util.ArrayList;
import javax.script.Bindings;
import me.andre111.mambience.accessor.Accessor;
import me.andre111.mambience.player.MAPlayer;
import me.andre111.mambience.scan.BlockScanner;
import me.andre111.mambience.script.MAScriptEngine;

public class Variables {
    private static ArrayList<Variable> variables = new ArrayList();

    public static void init() {
        MAScriptEngine se = MAScriptEngine.getInstance();
        se.evalJS("Player = {};");
        se.evalJS("World = {};");
        se.evalJS("Scanner = {};");
        se.evalJS("Internal = {};");
        se.evalJS("Internal.Cooldown = {};");
        se.evalJS("Internal.Function = {};");
        se.compileScript("function Internal_Variables() {   Player.X = __px;   Player.Y = __py;   Player.Z = __pz;   Player.SunLight = __psunl;   Player.BlockLight = __pblockl;   Player.Light = __pl;   Player.Submerged = __psubm;   Player.IsExposed = __pexpo;   Player.Health = __phealth;   Player.Food = __pfood;   World.Time = __wt;   World.IsRaining = __wrain;   World.MoonPhase = __wmoon;   World.Biome = __wbiome;   Scanner.BlockSize = __sblocks;   Scanner.BiomeSize = __sbiomes;   Scanner.AverageSkyLight = __savgskylight;   Scanner.AverageLight = __savglight;   Scanner.AverageTemperature = __savgtemp;   Scanner.AverageHumidity = __savghum;}");
    }

    public static void update(MAPlayer maplayer) {
        Accessor accessor = maplayer.getAccessor();
        BlockScanner scanner = maplayer.getScanner();
        MAScriptEngine se = MAScriptEngine.getInstance();
        int x = accessor.getX();
        int y = accessor.getY();
        int z = accessor.getZ();
        boolean exposed = Variables.fastExposedCheck(accessor, x, y, z);
        Bindings bd = se.getEngineScopeBindings();
        bd.put("__px", (Object)x);
        bd.put("__py", (Object)y);
        bd.put("__pz", (Object)z);
        bd.put("__psunl", (Object)accessor.getSkyLight(x, y, z));
        bd.put("__pblockl", (Object)accessor.getBlockLight(x, y, z));
        bd.put("__pl", (Object)accessor.getLight(x, y, z));
        bd.put("__psubm", (Object)accessor.isSubmerged());
        bd.put("__pexpo", (Object)exposed);
        bd.put("__phealth", (Object)accessor.getHealth());
        bd.put("__pfood", (Object)accessor.getFoodLevel());
        bd.put("__wt", (Object)accessor.getDayTime());
        bd.put("__wrain", (Object)accessor.isRaining());
        bd.put("__wmoon", (Object)(accessor.getFullTime() / 24000L % 8L));
        bd.put("__wbiome", (Object)accessor.getBiome(x, y, z));
        bd.put("__sblocks", (Object)scanner.getScanBlockCount());
        bd.put("__sbiomes", (Object)scanner.getScanBiomeCount());
        bd.put("__savgskylight", (Object)scanner.getAverageSkyLight());
        bd.put("__savglight", (Object)scanner.getAverageLight());
        bd.put("__savgtemp", (Object)scanner.getAverageTemperature());
        bd.put("__savghum", (Object)scanner.getAverageHumidity());
        se.invokeFunction("Internal_Variables");
        StringBuilder sb = new StringBuilder("");
        for (Variable variable : variables) {
            int count = 0;
            if (variable instanceof BlockCountVariable) {
                for (String blocks : ((BlockCountVariable)variable).blocks) {
                    if (blocks == null || scanner.getScanBlockData().get(blocks) == null) continue;
                    count += scanner.getScanBlockData().get(blocks).intValue();
                }
            } else if (variable instanceof BiomeCountVariable) {
                for (String biome : ((BiomeCountVariable)variable).biomes) {
                    if (biome == null || scanner.getScanBiomeData().get(biome) == null) continue;
                    count += scanner.getScanBiomeData().get(biome).intValue();
                }
            }
            sb.append(variable.name + " = " + count + ";");
        }
        se.evalJS(sb.toString());
    }

    private static boolean fastExposedCheck(Accessor accessor, int x, int y, int z) {
        int mx = x + 1;
        int my = y + 1;
        int mz = z + 1;
        for (int cx = mx - 2; cx <= mx; ++cx) {
            for (int cy = my - 2; cy <= my; ++cy) {
                for (int cz = mz - 2; cz <= mz; ++cz) {
                    if (!accessor.getBlock(cx, cy, cz).equals("minecraft:air") || accessor.getSkyLight(cx, cy, cz) <= 4) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static void addBlockCountVariable(String name, String[] blocks) {
        BlockCountVariable variable = new BlockCountVariable();
        variable.name = name;
        variable.blocks = blocks;
        variables.add(variable);
    }

    public static void addBiomeCountVariable(String name, String[] biomes) {
        BiomeCountVariable variable = new BiomeCountVariable();
        variable.name = name;
        variable.biomes = biomes;
        variables.add(variable);
    }

    private static class BiomeCountVariable
    extends Variable {
        public String[] biomes;

        private BiomeCountVariable() {
        }
    }

    private static class BlockCountVariable
    extends Variable {
        public String[] blocks;

        private BlockCountVariable() {
        }
    }

    private static class Variable {
        public String name;

        private Variable() {
        }
    }
}

