/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.script;

import javax.script.Bindings;
import javax.script.Compilable;
import javax.script.CompiledScript;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import me.andre111.mambience.MALogger;

public class MAScriptEngine {
    private static MAScriptEngine INSTANCE;
    private MALogger logger;
    private ScriptEngine scriptEngine;

    public static void createScriptEngine(MALogger logger) {
        ScriptEngineManager man = new ScriptEngineManager(null);
        INSTANCE = new MAScriptEngine(logger, man.getEngineByName("JavaScript"));
    }

    public static MAScriptEngine getInstance() {
        return INSTANCE;
    }

    protected MAScriptEngine(MALogger l, ScriptEngine se) {
        this.logger = l;
        this.scriptEngine = se;
    }

    public Object evalJS(String js) {
        try {
            return this.scriptEngine.eval(js);
        }
        catch (ScriptException ex) {
            this.logger.error("Script failed\n" + js + "\n" + ex.getMessage());
            return null;
        }
    }

    public CompiledScript compileScript(String js) {
        Compilable compilingEngine = (Compilable)((Object)this.scriptEngine);
        try {
            CompiledScript script = compilingEngine.compile(js);
            script.eval(this.scriptEngine.getBindings(100));
            return script;
        }
        catch (ScriptException ex) {
            this.logger.error("Script compilation failed\n" + js + "\n" + ex.getMessage());
            return null;
        }
    }

    public Object invokeFunction(String name) {
        Invocable invocable = (Invocable)((Object)this.scriptEngine);
        try {
            return invocable.invokeFunction(name, new Object[0]);
        }
        catch (NoSuchMethodException | ScriptException ex) {
            this.logger.error("Function invoke failed\n" + name + "\n" + ex.getMessage());
            return null;
        }
    }

    public Bindings getEngineScopeBindings() {
        return this.scriptEngine.getBindings(100);
    }

    public void setValue(String name, Object value) {
        this.scriptEngine.getBindings(100).put(name, value);
    }
}

