/*
 * Decompiled with CFR 0.152.
 */
package me.andre111.mambience.accessor;

import java.util.UUID;
import me.andre111.mambience.accessor.Accessor;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.SoundCategory;
import org.bukkit.block.Biome;
import org.bukkit.block.Block;
import org.bukkit.block.data.Waterlogged;
import org.bukkit.entity.Player;

public class AccessorBukkit
extends Accessor {
    private Player player;

    public AccessorBukkit(UUID playerUUID) {
        super(playerUUID);
    }

    @Override
    public boolean updatePlayerInstance() {
        this.player = Bukkit.getPlayer((UUID)this.playerUUID);
        return this.player != null;
    }

    @Override
    public int getX() {
        return this.player.getLocation().getBlockX();
    }

    @Override
    public int getY() {
        return this.player.getLocation().getBlockY();
    }

    @Override
    public int getZ() {
        return this.player.getLocation().getBlockZ();
    }

    @Override
    public double getHealth() {
        return this.player.getHealth();
    }

    @Override
    public double getFoodLevel() {
        return this.player.getFoodLevel();
    }

    @Override
    public boolean isSubmerged() {
        Block headBlock = this.player.getEyeLocation().getBlock();
        return headBlock.getType() == Material.WATER || headBlock.getType() == Material.BUBBLE_COLUMN || headBlock.getType() == Material.KELP || headBlock.getType() == Material.KELP_PLANT || headBlock.getType() == Material.SEAGRASS || headBlock.getType() == Material.TALL_SEAGRASS || headBlock.getBlockData() instanceof Waterlogged && ((Waterlogged)headBlock.getBlockData()).isWaterlogged();
    }

    @Override
    public void playSound(String sound, float volume, float pitch) {
        this.player.playSound(this.player.getLocation(), sound, SoundCategory.AMBIENT, volume, pitch);
    }

    @Override
    public void stopSound(String sound) {
        this.player.stopSound(sound);
    }

    @Override
    public long getDayTime() {
        return this.player.getWorld().getTime() % 24000L;
    }

    @Override
    public long getFullTime() {
        return this.player.getWorld().getFullTime();
    }

    @Override
    public boolean isRaining() {
        return this.player.getWorld().hasStorm();
    }

    @Override
    public String getBlock(int x, int y, int z) {
        Block block = this.player.getWorld().getBlockAt(x, y, z);
        return "minecraft:" + block.getType().name().toLowerCase();
    }

    @Override
    public String getBiome(int x, int y, int z) {
        Biome biome = this.player.getWorld().getBiome(x, z);
        return "minecraft:" + biome.name().toLowerCase();
    }

    @Override
    public int getLight(int x, int y, int z) {
        Block block = this.player.getWorld().getBlockAt(x, y, z);
        return block.getLightLevel();
    }

    @Override
    public int getBlockLight(int x, int y, int z) {
        Block block = this.player.getWorld().getBlockAt(x, y, z);
        return block.getLightFromBlocks();
    }

    @Override
    public int getSkyLight(int x, int y, int z) {
        Block block = this.player.getWorld().getBlockAt(x, y, z);
        return block.getLightFromSky();
    }

    @Override
    public double getTemperature(int x, int y, int z) {
        return this.player.getWorld().getTemperature(x, z);
    }

    @Override
    public double getHumidity(int x, int y, int z) {
        return this.player.getWorld().getHumidity(x, z);
    }
}

